///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
///
/// =========================================================================
//
// animations using vtk
//
// author: Pierre.Saramito@imag.fr
//
// date: 4 may 2001
//
#include "rheolef/branch.h"
#include "rheolef/iofem.h"
#include "rheolef/iorheo.h"
using namespace rheolef;
using namespace std;

// ====================================================
// yet hard-coded ! TODO: use a -select-contour option
// ====================================================
static int coutour_index = 0;

void
branch::put_header_vtk (ostream& out) const
{
}
void 
branch::put_geometry_vtk (ostream& out) const
{
    // open the data file
    delete_macro (_p_data_out);
    string basename = iorheo::getbasename(out);
    if (basename == "") basename = "output";
    string data_file_name = basename + ".vtk";
    _p_data_out = new_macro (ofstream(data_file_name.c_str()));
    bool verbose = iorheo::getverbose(clog);
    verbose && clog << "! file `" << data_file_name << "' created" << endl;
    *_p_data_out << setbasename(basename)
                 << setprecision(numeric_limits<Float>::digits10);

    field z = iofem::gettopography(out);
    if (z.size() != 0) {
	// elevation view
        check_macro (z.get_approx() == "P1", "unsupported " << z.get_approx()
		<< " elevation field");
        z.put_vtk_2d_elevation_P1 (*_p_data_out);
    } else {
        geo g = operator[](coutour_index).second.get_geo();
	// (*_p_data_out) << vtkdata << g;
	(*_p_data_out) << vtkpolydata << g;
    }
}
void 
branch::put_event_vtk (ostream& out) const
{
    const string& xname  = operator[](coutour_index).first;
    const field&  x      = operator[](coutour_index).second;
    check_macro (x.get_approx() == "P1", "unsupported " << x.get_approx()
	<< " field");
    if (_count_value == 0) put_geometry_vtk (out);
    string label = xname + "_" + itos(_count_value);
    x.put_vtk (*_p_data_out, label, _count_value == 0);
}
void 
branch::put_finalize_vtk (ostream& out) const
{
    if (!_p_data_out) { return; } // no data !
    (*_p_data_out).flush();

    check_macro (_p_data_out, "unexpected null pointer");
    string basename = iorheo::getbasename(*_p_data_out); 
    if (basename == "") basename = "output";
    bool verbose   = iorheo::getverbose(clog);
    bool clean     = iorheo::getclean(clog);
    bool execute   = iorheo::getexecute(clog);
    bool elevation = iorheo::getelevation(out);
    string vtk_name  = basename + ".vtk";
    //
    // run gnocchi
    //
    int status = 0;
    if (execute) {
        string options = (elevation ? "-elevation " : "-noelevation ");
        string command = "gnocchi " + options + vtk_name;
        if (verbose) clog << "! " << command << endl;
        status = system (command.c_str());
  	check_macro (status == 0, "\"" << command << "\" command failed.\n");
    }
    //
    // clear vtk data
    //
    if (clean) {
        string command = "/bin/rm -f " + vtk_name;
        if (verbose) clog << "! " << command << endl;
        status |= system (command.c_str());
    }
    delete_macro (_p_data_out);
    _p_data_out = 0;
}
