#include "rheolef/tiny_element.h"
#include "rheolef/ublas-invert.h"
namespace rheolef
{
  bool is_zero (const Float & x);
  bool have_same_sign (const Float & x, const Float & y);
  bool have_opposite_sign (const Float & x, const Float & y);
  bool belongs_to_band_t (const ublas::vector < Float > &f);
  size_t isolated_vertex_t (const ublas::vector < Float > &f);
  void
    subcompute_matrix_t (const ublas::vector < point > &x,
			 const ublas::vector < Float > &f,
			 ublas::vector < size_t > &j, point & a, point & b,
			 Float & S);
  bool belongs_to_band_T (const ublas::vector < Float > &f);
  bool
    intersection_is_quadrilateral_T (const ublas::vector < Float > &f,
				     quadruplet & q);
  size_t isolated_vertex_T (const ublas::vector < Float > &f);
  void
    subcompute_matrix_triangle_T (const ublas::vector < point > &x,
				  const ublas::vector < Float > &f,
				  ublas::vector < size_t > &j, point & a,
				  point & b, point & c, Float & aire);
  void subcompute_matrix_quadrilateral_T (const ublas::vector < point > &x,
					  const ublas::vector < Float > &f,
					  const quadruplet & q, point & a,
					  point & b, point & c, point & d,
					  Float & aire_Q);


  size_t build_vertex_connex_component (geo & band);
  geo banded_level_set (const field & phi);
  size_t edge_t_iloc (size_t l, size_t m);
  size_t edge_T_iloc (size_t l, size_t m);
  size_t face_T_iloc (size_t l, size_t m, size_t n);
  field zero_level_set (const field & u, const field & phi)
  {
    //  cerr << "Entree zero_level_set" << endl;
    typedef tiny_element element_type;
    bool triangle_3d_only = false;
    const geo & Lambda = phi.get_geo ();
    const space & Vh = phi.get_space ();
    const space & Bh = u.get_space ();
    size_t d = Lambda.dimension ();
    check_macro (phi.get_approx () == "P1",
		 "Only P1 level set function supported");
    check_macro (u.get_approx () == "P1",
		 "Only P1 functions can be processed");
    const size_t not_marked = std::numeric_limits < size_t >::max ();
    std::vector < size_t > marked_vertex (Lambda.n_vertex (), not_marked);
    std::vector < size_t > marked_edge (Lambda.n_edge (), not_marked);
    std::vector < size_t > marked_face (Lambda.n_face (), not_marked);
    std::list < point > vertex_intersection_list;
    std::list < Float > u_at_intersection_list;
    std::list < element_type > element_intersection_list;
    tiny_vector < size_t > dofs (d + 1);
    tiny_vector < size_t > dofs_Bh (d + 1);
    ublas::vector < point > x (d + 1);
    ublas::vector < Float > f (d + 1);
    ublas::vector < size_t > j (d + 1);
    for (size_t i = 0; i < Lambda.size (); i++)
      {
	const geo_element & K = Lambda.element (i);
	Vh.set_dof (K, dofs);
	x.resize (K.size ());
	f.resize (K.size ());
	for (size_t k = 0; k < K.size (); k++)
	  {
	    x[k] = Lambda.vertex (K[k]);
	    f[k] = phi.at (dofs[k]);
	  }
	element_type S;
	bool belongs_to_band = false;
	switch (K.variant ())
	  {
	  case geo_element::t:
	    {
	      belongs_to_band = belongs_to_band_t (f);
	      if (!belongs_to_band)
		break;
	      Bh.set_dof (K, dofs_Bh);
	      //  cerr << " triangle" << endl;
	      point a, b;
	      Float length;
	      Float uk;
	      subcompute_matrix_t (x, f, j, a, b, length);
	      if (is_zero (f[j[1]]) && is_zero (f[j[2]]))
		{
		  // the full edge {j1,j2} is included in the surface mesh:
		  for (size_t k = 0; k < 2; k++)
		    {
		      size_t vertex_idx = K[j[k + 1]];
		      if (marked_vertex[vertex_idx] == not_marked)
			{
			  marked_vertex[vertex_idx] =
			    vertex_intersection_list.size ();
			  vertex_intersection_list.push_back (Lambda.
							      vertex
							      (vertex_idx));
			  // cerr << "Cas 1 : " << u.at(dofs_Bh[j[k+1]]) << endl;
			  u_at_intersection_list.push_back (u.
							    at (dofs_Bh
								[j[k + 1]]));
			}
		    }
		  size_t edge_iloc = edge_t_iloc (j[1], j[2]);
		  size_t edge_idx = K.edge (edge_iloc);
		  if (marked_edge[edge_idx] == not_marked)
		    {
		      marked_edge[edge_idx] =
			element_intersection_list.size ();
		      S.set_name ('e');
		      for (size_t k = 0; k < S.size (); k++)
			{
			  S[k] = marked_vertex[K[j[k + 1]]];
			}
		      element_intersection_list.push_back (S);
		    }
		}
	      else
		{
		  // create the new edge {j1,j2} by intersections:
		  S.set_name ('e');
		  point x[2] = { a, b };
		  for (size_t k = 0; k < 2; k++)
		    {
		      if (!is_zero (f[j[k + 1]]) && !is_zero (f[j[0]]))
			{
			  // xk is inside edge {j0,j[k+1]} of triangle K:
			  size_t edge_iloc = edge_t_iloc (j[0], j[k + 1]);
			  size_t edge_idx = K.edge (edge_iloc);
			  if (marked_edge[edge_idx] == not_marked)
			    {
			      marked_edge[edge_idx] =
				vertex_intersection_list.size ();
			      vertex_intersection_list.push_back (x[k]);
			      // calculate the P1 interpolation at intersection :
			      uk = (f[j[k + 1]] * u.at (dofs_Bh[j[0]])
				    -
				    f[j[0]] * u.at (dofs_Bh[j[k + 1]])) /
				(f[j[k + 1]] - f[j[0]]);
			      //cerr << "Cas 2 : " << uk << endl;
			      u_at_intersection_list.push_back (uk);
			    }
			  S[k] = marked_edge[edge_idx];
			}
		      else
			{	// xk is at edge boundary: a vertex of the 2d mesh
			  size_t vertex_idx =
			    (!is_zero (f[j[0]])) ? K[j[k + 1]] : K[j[0]];
			  if (marked_vertex[vertex_idx] == not_marked)
			    {
			      marked_vertex[vertex_idx] =
				vertex_intersection_list.size ();
			      vertex_intersection_list.push_back (Lambda.
								  vertex
								  (vertex_idx));

			      uk =
				(!is_zero (f[j[0]])) ? u.
				at (dofs_Bh[j[k + 1]]) : u.at (dofs_Bh[j[0]]);
			      //cerr << "Cas 3 : " << uk   << endl;
			      u_at_intersection_list.push_back (uk);
			    }
			  S[k] = marked_vertex[vertex_idx];
			}
		    }
		  if (S[0] != S[1])
		    {
		      // S[0] == S[1] when is_zero(f[j[0]]) but f[j[0]] != 0, i.e. precision pbs
		      element_intersection_list.push_back (S);
		    }
		}
	      break;
	    }
	  case geo_element::T:
	    {
	      belongs_to_band = belongs_to_band_T (f);
	      if (!belongs_to_band)
		break;
	      Bh.set_dof (K, dofs_Bh);
	      //cerr << " Tetrahedron" << endl;
	      quadruplet q;
	      point a, b, c, d;
	      Float aire;
	      Float uk;
	      if (!intersection_is_quadrilateral_T (f, q))
		{
		  subcompute_matrix_triangle_T (x, f, j, a, b, c, aire);
		  if (is_zero (f[j[1]]) && is_zero (f[j[2]])
		      && is_zero (f[j[3]]))
		    {
		      // the full face {j1,j2,j3} is included in the surface mesh:
		      for (size_t k = 0; k < 3; k++)
			{
			  size_t vertex_idx = K[j[k + 1]];
			  if (marked_vertex[vertex_idx] == not_marked)
			    {
			      marked_vertex[vertex_idx] =
				vertex_intersection_list.size ();
			      vertex_intersection_list.push_back (Lambda.
								  vertex
								  (vertex_idx));
			      //      cerr << "Cas 4 : " << u.at(dofs_Bh[j[k+1]]) << endl;
			      u_at_intersection_list.push_back (u.
								at (dofs_Bh
								    [j
								     [k +
								      1]]));

			    }
			}
		      size_t face_iloc = face_T_iloc (j[1], j[2], j[3]);
		      size_t face_idx = K.face (face_iloc);
		      if (marked_face[face_idx] == not_marked)
			{
			  marked_face[face_idx] =
			    element_intersection_list.size ();
			  S.set_name ('t');
			  for (size_t k = 0; k < S.size (); k++)
			    {
			      S[k] = marked_vertex[K[j[k + 1]]];
			    }
			  element_intersection_list.push_back (S);
			}
		    }
		  else
		    {
		      // create the new face {j1,j2,j3} by intersections:
		      S.set_name ('t');
		      point x[3] = { a, b, c };
		      for (size_t k = 0; k < 3; k++)
			{
			  if (!is_zero (f[j[k + 1]]) && !is_zero (f[j[0]]))
			    {
			      // xk is inside edge {j0,j[k+1]} of triangle K:
			      size_t edge_iloc = edge_T_iloc (j[0], j[k + 1]);
			      size_t edge_idx = K.edge (edge_iloc);
			      if (marked_edge[edge_idx] == not_marked)
				{
				  marked_edge[edge_idx] =
				    vertex_intersection_list.size ();
				  vertex_intersection_list.push_back (x[k]);
				  uk = (f[j[k + 1]] * u.at (dofs_Bh[j[0]])
					-
					f[j[0]] * u.at (dofs_Bh[j[k + 1]])) /
				    (f[j[k + 1]] - f[j[0]]);
				  //cerr << "Cas 5 : " << uk << endl;
				  u_at_intersection_list.push_back (uk);

				}
			      S[k] = marked_edge[edge_idx];
			    }
			  else
			    {	// xk is at edge boundary: a vertex of the 2d mesh
			      size_t vertex_idx =
				(!is_zero (f[j[0]])) ? K[j[k + 1]] : K[j[0]];
			      if (marked_vertex[vertex_idx] == not_marked)
				{
				  marked_vertex[vertex_idx] =
				    vertex_intersection_list.size ();
				  vertex_intersection_list.push_back (Lambda.
								      vertex
								      (vertex_idx));
				  uk =
				    (!is_zero (f[j[0]])) ? u.
				    at (dofs_Bh[j[k + 1]]) : u.
				    at (dofs_Bh[j[0]]);
				  //cerr << "Cas 6 : " << uk   << endl; 
				  u_at_intersection_list.push_back (uk);

				}
			      S[k] = marked_vertex[vertex_idx];
			    }
			}
		      if (S[0] != S[1] && S[1] != S[2] && S[2] != S[0])
			{
			  // S[0] == S[j] when is_zero(f[j[0]]) but f[j[0]] != 0, i.e. precision pbs
			  element_intersection_list.push_back (S);
			}
		    }
		}
	      else
		{
		  subcompute_matrix_quadrilateral_T (x, f, q, a, b, c, d,
						     aire);
		  {
		    // create the new quadri face by intersections:
		    S.set_name ('q');
		    point x[4] = { a, b, d, c };
		    size_t s[4] = { q[0], q[2], q[1], q[3] };
		    for (size_t k = 0; k < 4; k++)
		      {
			size_t k1 = (k + 1) % 4;
			if (!is_zero (f[s[k]]) && !is_zero (f[s[k1]]))
			  {
			    // xk is inside edge {j0,j[k+1]} of triangle K:
			    size_t edge_iloc = edge_T_iloc (s[k], s[k1]);
			    size_t edge_idx = K.edge (edge_iloc);
			    if (marked_edge[edge_idx] == not_marked)
			      {
				marked_edge[edge_idx] =
				  vertex_intersection_list.size ();
				vertex_intersection_list.push_back (x[k]);
				uk = (f[s[k1]] * u.at (dofs_Bh[s[k]])
				      -
				      f[s[k]] * u.at (dofs_Bh[s[k1]])) /
				  (f[s[k1]] - f[s[k]]);
				//cerr << "Cas 7 : " << uk << endl;
				u_at_intersection_list.push_back (uk);
			      }
			    S[k] = marked_edge[edge_idx];
			  }
			else
			  {	// xk is at edge boundary: a vertex of the 2d mesh
			    size_t vertex_idx =
			      is_zero (f[s[k]]) ? K[s[k]] : K[s[k1]];
			    if (marked_vertex[vertex_idx] == not_marked)
			      {
				marked_vertex[vertex_idx] =
				  vertex_intersection_list.size ();
				vertex_intersection_list.push_back (Lambda.
								    vertex
								    (vertex_idx));
				uk =
				  (!is_zero (f[s[k]])) ? u.
				  at (dofs_Bh[s[k1]]) : u.at (dofs_Bh[s[k]]);
				//cerr << "Cas 8 : " << uk   << endl; 
				u_at_intersection_list.push_back (uk);

			      }
			    S[k] = marked_vertex[vertex_idx];
			  }
		      }
		    if (!triangle_3d_only)
		      {
			if (S[0] != S[1] && S[1] != S[2] && S[2] != S[3]
			    && S[3] != S[0])
			  {
			    // S[0] == S[j] when is_zero(f[j[0]]) but f[j[0]] != 0, i.e. precision pbs
			    element_intersection_list.push_back (S);
			  }
		      }
		    else
		      {
			// split quadri into 2 triangles
			element_type S1, S2;
			S1.set_name ('t');
			S1[0] = S[0];
			S1[1] = S[1];
			S1[2] = S[2];
			if (S1[0] != S1[1] && S1[1] != S1[2]
			    && S1[2] != S1[0])
			  {
			    element_intersection_list.push_back (S1);
			  }
			S2.set_name ('t');
			S2[0] = S[0];
			S2[1] = S[2];
			S2[2] = S[3];
			if (S2[0] != S2[1] && S2[1] != S2[2]
			    && S2[2] != S2[0])
			  {
			    element_intersection_list.push_back (S2);
			  }
		      }
		  }
		}
	      break;
	    }
	  default:
	    {
	      error_macro
		("level set intersection: element not yet implemented: " << K.
		 name ());
	    }
	  }
      }
    geo gamma;
    gamma.build (element_intersection_list, vertex_intersection_list);
    gamma.set_name ("zerolevel_from_" + Lambda.name ());
    space Gh (gamma, "P1");
    field u_on_Gamma (Gh);
    check_macro (u_on_Gamma.u.size () == u_at_intersection_list.size (),
		 "List of interpolated values for u has " <<
		 u_at_intersection_list.
		 size () << " while there are " << u_on_Gamma.u.
		 size () << " intersections");
    copy (u_at_intersection_list.begin (), u_at_intersection_list.end (),
	  u_on_Gamma.u.begin ());
    return u_on_Gamma;
  };
}				// namespace rheolef
