#! /bin/sh

# Test upload of a CSV file.

TMP_DIR="${TMPDIR}"

test -z "${BIN_DIR}" && BIN_DIR=website/cgi-bin

SCRIPT_BASE=`basename $0 | sed "s/_[0-9]*\.sh$//"`

BASENAME=$(basename $0 .pl)

#BEGIN DEPEND------------------------------------------------------------------

INPUT_SCRIPT="${BIN_DIR}/${SCRIPT_BASE}"

#END DEPEND--------------------------------------------------------------------

set -ue
## set -x

test -z "${TMP_DIR}" && TMP_DIR="/tmp"
TMP_DIR="${TMP_DIR}/tmp-${BASENAME}-$$"
mkdir "${TMP_DIR}"

# To make the trap portable between bash and dash, we need to trap
# "signal" 0 ("EXIT") and rely on it for the cleanup:
## trap "rm -rf '${TMP_DIR}'" 0 1 2 3 15
trap "rm -rf '${TMP_DIR}'" EXIT
trap "exit 1" HUP INT QUIT TERM

# Set up the testing "sandbox":
SRC_DB_DIR=db
TMP_DB_DIR=${TMP_DIR}/db
mkdir ${TMP_DB_DIR}

SRC_DB_FILE=${SRC_DB_DIR}/test4fk.db

TMP_TEST_DB=$(basename ${SRC_DB_FILE})
TMP_DB_MAIN=${TMP_DB_DIR}/${TMP_TEST_DB}
TMP_DB_META=${TMP_DB_DIR}/restful.db

cp ${SRC_DB_FILE} ${TMP_DB_MAIN}

mkdir ${TMP_DIR}/website
mkdir ${TMP_DIR}/website/cgi-bin
mkdir ${TMP_DIR}/tests

cp ${INPUT_SCRIPT} ${TMP_DIR}/website/cgi-bin

ln -s $(pwd)/lib ${TMP_DIR}
ln -s $(pwd)/sql ${TMP_DIR}
ln -s $(pwd)/tests/inputs ${TMP_DIR}/tests

mkdir -p ${TMP_DIR}/${BIN_DIR}

cp ${INPUT_SCRIPT} ${TMP_DIR}/${BIN_DIR}

# Change dir to the sandbox and run the test:

cd ${TMP_DIR}

sqlite3 ${TMP_DB_MAIN} "ALTER TABLE sample ADD uuid char(36)"
sqlite3 ${TMP_DB_MAIN} "INSERT INTO sample (SolsaID, uuid) values ('XX-TEST-0004', '3129df14-4ec4-11e8-950f-cfc135e92040')"

sqlite3 ${TMP_DB_META} < sql/metatables.sql
sqlite3 ${TMP_DB_META} "INSERT INTO description (id, dbtable, dbcolumn, coltype, fk_target, relation, visualisation) values (3, 'sample', 'experiment', 'fk', 1, 'N', 'table')"

sqlite3 ${TMP_DB_META} "UPDATE description SET dbname = 'test4fk.db'"

export REQUEST_URI="/~saulius/restful/website/${TMP_TEST_DB}/experiment"
export HTTP_HOST=restfuldb.domain.net
export REQUEST_METHOD=POST
export CONTENT_TYPE="multipart/form-data; boundary=------------------------b989696a28305e74"
export REMOTE_USER=writer

sqlite3 -nullvalue NULL ${TMP_DB_MAIN} 'select * from experiment order by id';

echo "==="

cat <<EOF > ${TMP_DIR}/experiment.csv
sample.SolsaID,sample.uuid,result
XX-TEST-0004,3129df14-4ec4-11e8-950f-cfc135e92040,1.0
,3129df14-4ec4-11e8-950f-cfc135e92040,2.0
XX-TEST-0001,3129df14-4ec4-11e8-950f-cfc135e92040,3.0
EOF

cd ${TMP_DIR}
zip --quiet experiment.zip experiment.csv
cd - > /dev/null

(
perl -lne 'print "$_\r"' <<PART1
--------------------------b989696a28305e74
Content-Disposition: form-data; name="csvzipfile"; filename="experiment.zip"
Content-Type: application/zip

PART1
cat ${TMP_DIR}/experiment.zip
echo -r "\r"
perl -lne 'print "$_\r"' <<PART2
--------------------------b989696a28305e74
Content-Disposition: form-data; name="db"

${TMP_TEST_DB}
--------------------------b989696a28305e74--
PART2
) | ${INPUT_SCRIPT}

echo "==="

sqlite3 -nullvalue NULL ${TMP_DB_MAIN} 'select * from experiment order by id';

# Go back to the original directory before deleting the temporary one:
cd - > /dev/null

# Temporary directory will be deleted by the trap.
