#ifndef _INCLUDE_WINDBG_KD_API_H_
#define _INCLUDE_WINDBG_KD_API_H_

#include <ctype.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#define uint32_t unsigned int
#define uint16_t unsigned short
#define uint8_t unsigned char

#define REPHDR "\x30\x30\x30\x30"
#define ACKHDR "\x69\x69\x69\x69"
#define ACKPKT ACKHDR "\x04\x00\x00\x00\x00\x00\x80\x80\x00\x00\x00\x00"
#define RSTPKT ACKHDR "\x06\x00\x00\x00\x00\x00\x80\x80\x00\x00\x00\x00"

enum {
	DBG_KD_REBOOT = 0x3b,
	DBG_KD_GET_CONTEXT = 0x32,
	DBG_KD_SET_CONTEXT = 0x33,
	DBG_KD_GET_VERSION = 0x46,
	DBG_KD_READ_PHYSICAL_MEMORY = 0x3d,
	DBG_KD_READ_VIRTUAL_MEMORY = 0x30,
	DBG_KD_WRITE_PHYSICAL_MEMORY = 0xFF, // XXX
	DBG_KD_WRITE_VIRTUAL_MEMORY = 0x31,
	DBG_KD_READ_CONTROL_SPACE = 0x37,
	DBG_KD_WRITE_CONTROL_SPACE = 0x38,
	DBG_KD_WRITE_BREAKPOINT = 0x34,
	DBG_KD_RESTORE_BREAKPOINT = 0x35,
	DBG_KD_CONTINUE = 0x3c,
};

enum {
	DBG_KD_REPLY_WRITE_BREAKPOINT = 0x34,
	DBG_KD_REPLY_RESTORE_BREAKPOINT = 0x35,
	DBG_KD_REPLY_GET_VERSION = 0x46,
	DBG_KD_REPLY_READ_VIRTUAL_MEMORY = 0x30,
	DBG_KD_REPLY_READ_PHYSICAL_MEMORY = 0x3d,
	DBG_KD_REPLY_CONTROL_SPACE = 0x37,
};

enum {
	DBG_KD_REPLY_TYPE_EXCEPTION = 0x30,
	DBG_KD_REPLY_TYPE_RESPONSE = 0x31,
};

struct wkd_version_t {
	uint16_t osv_major;
	uint16_t osv_minor;
	uint16_t pv;
	uint16_t machinetype;
	uint32_t kernbase; // XXX for 64 bits
	uint32_t modlist; // module list
	int ddata; // debugger data
};

// XXX too big numbers
enum {
	EXCEPTION_ACCESS_VIOLATION =      3221225477,
	EXCEPTION_ARRAY_BOUNDS_EXCEEDED = 3221225612,
	EXCEPTION_BREAKPOINT =            2147483651,
	EXCEPTION_DATATYPE_MISALIGNMENT = 2147483650,
	EXCEPTION_FLT_DENORMAL_OPERAND =  3221225613,
	EXCEPTION_FLT_DIVIDE_BY_ZERO =    3221225614,
	EXCEPTION_FLT_INEXACT_RESULT =    3221225615,
	EXCEPTION_FLT_INVALID_OPERATION = 3221225520,
	EXCEPTION_FLT_OVERFLOW =          3221225617,
	EXCEPTION_FLT_STACK_CHECK =       3221225522,
	EXCEPTION_FLT_UNDERFLOW =         3221225523,
	EXCEPTION_GUARD_PAGE =            2147483649,
	EXCEPTION_ILLEGAL_INSTRUCTION =   3221225501,
	EXCEPTION_IN_PAGE_ERROR =         3221225478,
	EXCEPTION_INT_DIVIDE_BY_ZERO =    3221225620,
	EXCEPTION_INT_OVERFLOW =          3221225525,
	EXCEPTION_STACK_OVERFLOW =        3221225725,
};

enum {
	CTX_FLAGS = 0,
	CTX_DR0 = 4,
	CTX_DR1 = 8,
	CTX_DR2 = 12,
	CTX_DR3 = 16,
	CTX_DR6 = 20,
	CTX_DR7 = 24,
	CTX_FP_CW = 28,
	CTX_FP_SW = 32,
	CTX_FP_TW = 36,
	CTX_FP_ERROR_OFFSET = 40,
	CTX_FP_ERROR_SELECT = 44,
	CTX_FP_DATA_OFFSET = 48,
	CTX_FP_DATA_SELECT = 52,
	CTX_FP_REGS = 56, // XXX size of FP_REGS is 80 bytes
	CTX_FP_CR0NPX = 136,
	CTX_GS = 140,
	CTX_FS = 144,
	CTX_ES = 148,
	CTX_DS = 152,
	CTX_EDI = 156,
	CTX_ESI = 160,
	CTX_EBX = 164,
	CTX_EDX = 168,
	CTX_ECX = 172,
	CTX_EAX = 176,
	CTX_EBP = 180,
	CTX_EIP = 184,
	CTX_CS = 188,
	CTX_EFLAGS = 192,
	CTX_ESP = 196,
	CTX_SS = 200,
};


#endif
