% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-my-timeline.R
\name{get_my_timeline}
\alias{get_my_timeline}
\title{Get \emph{your} timeline}
\usage{
get_my_timeline(
  n = 100,
  max_id = NULL,
  parse = TRUE,
  check = TRUE,
  token = NULL,
  ...
)
}
\arguments{
\item{n}{Number of tweets to return per timeline. Defaults to 100.
Must be of length 1 or equal to length of user.}

\item{max_id}{Character, returns results with an ID less than (that is,
older than) or equal to \code{max_id}.}

\item{parse}{Logical, indicating whether to return parsed
(data.frames) or nested list object. By default, \code{parse =
  TRUE} saves users from the time (and frustrations) associated
with disentangling the Twitter API return objects.}

\item{check}{Logical indicating whether to remove check available
rate limit. Ensures the request does not exceed the maximum
remaining number of calls.  Defaults to TRUE.}

\item{token}{Every user should have their own Oauth (Twitter API) token. By
default \code{token = NULL} this function looks for the path to a saved
Twitter token via environment variables (which is what \code{create_token()}
sets up by default during initial token creation). For instruction on how
to create a Twitter token see the tokens vignette, i.e.,
\code{vignettes("auth", "rtweet")} or see \code{?tokens}.}

\item{...}{Further arguments passed on as parameters in API query.}
}
\value{
A tbl data frame of tweets data with users data attribute.
}
\description{
Returns a collection of the most recent Tweets and Retweets posted by the
authenticating user and the users they follow. The home timeline is central to how
most users interact with the Twitter service.\cr
\cr
The \emph{authenticating user} is determined from the \code{token}.
}
\examples{

\dontrun{

tweets_from_me_and_the_ppl_i_follow <- get_my_timeline(n = 3200)

}
}
\seealso{
\url{https://developer.twitter.com/en/docs/tweets/timelines/api-reference/get-statuses-home_timeline}

Other tweets: 
\code{\link{get_favorites}()},
\code{\link{get_mentions}()},
\code{\link{get_timeline}()},
\code{\link{lists_statuses}()},
\code{\link{lookup_statuses}()},
\code{\link{search_tweets}()},
\code{\link{tweets_data}()},
\code{\link{tweets_with_users}()}
}
\concept{tweets}
