% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bearer_token.R
\name{bearer_token}
\alias{bearer_token}
\title{Bearer token}
\usage{
bearer_token(token = NULL)
}
\arguments{
\item{token}{Oauth token created via \code{\link{create_token}}. See details
for more information on valid tokens.}
}
\value{
A bearer token
}
\description{
Convert default token into bearer token for application only (user-free)
authentication method
}
\details{
\code{bearer_token()} will only work on valid tokens generated from
  a user-created Twitter app (requires a Twitter developer account; see
  \code{\link{create_token}} for more information). Unlike the default token
  returned by \code{create_token}, bearer tokens operate without any
  knowledge/information about the user context–meaning, bearer token requests
  cannot engage in user actions (e.g., posting tweets, reading DMs), and the
  information returned by Twitter will not include user-specific variables
  (e.g., if the user is following a certain account). The upside to this
  authentication method is that it can afford users with more generous rate
  limits. For example, the rate limit for the standard search API is 18,000
  tweets per fifteen minutes. With a bearer token, the rate limit is 45,000
  tweets per fifteen minutes. However, this is not true for all endpoints.
  For a breakdown/comparison of rate limits, see
  \url{https://developer.twitter.com/en/docs/basics/rate-limits.html}.
}
\examples{
\dontrun{
## use bearer token to search for >18k tweets (up to 45k) w/o hitting rate limit
verified_user_tweets <- search_tweets("filter:verified", n = 30000, token = bearer_token())

## get followers (user == app)
### - USER (normal) token – rate limit 15req/15min
cnn_flw <- get_followers("cnn", n = 75000)
### - APP (bearer) token – rate limit 15req/15min
cnn_flw <- get_followers("cnn", n = 75000, token = bearer_token())

## get timelines (user < app)
### - USER (normal) token – rate limit 900req/15min
cnn_flw_data <- get_timelines(cnn_flw$user_id[1:900])
### - APP (bearer) token – rate limit 1500req/15min
cnn_flw_data <- get_timelines(cnn_flw$user_id[1:1500], token = bearer_token())

## lookup statuses (user > app)
### - USER (normal) token – rate limit 900req/15min
cnn_flw_data2 <- lookup_tweets(cnn_flw_data$status_id[1:90000])
### - APP (bearer) token – rate limit 300req/15min
cnn_flw_data2 <- lookup_tweets(cnn_flw_data$status_id[1:30000], token = bearer_token())

}
}
