\name{maply}
\alias{maply}
\title{Call function with arguments in array or data frame, returning an array.}
\usage{
  maply(.data, .fun = NULL, ..., .expand = TRUE,
    .progress = "none", .inform = FALSE, .drop = TRUE,
    .parallel = FALSE, .paropts = NULL)
}
\arguments{
  \item{.fun}{function to apply to each piece}

  \item{...}{other arguments passed on to \code{.fun}}

  \item{.progress}{name of the progress bar to use, see
  \code{\link{create_progress_bar}}}

  \item{.parallel}{if \code{TRUE}, apply function in
  parallel, using parallel backend provided by foreach}

  \item{.paropts}{a list of additional options passed into
  the \code{\link[foreach]{foreach}} function when parallel
  computation is enabled.  This is important if (for
  example) your code relies on external data or packages:
  use the \code{.export} and \code{.packages} arguments to
  supply them so that all cluster nodes have the correct
  environment set up for computing.}

  \item{.inform}{produce informative error messages?  This
  is turned off by by default because it substantially
  slows processing speed, but is very useful for debugging}

  \item{.data}{matrix or data frame to use as source of
  arguments}

  \item{.expand}{should output be 1d (expand = FALSE), with
  an element for each row; or nd (expand = TRUE), with a
  dimension for each variable.}

  \item{.drop}{should extra dimensions of length 1 in the
  output be dropped, simplifying the output.  Defaults to
  \code{TRUE}}
}
\value{
  if results are atomic with same type and dimensionality,
  a vector, matrix or array; otherwise, a list-array (a
  list with dimensions)
}
\description{
  Call a multi-argument function with values taken from
  columns of an data frame or array, and combine results
  into an array
}
\details{
  The \code{m*ply} functions are the \code{plyr} version of
  \code{mapply}, specialised according to the type of
  output they produce.  These functions are just a
  convenient wrapper around \code{a*ply} with \code{margins
  = 1} and \code{.fun} wrapped in \code{\link{splat}}.
}
\section{Input}{
  Call a multi-argument function with values taken from
  columns of an data frame or array
}

\section{Output}{
  If there are no results, then this function will return a
  vector of length 0 (\code{vector()}).
}
\examples{
maply(cbind(mean = 1:5, sd = 1:5), rnorm, n = 5)
maply(expand.grid(mean = 1:5, sd = 1:5), rnorm, n = 5)
maply(cbind(1:5, 1:5), rnorm, n = 5)
}
\references{
  Hadley Wickham (2011). The Split-Apply-Combine Strategy
  for Data Analysis. Journal of Statistical Software,
  40(1), 1-29.  \url{http://www.jstatsoft.org/v40/i01/}.
}
\seealso{
  Other array output: \code{\link{aaply}},
  \code{\link{daply}}, \code{\link{laply}}

  Other multiple arguments input: \code{\link{m_ply}},
  \code{\link{mdply}}, \code{\link{mlply}}
}
\keyword{manip}

