% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_heteroscedasticity.R
\name{check_heteroscedasticity}
\alias{check_heteroscedasticity}
\title{Check model for (non-)constant error variance}
\usage{
check_heteroscedasticity(x, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}
}
\value{
Invisibly returns the p-value of the test statistics. A p-value < 0.05
indicates a non-constant variance (heteroskedasticity).
}
\description{
Check model for (non-)constant error variance.
}
\note{
There is also a \href{https://easystats.github.io/see/articles/performance.html}{\code{plot()}-method} implemented in the \href{https://easystats.github.io/see/}{\pkg{see}-package}.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_heteroscedasticity(m)

# plot results
x <- check_heteroscedasticity(m)
plot(x)
}
