% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ooxml_run_objects.R
\name{run_comment}
\alias{run_comment}
\title{Comment for 'Word'}
\usage{
run_comment(
  cmt,
  run = ftext(""),
  author = "",
  date = "",
  initials = "",
  prop = NULL
)
}
\arguments{
\item{cmt}{a set of blocks to be used as comment content returned by
function \code{\link[=block_list]{block_list()}}.
the "run functions for reporting".}

\item{run}{a run object, made with a call to one of}

\item{author}{comment author.}

\item{date}{comment date}

\item{initials}{comment initials}

\item{prop}{formatting text properties returned by
\code{\link[=fp_text_lite]{fp_text_lite()}} or \code{\link[=fp_text]{fp_text()}}. It also can be NULL in
which case, no formatting is defined (the default is applied).}
}
\description{
Add a comment on a run object.
}
\examples{
fp_bold <- fp_text_lite(bold = TRUE)
fp_red <- fp_text_lite(color = "red")

bl <- block_list(
  fpar(ftext("Comment multiple words.", fp_bold)),
fpar(
    ftext("Second line.", fp_red)
  )
)

comment1 <- run_comment(
   cmt = bl,
   run = ftext("with a comment"),
   author = "Author Me",
   date = Sys.Date(),
   initials = "AM"
)
par1 <- fpar("A paragraph ", comment1)

bl <- block_list(
  fpar(ftext("Comment a paragraph."))
)

comment2 <- run_comment(
   cmt = bl, run = ftext("A commented paragraph"),
   author = "Author You",
   date = Sys.Date(),
   initials = "AY"
)
par2 <- fpar(comment2)

doc <- read_docx()
doc <- body_add_fpar(doc, value = par1, style = "Normal")
doc <- body_add_fpar(doc, value = par2, style = "Normal")

print(doc, target = tempfile(fileext = ".docx"))
}
\seealso{
Other run functions for reporting: 
\code{\link{external_img}()},
\code{\link{ftext}()},
\code{\link{hyperlink_ftext}()},
\code{\link{run_autonum}()},
\code{\link{run_bookmark}()},
\code{\link{run_columnbreak}()},
\code{\link{run_footnote}()},
\code{\link{run_footnoteref}()},
\code{\link{run_linebreak}()},
\code{\link{run_pagebreak}()},
\code{\link{run_reference}()},
\code{\link{run_word_field}()},
\code{\link{run_wordtext}()}
}
\concept{run functions for reporting}
