% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/page.R
\name{page_navbar}
\alias{page_navbar}
\title{Multi-page app with a top navigation bar}
\usage{
page_navbar(
  ...,
  title = NULL,
  id = NULL,
  selected = NULL,
  sidebar = NULL,
  fillable = TRUE,
  fillable_mobile = FALSE,
  gap = NULL,
  padding = NULL,
  header = NULL,
  footer = NULL,
  navbar_options = NULL,
  fluid = TRUE,
  theme = bs_theme(),
  window_title = NA,
  lang = NULL,
  position = deprecated(),
  bg = deprecated(),
  inverse = deprecated(),
  underline = deprecated(),
  collapsible = deprecated()
)
}
\arguments{
\item{...}{a collection of \code{\link[=nav_panel]{nav_panel()}} items.}

\item{title}{A (left-aligned) title to place in the card header/footer. If
provided, other nav items are automatically right aligned.}

\item{id}{a character string used for dynamically updating the container (see
\code{\link[=nav_select]{nav_select()}}).}

\item{selected}{a character string matching the \code{value} of a particular
\code{\link[=nav_panel]{nav_panel()}} item to selected by default.}

\item{sidebar}{A \code{\link[=sidebar]{sidebar()}} component to display on every \code{\link[=nav_panel]{nav_panel()}}
page.}

\item{fillable}{Whether or not to allow \code{fill} items to grow/shrink to fit
the browser window. If \code{TRUE}, all \code{\link[=nav_panel]{nav_panel()}} pages are \code{fillable}. A
character vector, matching the \code{value} of \code{\link[=nav_panel]{nav_panel()}}s to be filled, may
also be provided. Note that, if a \code{sidebar} is provided, \code{fillable} makes
the main content portion fillable.}

\item{fillable_mobile}{Whether or not \code{fillable} pages should fill the viewport's
height on mobile devices (i.e., narrow windows).}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}.}

\item{padding}{Padding to use for the body. This can be a numeric vector
(which will be interpreted as pixels) or a character vector with valid CSS
lengths. The length can be between one and four. If one, then that value
will be used for all four sides. If two, then the first value will be used
for the top and bottom, while the second value will be used for left and
right. If three, then the first will be used for top, the second will be
left and right, and the third will be bottom. If four, then the values will
be interpreted as top, right, bottom, and left respectively.}

\item{header}{UI element(s) (\link[htmltools:builder]{htmltools::tags}) to display \emph{above} the nav
content. For \code{card}-based navsets, these elements are implicitly wrapped in
a \code{card_body()}. To control things like \code{padding}, \code{fill}, etc., wrap the
elements in an explicit \code{\link[=card_body]{card_body()}}.}

\item{footer}{UI element(s) (\link[htmltools:builder]{htmltools::tags}) to display \emph{below} the nav
content. For \code{card}-based navsets, these elements are implicitly wrapped in
a \code{card_body()}. To control things like \code{padding}, \code{fill}, etc., wrap the
elements in an explicit \code{\link[=card_body]{card_body()}}.}

\item{navbar_options}{Options to control the appearance and behavior of the
navbar. Use \code{\link[=navbar_options]{navbar_options()}} to create the list of options.}

\item{fluid}{\code{TRUE} to use fluid layout; \code{FALSE} to use fixed
layout.}

\item{theme}{A \code{\link[=bs_theme]{bs_theme()}} object.}

\item{window_title}{the browser window title. The default value, \code{NA}, means
to use any character strings that appear in \code{title} (if none are found, the
host URL of the page is displayed by default).}

\item{lang}{ISO 639-1 language code for the HTML page, such as "en" or "ko".
This will be used as the lang in the \code{<html>} tag, as in \code{<html lang="en">}.
The default (NULL) results in an empty string.}

\item{position}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(position=)}} instead.}

\item{bg}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(bg=)}} instead.}

\item{inverse}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(inverse=)}} instead.}

\item{underline}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(underline=)}} instead.}

\item{collapsible}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use
\code{\link[=navbar_options]{navbar_options = navbar_options(collapsible=)}} instead.}
}
\description{
Create a page that contains a top level navigation bar that can be used to
toggle a set of \code{\link[=nav_panel]{nav_panel()}} elements. Use this page layout to create the
effect of a multi-page app, where your app's content is broken up into
multiple "pages" that can be navigated to via the top navigation bar.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(bslib)

link_shiny <- tags$a(
  shiny::icon("github"), "Shiny",
  href = "https://github.com/rstudio/shiny",
  target = "_blank"
)
link_posit <- tags$a(
  shiny::icon("r-project"), "Posit",
  href = "https://posit.co",
  target = "_blank"
)

ui <- page_navbar(
  title = "My App",
  nav_panel(title = "One", p("First page content.")),
  nav_panel(title = "Two", p("Second page content.")),
  nav_panel("Three", p("Third page content.")),
  nav_spacer(),
  nav_menu(
    title = "Links",
    align = "right",
    nav_item(link_shiny),
    nav_item(link_posit)
  )
)

server <- function(...) { } # not used in this example

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\references{
\href{https://rstudio.github.io/bslib/articles/dashboards/index.html}{Getting Started with Dashboards}
on the bslib website.
}
\seealso{
\code{\link[=nav_panel]{nav_panel()}}, \code{\link[=nav_menu]{nav_menu()}}, and \code{\link[=nav_item]{nav_item()}} for adding content
sections and organizing or creating items in the navigation bar.

\code{\link[=layout_columns]{layout_columns()}} and \code{\link[=layout_column_wrap]{layout_column_wrap()}} for laying out content
into rows and columns.

\code{\link[=card]{card()}} for wrapping outputs in the 'main' content area.

\code{\link[=value_box]{value_box()}} for highlighting values.

\code{\link[=accordion]{accordion()}} for grouping related input controls in the \code{sidebar}.

Other Dashboard page layouts: 
\code{\link{page_fillable}()},
\code{\link{page_sidebar}()}
}
\concept{Dashboard page layouts}
