% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RichardTCellData.R
\name{RichardTCellData}
\alias{RichardTCellData}
\title{Obtain the Richard T cell data}
\usage{
RichardTCellData(location = TRUE)
}
\arguments{
\item{location}{Logical scalar indicating whether genomic coordinates should be returned.}
}
\value{
A \linkS4class{SingleCellExperiment} object with a single matrix of read counts.
}
\description{
Obtain the mouse CD8+ T cell single-cell RNA-seq data from Richard et al. (2018).
}
\details{
Column metadata is provided in the same form as supplied in E-MTAB-6051.
This contains information such as the stimulus, time after stimulation, age of the mice and sequencing batch.

Count data for ERCC spike-ins are stored in the \code{"ERCC"} entry of the \code{\link{altExps}}.

If \code{location=TRUE}, the coordinates of the Ensembl gene models are stored in the \code{\link{rowRanges}} of the output.

All data are downloaded from ExperimentHub and cached for local re-use.
Specific resources can be retrieved by searching for \code{scRNAseq/richard-tcell}.
}
\examples{
sce <- RichardTCellData()

}
\references{
Richard AC et al. (2018). 
T cell cytolytic capacity is independent of initial stimulation strength. 
\emph{Nat. Immunol.} 19(8), 849-858.
}
\author{
Aaron Lun
}
