#pragma once

#include "glcorearb.h"

#ifdef MemoryBarrier
#undef MemoryBarrier
#endif

struct GLMethods {
    PFNGLCULLFACEPROC CullFace;
    PFNGLFRONTFACEPROC FrontFace;
    PFNGLHINTPROC Hint;
    PFNGLLINEWIDTHPROC LineWidth;
    PFNGLPOINTSIZEPROC PointSize;
    PFNGLPOLYGONMODEPROC PolygonMode;
    PFNGLSCISSORPROC Scissor;
    PFNGLTEXPARAMETERFPROC TexParameterf;
    PFNGLTEXPARAMETERFVPROC TexParameterfv;
    PFNGLTEXPARAMETERIPROC TexParameteri;
    PFNGLTEXPARAMETERIVPROC TexParameteriv;
    PFNGLTEXIMAGE1DPROC TexImage1D;
    PFNGLTEXIMAGE2DPROC TexImage2D;
    PFNGLDRAWBUFFERPROC DrawBuffer;
    PFNGLCLEARPROC Clear;
    PFNGLCLEARCOLORPROC ClearColor;
    PFNGLCLEARSTENCILPROC ClearStencil;
    PFNGLCLEARDEPTHPROC ClearDepth;
    PFNGLSTENCILMASKPROC StencilMask;
    PFNGLCOLORMASKPROC ColorMask;
    PFNGLDEPTHMASKPROC DepthMask;
    PFNGLDISABLEPROC Disable;
    PFNGLENABLEPROC Enable;
    PFNGLFINISHPROC Finish;
    PFNGLFLUSHPROC Flush;
    PFNGLBLENDFUNCPROC BlendFunc;
    PFNGLLOGICOPPROC LogicOp;
    PFNGLSTENCILFUNCPROC StencilFunc;
    PFNGLSTENCILOPPROC StencilOp;
    PFNGLDEPTHFUNCPROC DepthFunc;
    PFNGLPIXELSTOREFPROC PixelStoref;
    PFNGLPIXELSTOREIPROC PixelStorei;
    PFNGLREADBUFFERPROC ReadBuffer;
    PFNGLREADPIXELSPROC ReadPixels;
    PFNGLGETBOOLEANVPROC GetBooleanv;
    PFNGLGETDOUBLEVPROC GetDoublev;
    PFNGLGETERRORPROC GetError;
    PFNGLGETFLOATVPROC GetFloatv;
    PFNGLGETINTEGERVPROC GetIntegerv;
    PFNGLGETSTRINGPROC GetString;
    PFNGLGETTEXIMAGEPROC GetTexImage;
    PFNGLGETTEXPARAMETERFVPROC GetTexParameterfv;
    PFNGLGETTEXPARAMETERIVPROC GetTexParameteriv;
    PFNGLGETTEXLEVELPARAMETERFVPROC GetTexLevelParameterfv;
    PFNGLGETTEXLEVELPARAMETERIVPROC GetTexLevelParameteriv;
    PFNGLISENABLEDPROC IsEnabled;
    PFNGLDEPTHRANGEPROC DepthRange;
    PFNGLVIEWPORTPROC Viewport;
    PFNGLDRAWARRAYSPROC DrawArrays;
    PFNGLDRAWELEMENTSPROC DrawElements;
    PFNGLGETPOINTERVPROC GetPointerv;
    PFNGLPOLYGONOFFSETPROC PolygonOffset;
    PFNGLCOPYTEXIMAGE1DPROC CopyTexImage1D;
    PFNGLCOPYTEXIMAGE2DPROC CopyTexImage2D;
    PFNGLCOPYTEXSUBIMAGE1DPROC CopyTexSubImage1D;
    PFNGLCOPYTEXSUBIMAGE2DPROC CopyTexSubImage2D;
    PFNGLTEXSUBIMAGE1DPROC TexSubImage1D;
    PFNGLTEXSUBIMAGE2DPROC TexSubImage2D;
    PFNGLBINDTEXTUREPROC BindTexture;
    PFNGLDELETETEXTURESPROC DeleteTextures;
    PFNGLGENTEXTURESPROC GenTextures;
    PFNGLISTEXTUREPROC IsTexture;
    PFNGLDRAWRANGEELEMENTSPROC DrawRangeElements;
    PFNGLTEXIMAGE3DPROC TexImage3D;
    PFNGLTEXSUBIMAGE3DPROC TexSubImage3D;
    PFNGLCOPYTEXSUBIMAGE3DPROC CopyTexSubImage3D;
    PFNGLACTIVETEXTUREPROC ActiveTexture;
    PFNGLSAMPLECOVERAGEPROC SampleCoverage;
    PFNGLCOMPRESSEDTEXIMAGE3DPROC CompressedTexImage3D;
    PFNGLCOMPRESSEDTEXIMAGE2DPROC CompressedTexImage2D;
    PFNGLCOMPRESSEDTEXIMAGE1DPROC CompressedTexImage1D;
    PFNGLCOMPRESSEDTEXSUBIMAGE3DPROC CompressedTexSubImage3D;
    PFNGLCOMPRESSEDTEXSUBIMAGE2DPROC CompressedTexSubImage2D;
    PFNGLCOMPRESSEDTEXSUBIMAGE1DPROC CompressedTexSubImage1D;
    PFNGLGETCOMPRESSEDTEXIMAGEPROC GetCompressedTexImage;
    PFNGLBLENDFUNCSEPARATEPROC BlendFuncSeparate;
    PFNGLMULTIDRAWARRAYSPROC MultiDrawArrays;
    PFNGLMULTIDRAWELEMENTSPROC MultiDrawElements;
    PFNGLPOINTPARAMETERFPROC PointParameterf;
    PFNGLPOINTPARAMETERFVPROC PointParameterfv;
    PFNGLPOINTPARAMETERIPROC PointParameteri;
    PFNGLPOINTPARAMETERIVPROC PointParameteriv;
    PFNGLBLENDCOLORPROC BlendColor;
    PFNGLBLENDEQUATIONPROC BlendEquation;
    PFNGLGENQUERIESPROC GenQueries;
    PFNGLDELETEQUERIESPROC DeleteQueries;
    PFNGLISQUERYPROC IsQuery;
    PFNGLBEGINQUERYPROC BeginQuery;
    PFNGLENDQUERYPROC EndQuery;
    PFNGLGETQUERYIVPROC GetQueryiv;
    PFNGLGETQUERYOBJECTIVPROC GetQueryObjectiv;
    PFNGLGETQUERYOBJECTUIVPROC GetQueryObjectuiv;
    PFNGLBINDBUFFERPROC BindBuffer;
    PFNGLDELETEBUFFERSPROC DeleteBuffers;
    PFNGLGENBUFFERSPROC GenBuffers;
    PFNGLISBUFFERPROC IsBuffer;
    PFNGLBUFFERDATAPROC BufferData;
    PFNGLBUFFERSUBDATAPROC BufferSubData;
    PFNGLGETBUFFERSUBDATAPROC GetBufferSubData;
    PFNGLMAPBUFFERPROC MapBuffer;
    PFNGLUNMAPBUFFERPROC UnmapBuffer;
    PFNGLGETBUFFERPARAMETERIVPROC GetBufferParameteriv;
    PFNGLGETBUFFERPOINTERVPROC GetBufferPointerv;
    PFNGLBLENDEQUATIONSEPARATEPROC BlendEquationSeparate;
    PFNGLDRAWBUFFERSPROC DrawBuffers;
    PFNGLSTENCILOPSEPARATEPROC StencilOpSeparate;
    PFNGLSTENCILFUNCSEPARATEPROC StencilFuncSeparate;
    PFNGLSTENCILMASKSEPARATEPROC StencilMaskSeparate;
    PFNGLATTACHSHADERPROC AttachShader;
    PFNGLBINDATTRIBLOCATIONPROC BindAttribLocation;
    PFNGLCOMPILESHADERPROC CompileShader;
    PFNGLCREATEPROGRAMPROC CreateProgram;
    PFNGLCREATESHADERPROC CreateShader;
    PFNGLDELETEPROGRAMPROC DeleteProgram;
    PFNGLDELETESHADERPROC DeleteShader;
    PFNGLDETACHSHADERPROC DetachShader;
    PFNGLDISABLEVERTEXATTRIBARRAYPROC DisableVertexAttribArray;
    PFNGLENABLEVERTEXATTRIBARRAYPROC EnableVertexAttribArray;
    PFNGLGETACTIVEATTRIBPROC GetActiveAttrib;
    PFNGLGETACTIVEUNIFORMPROC GetActiveUniform;
    PFNGLGETATTACHEDSHADERSPROC GetAttachedShaders;
    PFNGLGETATTRIBLOCATIONPROC GetAttribLocation;
    PFNGLGETPROGRAMIVPROC GetProgramiv;
    PFNGLGETPROGRAMINFOLOGPROC GetProgramInfoLog;
    PFNGLGETSHADERIVPROC GetShaderiv;
    PFNGLGETSHADERINFOLOGPROC GetShaderInfoLog;
    PFNGLGETSHADERSOURCEPROC GetShaderSource;
    PFNGLGETUNIFORMLOCATIONPROC GetUniformLocation;
    PFNGLGETUNIFORMFVPROC GetUniformfv;
    PFNGLGETUNIFORMIVPROC GetUniformiv;
    PFNGLGETVERTEXATTRIBDVPROC GetVertexAttribdv;
    PFNGLGETVERTEXATTRIBFVPROC GetVertexAttribfv;
    PFNGLGETVERTEXATTRIBIVPROC GetVertexAttribiv;
    PFNGLGETVERTEXATTRIBPOINTERVPROC GetVertexAttribPointerv;
    PFNGLISPROGRAMPROC IsProgram;
    PFNGLISSHADERPROC IsShader;
    PFNGLLINKPROGRAMPROC LinkProgram;
    PFNGLSHADERSOURCEPROC ShaderSource;
    PFNGLUSEPROGRAMPROC UseProgram;
    PFNGLUNIFORM1FPROC Uniform1f;
    PFNGLUNIFORM2FPROC Uniform2f;
    PFNGLUNIFORM3FPROC Uniform3f;
    PFNGLUNIFORM4FPROC Uniform4f;
    PFNGLUNIFORM1IPROC Uniform1i;
    PFNGLUNIFORM2IPROC Uniform2i;
    PFNGLUNIFORM3IPROC Uniform3i;
    PFNGLUNIFORM4IPROC Uniform4i;
    PFNGLUNIFORM1FVPROC Uniform1fv;
    PFNGLUNIFORM2FVPROC Uniform2fv;
    PFNGLUNIFORM3FVPROC Uniform3fv;
    PFNGLUNIFORM4FVPROC Uniform4fv;
    PFNGLUNIFORM1IVPROC Uniform1iv;
    PFNGLUNIFORM2IVPROC Uniform2iv;
    PFNGLUNIFORM3IVPROC Uniform3iv;
    PFNGLUNIFORM4IVPROC Uniform4iv;
    PFNGLUNIFORMMATRIX2FVPROC UniformMatrix2fv;
    PFNGLUNIFORMMATRIX3FVPROC UniformMatrix3fv;
    PFNGLUNIFORMMATRIX4FVPROC UniformMatrix4fv;
    PFNGLVALIDATEPROGRAMPROC ValidateProgram;
    PFNGLVERTEXATTRIB1DPROC VertexAttrib1d;
    PFNGLVERTEXATTRIB1DVPROC VertexAttrib1dv;
    PFNGLVERTEXATTRIB1FPROC VertexAttrib1f;
    PFNGLVERTEXATTRIB1FVPROC VertexAttrib1fv;
    PFNGLVERTEXATTRIB1SPROC VertexAttrib1s;
    PFNGLVERTEXATTRIB1SVPROC VertexAttrib1sv;
    PFNGLVERTEXATTRIB2DPROC VertexAttrib2d;
    PFNGLVERTEXATTRIB2DVPROC VertexAttrib2dv;
    PFNGLVERTEXATTRIB2FPROC VertexAttrib2f;
    PFNGLVERTEXATTRIB2FVPROC VertexAttrib2fv;
    PFNGLVERTEXATTRIB2SPROC VertexAttrib2s;
    PFNGLVERTEXATTRIB2SVPROC VertexAttrib2sv;
    PFNGLVERTEXATTRIB3DPROC VertexAttrib3d;
    PFNGLVERTEXATTRIB3DVPROC VertexAttrib3dv;
    PFNGLVERTEXATTRIB3FPROC VertexAttrib3f;
    PFNGLVERTEXATTRIB3FVPROC VertexAttrib3fv;
    PFNGLVERTEXATTRIB3SPROC VertexAttrib3s;
    PFNGLVERTEXATTRIB3SVPROC VertexAttrib3sv;
    PFNGLVERTEXATTRIB4NBVPROC VertexAttrib4Nbv;
    PFNGLVERTEXATTRIB4NIVPROC VertexAttrib4Niv;
    PFNGLVERTEXATTRIB4NSVPROC VertexAttrib4Nsv;
    PFNGLVERTEXATTRIB4NUBPROC VertexAttrib4Nub;
    PFNGLVERTEXATTRIB4NUBVPROC VertexAttrib4Nubv;
    PFNGLVERTEXATTRIB4NUIVPROC VertexAttrib4Nuiv;
    PFNGLVERTEXATTRIB4NUSVPROC VertexAttrib4Nusv;
    PFNGLVERTEXATTRIB4BVPROC VertexAttrib4bv;
    PFNGLVERTEXATTRIB4DPROC VertexAttrib4d;
    PFNGLVERTEXATTRIB4DVPROC VertexAttrib4dv;
    PFNGLVERTEXATTRIB4FPROC VertexAttrib4f;
    PFNGLVERTEXATTRIB4FVPROC VertexAttrib4fv;
    PFNGLVERTEXATTRIB4IVPROC VertexAttrib4iv;
    PFNGLVERTEXATTRIB4SPROC VertexAttrib4s;
    PFNGLVERTEXATTRIB4SVPROC VertexAttrib4sv;
    PFNGLVERTEXATTRIB4UBVPROC VertexAttrib4ubv;
    PFNGLVERTEXATTRIB4UIVPROC VertexAttrib4uiv;
    PFNGLVERTEXATTRIB4USVPROC VertexAttrib4usv;
    PFNGLVERTEXATTRIBPOINTERPROC VertexAttribPointer;
    PFNGLUNIFORMMATRIX2X3FVPROC UniformMatrix2x3fv;
    PFNGLUNIFORMMATRIX3X2FVPROC UniformMatrix3x2fv;
    PFNGLUNIFORMMATRIX2X4FVPROC UniformMatrix2x4fv;
    PFNGLUNIFORMMATRIX4X2FVPROC UniformMatrix4x2fv;
    PFNGLUNIFORMMATRIX3X4FVPROC UniformMatrix3x4fv;
    PFNGLUNIFORMMATRIX4X3FVPROC UniformMatrix4x3fv;
    PFNGLCOLORMASKIPROC ColorMaski;
    PFNGLGETBOOLEANI_VPROC GetBooleani_v;
    PFNGLGETINTEGERI_VPROC GetIntegeri_v;
    PFNGLENABLEIPROC Enablei;
    PFNGLDISABLEIPROC Disablei;
    PFNGLISENABLEDIPROC IsEnabledi;
    PFNGLBEGINTRANSFORMFEEDBACKPROC BeginTransformFeedback;
    PFNGLENDTRANSFORMFEEDBACKPROC EndTransformFeedback;
    PFNGLBINDBUFFERRANGEPROC BindBufferRange;
    PFNGLBINDBUFFERBASEPROC BindBufferBase;
    PFNGLTRANSFORMFEEDBACKVARYINGSPROC TransformFeedbackVaryings;
    PFNGLGETTRANSFORMFEEDBACKVARYINGPROC GetTransformFeedbackVarying;
    PFNGLCLAMPCOLORPROC ClampColor;
    PFNGLBEGINCONDITIONALRENDERPROC BeginConditionalRender;
    PFNGLENDCONDITIONALRENDERPROC EndConditionalRender;
    PFNGLVERTEXATTRIBIPOINTERPROC VertexAttribIPointer;
    PFNGLGETVERTEXATTRIBIIVPROC GetVertexAttribIiv;
    PFNGLGETVERTEXATTRIBIUIVPROC GetVertexAttribIuiv;
    PFNGLVERTEXATTRIBI1IPROC VertexAttribI1i;
    PFNGLVERTEXATTRIBI2IPROC VertexAttribI2i;
    PFNGLVERTEXATTRIBI3IPROC VertexAttribI3i;
    PFNGLVERTEXATTRIBI4IPROC VertexAttribI4i;
    PFNGLVERTEXATTRIBI1UIPROC VertexAttribI1ui;
    PFNGLVERTEXATTRIBI2UIPROC VertexAttribI2ui;
    PFNGLVERTEXATTRIBI3UIPROC VertexAttribI3ui;
    PFNGLVERTEXATTRIBI4UIPROC VertexAttribI4ui;
    PFNGLVERTEXATTRIBI1IVPROC VertexAttribI1iv;
    PFNGLVERTEXATTRIBI2IVPROC VertexAttribI2iv;
    PFNGLVERTEXATTRIBI3IVPROC VertexAttribI3iv;
    PFNGLVERTEXATTRIBI4IVPROC VertexAttribI4iv;
    PFNGLVERTEXATTRIBI1UIVPROC VertexAttribI1uiv;
    PFNGLVERTEXATTRIBI2UIVPROC VertexAttribI2uiv;
    PFNGLVERTEXATTRIBI3UIVPROC VertexAttribI3uiv;
    PFNGLVERTEXATTRIBI4UIVPROC VertexAttribI4uiv;
    PFNGLVERTEXATTRIBI4BVPROC VertexAttribI4bv;
    PFNGLVERTEXATTRIBI4SVPROC VertexAttribI4sv;
    PFNGLVERTEXATTRIBI4UBVPROC VertexAttribI4ubv;
    PFNGLVERTEXATTRIBI4USVPROC VertexAttribI4usv;
    PFNGLGETUNIFORMUIVPROC GetUniformuiv;
    PFNGLBINDFRAGDATALOCATIONPROC BindFragDataLocation;
    PFNGLGETFRAGDATALOCATIONPROC GetFragDataLocation;
    PFNGLUNIFORM1UIPROC Uniform1ui;
    PFNGLUNIFORM2UIPROC Uniform2ui;
    PFNGLUNIFORM3UIPROC Uniform3ui;
    PFNGLUNIFORM4UIPROC Uniform4ui;
    PFNGLUNIFORM1UIVPROC Uniform1uiv;
    PFNGLUNIFORM2UIVPROC Uniform2uiv;
    PFNGLUNIFORM3UIVPROC Uniform3uiv;
    PFNGLUNIFORM4UIVPROC Uniform4uiv;
    PFNGLTEXPARAMETERIIVPROC TexParameterIiv;
    PFNGLTEXPARAMETERIUIVPROC TexParameterIuiv;
    PFNGLGETTEXPARAMETERIIVPROC GetTexParameterIiv;
    PFNGLGETTEXPARAMETERIUIVPROC GetTexParameterIuiv;
    PFNGLCLEARBUFFERIVPROC ClearBufferiv;
    PFNGLCLEARBUFFERUIVPROC ClearBufferuiv;
    PFNGLCLEARBUFFERFVPROC ClearBufferfv;
    PFNGLCLEARBUFFERFIPROC ClearBufferfi;
    PFNGLGETSTRINGIPROC GetStringi;
    PFNGLISRENDERBUFFERPROC IsRenderbuffer;
    PFNGLBINDRENDERBUFFERPROC BindRenderbuffer;
    PFNGLDELETERENDERBUFFERSPROC DeleteRenderbuffers;
    PFNGLGENRENDERBUFFERSPROC GenRenderbuffers;
    PFNGLRENDERBUFFERSTORAGEPROC RenderbufferStorage;
    PFNGLGETRENDERBUFFERPARAMETERIVPROC GetRenderbufferParameteriv;
    PFNGLISFRAMEBUFFERPROC IsFramebuffer;
    PFNGLBINDFRAMEBUFFERPROC BindFramebuffer;
    PFNGLDELETEFRAMEBUFFERSPROC DeleteFramebuffers;
    PFNGLGENFRAMEBUFFERSPROC GenFramebuffers;
    PFNGLCHECKFRAMEBUFFERSTATUSPROC CheckFramebufferStatus;
    PFNGLFRAMEBUFFERTEXTURE1DPROC FramebufferTexture1D;
    PFNGLFRAMEBUFFERTEXTURE2DPROC FramebufferTexture2D;
    PFNGLFRAMEBUFFERTEXTURE3DPROC FramebufferTexture3D;
    PFNGLFRAMEBUFFERRENDERBUFFERPROC FramebufferRenderbuffer;
    PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVPROC GetFramebufferAttachmentParameteriv;
    PFNGLGENERATEMIPMAPPROC GenerateMipmap;
    PFNGLBLITFRAMEBUFFERPROC BlitFramebuffer;
    PFNGLRENDERBUFFERSTORAGEMULTISAMPLEPROC RenderbufferStorageMultisample;
    PFNGLFRAMEBUFFERTEXTURELAYERPROC FramebufferTextureLayer;
    PFNGLMAPBUFFERRANGEPROC MapBufferRange;
    PFNGLFLUSHMAPPEDBUFFERRANGEPROC FlushMappedBufferRange;
    PFNGLBINDVERTEXARRAYPROC BindVertexArray;
    PFNGLDELETEVERTEXARRAYSPROC DeleteVertexArrays;
    PFNGLGENVERTEXARRAYSPROC GenVertexArrays;
    PFNGLISVERTEXARRAYPROC IsVertexArray;
    PFNGLDRAWARRAYSINSTANCEDPROC DrawArraysInstanced;
    PFNGLDRAWELEMENTSINSTANCEDPROC DrawElementsInstanced;
    PFNGLTEXBUFFERPROC TexBuffer;
    PFNGLPRIMITIVERESTARTINDEXPROC PrimitiveRestartIndex;
    PFNGLCOPYBUFFERSUBDATAPROC CopyBufferSubData;
    PFNGLGETUNIFORMINDICESPROC GetUniformIndices;
    PFNGLGETACTIVEUNIFORMSIVPROC GetActiveUniformsiv;
    PFNGLGETACTIVEUNIFORMNAMEPROC GetActiveUniformName;
    PFNGLGETUNIFORMBLOCKINDEXPROC GetUniformBlockIndex;
    PFNGLGETACTIVEUNIFORMBLOCKIVPROC GetActiveUniformBlockiv;
    PFNGLGETACTIVEUNIFORMBLOCKNAMEPROC GetActiveUniformBlockName;
    PFNGLUNIFORMBLOCKBINDINGPROC UniformBlockBinding;
    PFNGLDRAWELEMENTSBASEVERTEXPROC DrawElementsBaseVertex;
    PFNGLDRAWRANGEELEMENTSBASEVERTEXPROC DrawRangeElementsBaseVertex;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXPROC DrawElementsInstancedBaseVertex;
    PFNGLMULTIDRAWELEMENTSBASEVERTEXPROC MultiDrawElementsBaseVertex;
    PFNGLPROVOKINGVERTEXPROC ProvokingVertex;
    PFNGLFENCESYNCPROC FenceSync;
    PFNGLISSYNCPROC IsSync;
    PFNGLDELETESYNCPROC DeleteSync;
    PFNGLCLIENTWAITSYNCPROC ClientWaitSync;
    PFNGLWAITSYNCPROC WaitSync;
    PFNGLGETINTEGER64VPROC GetInteger64v;
    PFNGLGETSYNCIVPROC GetSynciv;
    PFNGLGETINTEGER64I_VPROC GetInteger64i_v;
    PFNGLGETBUFFERPARAMETERI64VPROC GetBufferParameteri64v;
    PFNGLFRAMEBUFFERTEXTUREPROC FramebufferTexture;
    PFNGLTEXIMAGE2DMULTISAMPLEPROC TexImage2DMultisample;
    PFNGLTEXIMAGE3DMULTISAMPLEPROC TexImage3DMultisample;
    PFNGLGETMULTISAMPLEFVPROC GetMultisamplefv;
    PFNGLSAMPLEMASKIPROC SampleMaski;
    PFNGLBINDFRAGDATALOCATIONINDEXEDPROC BindFragDataLocationIndexed;
    PFNGLGETFRAGDATAINDEXPROC GetFragDataIndex;
    PFNGLGENSAMPLERSPROC GenSamplers;
    PFNGLDELETESAMPLERSPROC DeleteSamplers;
    PFNGLISSAMPLERPROC IsSampler;
    PFNGLBINDSAMPLERPROC BindSampler;
    PFNGLSAMPLERPARAMETERIPROC SamplerParameteri;
    PFNGLSAMPLERPARAMETERIVPROC SamplerParameteriv;
    PFNGLSAMPLERPARAMETERFPROC SamplerParameterf;
    PFNGLSAMPLERPARAMETERFVPROC SamplerParameterfv;
    PFNGLSAMPLERPARAMETERIIVPROC SamplerParameterIiv;
    PFNGLSAMPLERPARAMETERIUIVPROC SamplerParameterIuiv;
    PFNGLGETSAMPLERPARAMETERIVPROC GetSamplerParameteriv;
    PFNGLGETSAMPLERPARAMETERIIVPROC GetSamplerParameterIiv;
    PFNGLGETSAMPLERPARAMETERFVPROC GetSamplerParameterfv;
    PFNGLGETSAMPLERPARAMETERIUIVPROC GetSamplerParameterIuiv;
    PFNGLQUERYCOUNTERPROC QueryCounter;
    PFNGLGETQUERYOBJECTI64VPROC GetQueryObjecti64v;
    PFNGLGETQUERYOBJECTUI64VPROC GetQueryObjectui64v;
    PFNGLVERTEXATTRIBDIVISORPROC VertexAttribDivisor;
    PFNGLVERTEXATTRIBP1UIPROC VertexAttribP1ui;
    PFNGLVERTEXATTRIBP1UIVPROC VertexAttribP1uiv;
    PFNGLVERTEXATTRIBP2UIPROC VertexAttribP2ui;
    PFNGLVERTEXATTRIBP2UIVPROC VertexAttribP2uiv;
    PFNGLVERTEXATTRIBP3UIPROC VertexAttribP3ui;
    PFNGLVERTEXATTRIBP3UIVPROC VertexAttribP3uiv;
    PFNGLVERTEXATTRIBP4UIPROC VertexAttribP4ui;
    PFNGLVERTEXATTRIBP4UIVPROC VertexAttribP4uiv;
    PFNGLMINSAMPLESHADINGPROC MinSampleShading;
    PFNGLBLENDEQUATIONIPROC BlendEquationi;
    PFNGLBLENDEQUATIONSEPARATEIPROC BlendEquationSeparatei;
    PFNGLBLENDFUNCIPROC BlendFunci;
    PFNGLBLENDFUNCSEPARATEIPROC BlendFuncSeparatei;
    PFNGLDRAWARRAYSINDIRECTPROC DrawArraysIndirect;
    PFNGLDRAWELEMENTSINDIRECTPROC DrawElementsIndirect;
    PFNGLUNIFORM1DPROC Uniform1d;
    PFNGLUNIFORM2DPROC Uniform2d;
    PFNGLUNIFORM3DPROC Uniform3d;
    PFNGLUNIFORM4DPROC Uniform4d;
    PFNGLUNIFORM1DVPROC Uniform1dv;
    PFNGLUNIFORM2DVPROC Uniform2dv;
    PFNGLUNIFORM3DVPROC Uniform3dv;
    PFNGLUNIFORM4DVPROC Uniform4dv;
    PFNGLUNIFORMMATRIX2DVPROC UniformMatrix2dv;
    PFNGLUNIFORMMATRIX3DVPROC UniformMatrix3dv;
    PFNGLUNIFORMMATRIX4DVPROC UniformMatrix4dv;
    PFNGLUNIFORMMATRIX2X3DVPROC UniformMatrix2x3dv;
    PFNGLUNIFORMMATRIX2X4DVPROC UniformMatrix2x4dv;
    PFNGLUNIFORMMATRIX3X2DVPROC UniformMatrix3x2dv;
    PFNGLUNIFORMMATRIX3X4DVPROC UniformMatrix3x4dv;
    PFNGLUNIFORMMATRIX4X2DVPROC UniformMatrix4x2dv;
    PFNGLUNIFORMMATRIX4X3DVPROC UniformMatrix4x3dv;
    PFNGLGETUNIFORMDVPROC GetUniformdv;
    PFNGLGETSUBROUTINEUNIFORMLOCATIONPROC GetSubroutineUniformLocation;
    PFNGLGETSUBROUTINEINDEXPROC GetSubroutineIndex;
    PFNGLGETACTIVESUBROUTINEUNIFORMIVPROC GetActiveSubroutineUniformiv;
    PFNGLGETACTIVESUBROUTINEUNIFORMNAMEPROC GetActiveSubroutineUniformName;
    PFNGLGETACTIVESUBROUTINENAMEPROC GetActiveSubroutineName;
    PFNGLUNIFORMSUBROUTINESUIVPROC UniformSubroutinesuiv;
    PFNGLGETUNIFORMSUBROUTINEUIVPROC GetUniformSubroutineuiv;
    PFNGLGETPROGRAMSTAGEIVPROC GetProgramStageiv;
    PFNGLPATCHPARAMETERIPROC PatchParameteri;
    PFNGLPATCHPARAMETERFVPROC PatchParameterfv;
    PFNGLBINDTRANSFORMFEEDBACKPROC BindTransformFeedback;
    PFNGLDELETETRANSFORMFEEDBACKSPROC DeleteTransformFeedbacks;
    PFNGLGENTRANSFORMFEEDBACKSPROC GenTransformFeedbacks;
    PFNGLISTRANSFORMFEEDBACKPROC IsTransformFeedback;
    PFNGLPAUSETRANSFORMFEEDBACKPROC PauseTransformFeedback;
    PFNGLRESUMETRANSFORMFEEDBACKPROC ResumeTransformFeedback;
    PFNGLDRAWTRANSFORMFEEDBACKPROC DrawTransformFeedback;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMPROC DrawTransformFeedbackStream;
    PFNGLBEGINQUERYINDEXEDPROC BeginQueryIndexed;
    PFNGLENDQUERYINDEXEDPROC EndQueryIndexed;
    PFNGLGETQUERYINDEXEDIVPROC GetQueryIndexediv;
    PFNGLRELEASESHADERCOMPILERPROC ReleaseShaderCompiler;
    PFNGLSHADERBINARYPROC ShaderBinary;
    PFNGLGETSHADERPRECISIONFORMATPROC GetShaderPrecisionFormat;
    PFNGLDEPTHRANGEFPROC DepthRangef;
    PFNGLCLEARDEPTHFPROC ClearDepthf;
    PFNGLGETPROGRAMBINARYPROC GetProgramBinary;
    PFNGLPROGRAMBINARYPROC ProgramBinary;
    PFNGLPROGRAMPARAMETERIPROC ProgramParameteri;
    PFNGLUSEPROGRAMSTAGESPROC UseProgramStages;
    PFNGLACTIVESHADERPROGRAMPROC ActiveShaderProgram;
    PFNGLCREATESHADERPROGRAMVPROC CreateShaderProgramv;
    PFNGLBINDPROGRAMPIPELINEPROC BindProgramPipeline;
    PFNGLDELETEPROGRAMPIPELINESPROC DeleteProgramPipelines;
    PFNGLGENPROGRAMPIPELINESPROC GenProgramPipelines;
    PFNGLISPROGRAMPIPELINEPROC IsProgramPipeline;
    PFNGLGETPROGRAMPIPELINEIVPROC GetProgramPipelineiv;
    PFNGLPROGRAMUNIFORM1IPROC ProgramUniform1i;
    PFNGLPROGRAMUNIFORM1IVPROC ProgramUniform1iv;
    PFNGLPROGRAMUNIFORM1FPROC ProgramUniform1f;
    PFNGLPROGRAMUNIFORM1FVPROC ProgramUniform1fv;
    PFNGLPROGRAMUNIFORM1DPROC ProgramUniform1d;
    PFNGLPROGRAMUNIFORM1DVPROC ProgramUniform1dv;
    PFNGLPROGRAMUNIFORM1UIPROC ProgramUniform1ui;
    PFNGLPROGRAMUNIFORM1UIVPROC ProgramUniform1uiv;
    PFNGLPROGRAMUNIFORM2IPROC ProgramUniform2i;
    PFNGLPROGRAMUNIFORM2IVPROC ProgramUniform2iv;
    PFNGLPROGRAMUNIFORM2FPROC ProgramUniform2f;
    PFNGLPROGRAMUNIFORM2FVPROC ProgramUniform2fv;
    PFNGLPROGRAMUNIFORM2DPROC ProgramUniform2d;
    PFNGLPROGRAMUNIFORM2DVPROC ProgramUniform2dv;
    PFNGLPROGRAMUNIFORM2UIPROC ProgramUniform2ui;
    PFNGLPROGRAMUNIFORM2UIVPROC ProgramUniform2uiv;
    PFNGLPROGRAMUNIFORM3IPROC ProgramUniform3i;
    PFNGLPROGRAMUNIFORM3IVPROC ProgramUniform3iv;
    PFNGLPROGRAMUNIFORM3FPROC ProgramUniform3f;
    PFNGLPROGRAMUNIFORM3FVPROC ProgramUniform3fv;
    PFNGLPROGRAMUNIFORM3DPROC ProgramUniform3d;
    PFNGLPROGRAMUNIFORM3DVPROC ProgramUniform3dv;
    PFNGLPROGRAMUNIFORM3UIPROC ProgramUniform3ui;
    PFNGLPROGRAMUNIFORM3UIVPROC ProgramUniform3uiv;
    PFNGLPROGRAMUNIFORM4IPROC ProgramUniform4i;
    PFNGLPROGRAMUNIFORM4IVPROC ProgramUniform4iv;
    PFNGLPROGRAMUNIFORM4FPROC ProgramUniform4f;
    PFNGLPROGRAMUNIFORM4FVPROC ProgramUniform4fv;
    PFNGLPROGRAMUNIFORM4DPROC ProgramUniform4d;
    PFNGLPROGRAMUNIFORM4DVPROC ProgramUniform4dv;
    PFNGLPROGRAMUNIFORM4UIPROC ProgramUniform4ui;
    PFNGLPROGRAMUNIFORM4UIVPROC ProgramUniform4uiv;
    PFNGLPROGRAMUNIFORMMATRIX2FVPROC ProgramUniformMatrix2fv;
    PFNGLPROGRAMUNIFORMMATRIX3FVPROC ProgramUniformMatrix3fv;
    PFNGLPROGRAMUNIFORMMATRIX4FVPROC ProgramUniformMatrix4fv;
    PFNGLPROGRAMUNIFORMMATRIX2DVPROC ProgramUniformMatrix2dv;
    PFNGLPROGRAMUNIFORMMATRIX3DVPROC ProgramUniformMatrix3dv;
    PFNGLPROGRAMUNIFORMMATRIX4DVPROC ProgramUniformMatrix4dv;
    PFNGLPROGRAMUNIFORMMATRIX2X3FVPROC ProgramUniformMatrix2x3fv;
    PFNGLPROGRAMUNIFORMMATRIX3X2FVPROC ProgramUniformMatrix3x2fv;
    PFNGLPROGRAMUNIFORMMATRIX2X4FVPROC ProgramUniformMatrix2x4fv;
    PFNGLPROGRAMUNIFORMMATRIX4X2FVPROC ProgramUniformMatrix4x2fv;
    PFNGLPROGRAMUNIFORMMATRIX3X4FVPROC ProgramUniformMatrix3x4fv;
    PFNGLPROGRAMUNIFORMMATRIX4X3FVPROC ProgramUniformMatrix4x3fv;
    PFNGLPROGRAMUNIFORMMATRIX2X3DVPROC ProgramUniformMatrix2x3dv;
    PFNGLPROGRAMUNIFORMMATRIX3X2DVPROC ProgramUniformMatrix3x2dv;
    PFNGLPROGRAMUNIFORMMATRIX2X4DVPROC ProgramUniformMatrix2x4dv;
    PFNGLPROGRAMUNIFORMMATRIX4X2DVPROC ProgramUniformMatrix4x2dv;
    PFNGLPROGRAMUNIFORMMATRIX3X4DVPROC ProgramUniformMatrix3x4dv;
    PFNGLPROGRAMUNIFORMMATRIX4X3DVPROC ProgramUniformMatrix4x3dv;
    PFNGLVALIDATEPROGRAMPIPELINEPROC ValidateProgramPipeline;
    PFNGLGETPROGRAMPIPELINEINFOLOGPROC GetProgramPipelineInfoLog;
    PFNGLVERTEXATTRIBL1DPROC VertexAttribL1d;
    PFNGLVERTEXATTRIBL2DPROC VertexAttribL2d;
    PFNGLVERTEXATTRIBL3DPROC VertexAttribL3d;
    PFNGLVERTEXATTRIBL4DPROC VertexAttribL4d;
    PFNGLVERTEXATTRIBL1DVPROC VertexAttribL1dv;
    PFNGLVERTEXATTRIBL2DVPROC VertexAttribL2dv;
    PFNGLVERTEXATTRIBL3DVPROC VertexAttribL3dv;
    PFNGLVERTEXATTRIBL4DVPROC VertexAttribL4dv;
    PFNGLVERTEXATTRIBLPOINTERPROC VertexAttribLPointer;
    PFNGLGETVERTEXATTRIBLDVPROC GetVertexAttribLdv;
    PFNGLVIEWPORTARRAYVPROC ViewportArrayv;
    PFNGLVIEWPORTINDEXEDFPROC ViewportIndexedf;
    PFNGLVIEWPORTINDEXEDFVPROC ViewportIndexedfv;
    PFNGLSCISSORARRAYVPROC ScissorArrayv;
    PFNGLSCISSORINDEXEDPROC ScissorIndexed;
    PFNGLSCISSORINDEXEDVPROC ScissorIndexedv;
    PFNGLDEPTHRANGEARRAYVPROC DepthRangeArrayv;
    PFNGLDEPTHRANGEINDEXEDPROC DepthRangeIndexed;
    PFNGLGETFLOATI_VPROC GetFloati_v;
    PFNGLGETDOUBLEI_VPROC GetDoublei_v;
    PFNGLDRAWARRAYSINSTANCEDBASEINSTANCEPROC DrawArraysInstancedBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEINSTANCEPROC DrawElementsInstancedBaseInstance;
    PFNGLDRAWELEMENTSINSTANCEDBASEVERTEXBASEINSTANCEPROC DrawElementsInstancedBaseVertexBaseInstance;
    PFNGLGETINTERNALFORMATIVPROC GetInternalformativ;
    PFNGLGETACTIVEATOMICCOUNTERBUFFERIVPROC GetActiveAtomicCounterBufferiv;
    PFNGLBINDIMAGETEXTUREPROC BindImageTexture;
    PFNGLMEMORYBARRIERPROC MemoryBarrier;
    PFNGLTEXSTORAGE1DPROC TexStorage1D;
    PFNGLTEXSTORAGE2DPROC TexStorage2D;
    PFNGLTEXSTORAGE3DPROC TexStorage3D;
    PFNGLDRAWTRANSFORMFEEDBACKINSTANCEDPROC DrawTransformFeedbackInstanced;
    PFNGLDRAWTRANSFORMFEEDBACKSTREAMINSTANCEDPROC DrawTransformFeedbackStreamInstanced;
    PFNGLCLEARBUFFERDATAPROC ClearBufferData;
    PFNGLCLEARBUFFERSUBDATAPROC ClearBufferSubData;
    PFNGLDISPATCHCOMPUTEPROC DispatchCompute;
    PFNGLDISPATCHCOMPUTEINDIRECTPROC DispatchComputeIndirect;
    PFNGLCOPYIMAGESUBDATAPROC CopyImageSubData;
    PFNGLFRAMEBUFFERPARAMETERIPROC FramebufferParameteri;
    PFNGLGETFRAMEBUFFERPARAMETERIVPROC GetFramebufferParameteriv;
    PFNGLGETINTERNALFORMATI64VPROC GetInternalformati64v;
    PFNGLINVALIDATETEXSUBIMAGEPROC InvalidateTexSubImage;
    PFNGLINVALIDATETEXIMAGEPROC InvalidateTexImage;
    PFNGLINVALIDATEBUFFERSUBDATAPROC InvalidateBufferSubData;
    PFNGLINVALIDATEBUFFERDATAPROC InvalidateBufferData;
    PFNGLINVALIDATEFRAMEBUFFERPROC InvalidateFramebuffer;
    PFNGLINVALIDATESUBFRAMEBUFFERPROC InvalidateSubFramebuffer;
    PFNGLMULTIDRAWARRAYSINDIRECTPROC MultiDrawArraysIndirect;
    PFNGLMULTIDRAWELEMENTSINDIRECTPROC MultiDrawElementsIndirect;
    PFNGLGETPROGRAMINTERFACEIVPROC GetProgramInterfaceiv;
    PFNGLGETPROGRAMRESOURCEINDEXPROC GetProgramResourceIndex;
    PFNGLGETPROGRAMRESOURCENAMEPROC GetProgramResourceName;
    PFNGLGETPROGRAMRESOURCEIVPROC GetProgramResourceiv;
    PFNGLGETPROGRAMRESOURCELOCATIONPROC GetProgramResourceLocation;
    PFNGLGETPROGRAMRESOURCELOCATIONINDEXPROC GetProgramResourceLocationIndex;
    PFNGLSHADERSTORAGEBLOCKBINDINGPROC ShaderStorageBlockBinding;
    PFNGLTEXBUFFERRANGEPROC TexBufferRange;
    PFNGLTEXSTORAGE2DMULTISAMPLEPROC TexStorage2DMultisample;
    PFNGLTEXSTORAGE3DMULTISAMPLEPROC TexStorage3DMultisample;
    PFNGLTEXTUREVIEWPROC TextureView;
    PFNGLBINDVERTEXBUFFERPROC BindVertexBuffer;
    PFNGLVERTEXATTRIBFORMATPROC VertexAttribFormat;
    PFNGLVERTEXATTRIBIFORMATPROC VertexAttribIFormat;
    PFNGLVERTEXATTRIBLFORMATPROC VertexAttribLFormat;
    PFNGLVERTEXATTRIBBINDINGPROC VertexAttribBinding;
    PFNGLVERTEXBINDINGDIVISORPROC VertexBindingDivisor;
    PFNGLDEBUGMESSAGECONTROLPROC DebugMessageControl;
    PFNGLDEBUGMESSAGEINSERTPROC DebugMessageInsert;
    PFNGLDEBUGMESSAGECALLBACKPROC DebugMessageCallback;
    PFNGLGETDEBUGMESSAGELOGPROC GetDebugMessageLog;
    PFNGLPUSHDEBUGGROUPPROC PushDebugGroup;
    PFNGLPOPDEBUGGROUPPROC PopDebugGroup;
    PFNGLOBJECTLABELPROC ObjectLabel;
    PFNGLGETOBJECTLABELPROC GetObjectLabel;
    PFNGLOBJECTPTRLABELPROC ObjectPtrLabel;
    PFNGLGETOBJECTPTRLABELPROC GetObjectPtrLabel;
    PFNGLBUFFERSTORAGEPROC BufferStorage;
    PFNGLCLEARTEXIMAGEPROC ClearTexImage;
    PFNGLCLEARTEXSUBIMAGEPROC ClearTexSubImage;
    PFNGLBINDBUFFERSBASEPROC BindBuffersBase;
    PFNGLBINDBUFFERSRANGEPROC BindBuffersRange;
    PFNGLBINDTEXTURESPROC BindTextures;
    PFNGLBINDSAMPLERSPROC BindSamplers;
    PFNGLBINDIMAGETEXTURESPROC BindImageTextures;
    PFNGLBINDVERTEXBUFFERSPROC BindVertexBuffers;
    PFNGLCLIPCONTROLPROC ClipControl;
    PFNGLCREATETRANSFORMFEEDBACKSPROC CreateTransformFeedbacks;
    PFNGLTRANSFORMFEEDBACKBUFFERBASEPROC TransformFeedbackBufferBase;
    PFNGLTRANSFORMFEEDBACKBUFFERRANGEPROC TransformFeedbackBufferRange;
    PFNGLGETTRANSFORMFEEDBACKIVPROC GetTransformFeedbackiv;
    PFNGLGETTRANSFORMFEEDBACKI_VPROC GetTransformFeedbacki_v;
    PFNGLGETTRANSFORMFEEDBACKI64_VPROC GetTransformFeedbacki64_v;
    PFNGLCREATEBUFFERSPROC CreateBuffers;
    PFNGLNAMEDBUFFERSTORAGEPROC NamedBufferStorage;
    PFNGLNAMEDBUFFERDATAPROC NamedBufferData;
    PFNGLNAMEDBUFFERSUBDATAPROC NamedBufferSubData;
    PFNGLCOPYNAMEDBUFFERSUBDATAPROC CopyNamedBufferSubData;
    PFNGLCLEARNAMEDBUFFERDATAPROC ClearNamedBufferData;
    PFNGLCLEARNAMEDBUFFERSUBDATAPROC ClearNamedBufferSubData;
    PFNGLMAPNAMEDBUFFERPROC MapNamedBuffer;
    PFNGLMAPNAMEDBUFFERRANGEPROC MapNamedBufferRange;
    PFNGLUNMAPNAMEDBUFFERPROC UnmapNamedBuffer;
    PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEPROC FlushMappedNamedBufferRange;
    PFNGLGETNAMEDBUFFERPARAMETERIVPROC GetNamedBufferParameteriv;
    PFNGLGETNAMEDBUFFERPARAMETERI64VPROC GetNamedBufferParameteri64v;
    PFNGLGETNAMEDBUFFERPOINTERVPROC GetNamedBufferPointerv;
    PFNGLGETNAMEDBUFFERSUBDATAPROC GetNamedBufferSubData;
    PFNGLCREATEFRAMEBUFFERSPROC CreateFramebuffers;
    PFNGLNAMEDFRAMEBUFFERRENDERBUFFERPROC NamedFramebufferRenderbuffer;
    PFNGLNAMEDFRAMEBUFFERPARAMETERIPROC NamedFramebufferParameteri;
    PFNGLNAMEDFRAMEBUFFERTEXTUREPROC NamedFramebufferTexture;
    PFNGLNAMEDFRAMEBUFFERTEXTURELAYERPROC NamedFramebufferTextureLayer;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERPROC NamedFramebufferDrawBuffer;
    PFNGLNAMEDFRAMEBUFFERDRAWBUFFERSPROC NamedFramebufferDrawBuffers;
    PFNGLNAMEDFRAMEBUFFERREADBUFFERPROC NamedFramebufferReadBuffer;
    PFNGLINVALIDATENAMEDFRAMEBUFFERDATAPROC InvalidateNamedFramebufferData;
    PFNGLINVALIDATENAMEDFRAMEBUFFERSUBDATAPROC InvalidateNamedFramebufferSubData;
    PFNGLCLEARNAMEDFRAMEBUFFERIVPROC ClearNamedFramebufferiv;
    PFNGLCLEARNAMEDFRAMEBUFFERUIVPROC ClearNamedFramebufferuiv;
    PFNGLCLEARNAMEDFRAMEBUFFERFVPROC ClearNamedFramebufferfv;
    PFNGLCLEARNAMEDFRAMEBUFFERFIPROC ClearNamedFramebufferfi;
    PFNGLBLITNAMEDFRAMEBUFFERPROC BlitNamedFramebuffer;
    PFNGLCHECKNAMEDFRAMEBUFFERSTATUSPROC CheckNamedFramebufferStatus;
    PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVPROC GetNamedFramebufferParameteriv;
    PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVPROC GetNamedFramebufferAttachmentParameteriv;
    PFNGLCREATERENDERBUFFERSPROC CreateRenderbuffers;
    PFNGLNAMEDRENDERBUFFERSTORAGEPROC NamedRenderbufferStorage;
    PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEPROC NamedRenderbufferStorageMultisample;
    PFNGLGETNAMEDRENDERBUFFERPARAMETERIVPROC GetNamedRenderbufferParameteriv;
    PFNGLCREATETEXTURESPROC CreateTextures;
    PFNGLTEXTUREBUFFERPROC TextureBuffer;
    PFNGLTEXTUREBUFFERRANGEPROC TextureBufferRange;
    PFNGLTEXTURESTORAGE1DPROC TextureStorage1D;
    PFNGLTEXTURESTORAGE2DPROC TextureStorage2D;
    PFNGLTEXTURESTORAGE3DPROC TextureStorage3D;
    PFNGLTEXTURESTORAGE2DMULTISAMPLEPROC TextureStorage2DMultisample;
    PFNGLTEXTURESTORAGE3DMULTISAMPLEPROC TextureStorage3DMultisample;
    PFNGLTEXTURESUBIMAGE1DPROC TextureSubImage1D;
    PFNGLTEXTURESUBIMAGE2DPROC TextureSubImage2D;
    PFNGLTEXTURESUBIMAGE3DPROC TextureSubImage3D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE1DPROC CompressedTextureSubImage1D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE2DPROC CompressedTextureSubImage2D;
    PFNGLCOMPRESSEDTEXTURESUBIMAGE3DPROC CompressedTextureSubImage3D;
    PFNGLCOPYTEXTURESUBIMAGE1DPROC CopyTextureSubImage1D;
    PFNGLCOPYTEXTURESUBIMAGE2DPROC CopyTextureSubImage2D;
    PFNGLCOPYTEXTURESUBIMAGE3DPROC CopyTextureSubImage3D;
    PFNGLTEXTUREPARAMETERFPROC TextureParameterf;
    PFNGLTEXTUREPARAMETERFVPROC TextureParameterfv;
    PFNGLTEXTUREPARAMETERIPROC TextureParameteri;
    PFNGLTEXTUREPARAMETERIIVPROC TextureParameterIiv;
    PFNGLTEXTUREPARAMETERIUIVPROC TextureParameterIuiv;
    PFNGLTEXTUREPARAMETERIVPROC TextureParameteriv;
    PFNGLGENERATETEXTUREMIPMAPPROC GenerateTextureMipmap;
    PFNGLBINDTEXTUREUNITPROC BindTextureUnit;
    PFNGLGETTEXTUREIMAGEPROC GetTextureImage;
    PFNGLGETCOMPRESSEDTEXTUREIMAGEPROC GetCompressedTextureImage;
    PFNGLGETTEXTURELEVELPARAMETERFVPROC GetTextureLevelParameterfv;
    PFNGLGETTEXTURELEVELPARAMETERIVPROC GetTextureLevelParameteriv;
    PFNGLGETTEXTUREPARAMETERFVPROC GetTextureParameterfv;
    PFNGLGETTEXTUREPARAMETERIIVPROC GetTextureParameterIiv;
    PFNGLGETTEXTUREPARAMETERIUIVPROC GetTextureParameterIuiv;
    PFNGLGETTEXTUREPARAMETERIVPROC GetTextureParameteriv;
    PFNGLCREATEVERTEXARRAYSPROC CreateVertexArrays;
    PFNGLDISABLEVERTEXARRAYATTRIBPROC DisableVertexArrayAttrib;
    PFNGLENABLEVERTEXARRAYATTRIBPROC EnableVertexArrayAttrib;
    PFNGLVERTEXARRAYELEMENTBUFFERPROC VertexArrayElementBuffer;
    PFNGLVERTEXARRAYVERTEXBUFFERPROC VertexArrayVertexBuffer;
    PFNGLVERTEXARRAYVERTEXBUFFERSPROC VertexArrayVertexBuffers;
    PFNGLVERTEXARRAYATTRIBBINDINGPROC VertexArrayAttribBinding;
    PFNGLVERTEXARRAYATTRIBFORMATPROC VertexArrayAttribFormat;
    PFNGLVERTEXARRAYATTRIBIFORMATPROC VertexArrayAttribIFormat;
    PFNGLVERTEXARRAYATTRIBLFORMATPROC VertexArrayAttribLFormat;
    PFNGLVERTEXARRAYBINDINGDIVISORPROC VertexArrayBindingDivisor;
    PFNGLGETVERTEXARRAYIVPROC GetVertexArrayiv;
    PFNGLGETVERTEXARRAYINDEXEDIVPROC GetVertexArrayIndexediv;
    PFNGLGETVERTEXARRAYINDEXED64IVPROC GetVertexArrayIndexed64iv;
    PFNGLCREATESAMPLERSPROC CreateSamplers;
    PFNGLCREATEPROGRAMPIPELINESPROC CreateProgramPipelines;
    PFNGLCREATEQUERIESPROC CreateQueries;
    PFNGLGETQUERYBUFFEROBJECTI64VPROC GetQueryBufferObjecti64v;
    PFNGLGETQUERYBUFFEROBJECTIVPROC GetQueryBufferObjectiv;
    PFNGLGETQUERYBUFFEROBJECTUI64VPROC GetQueryBufferObjectui64v;
    PFNGLGETQUERYBUFFEROBJECTUIVPROC GetQueryBufferObjectuiv;
    PFNGLMEMORYBARRIERBYREGIONPROC MemoryBarrierByRegion;
    PFNGLGETTEXTURESUBIMAGEPROC GetTextureSubImage;
    PFNGLGETCOMPRESSEDTEXTURESUBIMAGEPROC GetCompressedTextureSubImage;
    PFNGLGETGRAPHICSRESETSTATUSPROC GetGraphicsResetStatus;
    PFNGLGETNCOMPRESSEDTEXIMAGEPROC GetnCompressedTexImage;
    PFNGLGETNTEXIMAGEPROC GetnTexImage;
    PFNGLGETNUNIFORMDVPROC GetnUniformdv;
    PFNGLGETNUNIFORMFVPROC GetnUniformfv;
    PFNGLGETNUNIFORMIVPROC GetnUniformiv;
    PFNGLGETNUNIFORMUIVPROC GetnUniformuiv;
    PFNGLREADNPIXELSPROC ReadnPixels;
    PFNGLTEXTUREBARRIERPROC TextureBarrier;
    PFNGLSPECIALIZESHADERPROC SpecializeShader;
    PFNGLMULTIDRAWARRAYSINDIRECTCOUNTPROC MultiDrawArraysIndirectCount;
    PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTPROC MultiDrawElementsIndirectCount;
    PFNGLPOLYGONOFFSETCLAMPPROC PolygonOffsetClamp;
    // PFNGLPRIMITIVEBOUNDINGBOXARBPROC PrimitiveBoundingBoxARB;
    PFNGLGETTEXTUREHANDLEARBPROC GetTextureHandleARB;
    // PFNGLGETTEXTURESAMPLERHANDLEARBPROC GetTextureSamplerHandleARB;
    PFNGLMAKETEXTUREHANDLERESIDENTARBPROC MakeTextureHandleResidentARB;
    PFNGLMAKETEXTUREHANDLENONRESIDENTARBPROC MakeTextureHandleNonResidentARB;
    // PFNGLGETIMAGEHANDLEARBPROC GetImageHandleARB;
    // PFNGLMAKEIMAGEHANDLERESIDENTARBPROC MakeImageHandleResidentARB;
    // PFNGLMAKEIMAGEHANDLENONRESIDENTARBPROC MakeImageHandleNonResidentARB;
    // PFNGLUNIFORMHANDLEUI64ARBPROC UniformHandleui64ARB;
    // PFNGLUNIFORMHANDLEUI64VARBPROC UniformHandleui64vARB;
    PFNGLPROGRAMUNIFORMHANDLEUI64ARBPROC ProgramUniformHandleui64ARB;
    // PFNGLPROGRAMUNIFORMHANDLEUI64VARBPROC ProgramUniformHandleui64vARB;
    // PFNGLISTEXTUREHANDLERESIDENTARBPROC IsTextureHandleResidentARB;
    // PFNGLISIMAGEHANDLERESIDENTARBPROC IsImageHandleResidentARB;
    // PFNGLVERTEXATTRIBL1UI64ARBPROC VertexAttribL1ui64ARB;
    // PFNGLVERTEXATTRIBL1UI64VARBPROC VertexAttribL1ui64vARB;
    // PFNGLGETVERTEXATTRIBLUI64VARBPROC GetVertexAttribLui64vARB;
    // PFNGLCREATESYNCFROMCLEVENTARBPROC CreateSyncFromCLeventARB;
    // PFNGLDISPATCHCOMPUTEGROUPSIZEARBPROC DispatchComputeGroupSizeARB;
    // PFNGLDEBUGMESSAGECONTROLARBPROC DebugMessageControlARB;
    // PFNGLDEBUGMESSAGEINSERTARBPROC DebugMessageInsertARB;
    // PFNGLDEBUGMESSAGECALLBACKARBPROC DebugMessageCallbackARB;
    // PFNGLGETDEBUGMESSAGELOGARBPROC GetDebugMessageLogARB;
    // PFNGLBLENDEQUATIONIARBPROC BlendEquationiARB;
    // PFNGLBLENDEQUATIONSEPARATEIARBPROC BlendEquationSeparateiARB;
    // PFNGLBLENDFUNCIARBPROC BlendFunciARB;
    // PFNGLBLENDFUNCSEPARATEIARBPROC BlendFuncSeparateiARB;
    // PFNGLDRAWARRAYSINSTANCEDARBPROC DrawArraysInstancedARB;
    // PFNGLDRAWELEMENTSINSTANCEDARBPROC DrawElementsInstancedARB;
    // PFNGLPROGRAMPARAMETERIARBPROC ProgramParameteriARB;
    // PFNGLFRAMEBUFFERTEXTUREARBPROC FramebufferTextureARB;
    // PFNGLFRAMEBUFFERTEXTURELAYERARBPROC FramebufferTextureLayerARB;
    // PFNGLFRAMEBUFFERTEXTUREFACEARBPROC FramebufferTextureFaceARB;
    // PFNGLSPECIALIZESHADERARBPROC SpecializeShaderARB;
    // PFNGLUNIFORM1I64ARBPROC Uniform1i64ARB;
    // PFNGLUNIFORM2I64ARBPROC Uniform2i64ARB;
    // PFNGLUNIFORM3I64ARBPROC Uniform3i64ARB;
    // PFNGLUNIFORM4I64ARBPROC Uniform4i64ARB;
    // PFNGLUNIFORM1I64VARBPROC Uniform1i64vARB;
    // PFNGLUNIFORM2I64VARBPROC Uniform2i64vARB;
    // PFNGLUNIFORM3I64VARBPROC Uniform3i64vARB;
    // PFNGLUNIFORM4I64VARBPROC Uniform4i64vARB;
    // PFNGLUNIFORM1UI64ARBPROC Uniform1ui64ARB;
    // PFNGLUNIFORM2UI64ARBPROC Uniform2ui64ARB;
    // PFNGLUNIFORM3UI64ARBPROC Uniform3ui64ARB;
    // PFNGLUNIFORM4UI64ARBPROC Uniform4ui64ARB;
    // PFNGLUNIFORM1UI64VARBPROC Uniform1ui64vARB;
    // PFNGLUNIFORM2UI64VARBPROC Uniform2ui64vARB;
    // PFNGLUNIFORM3UI64VARBPROC Uniform3ui64vARB;
    // PFNGLUNIFORM4UI64VARBPROC Uniform4ui64vARB;
    // PFNGLGETUNIFORMI64VARBPROC GetUniformi64vARB;
    // PFNGLGETUNIFORMUI64VARBPROC GetUniformui64vARB;
    // PFNGLGETNUNIFORMI64VARBPROC GetnUniformi64vARB;
    // PFNGLGETNUNIFORMUI64VARBPROC GetnUniformui64vARB;
    // PFNGLPROGRAMUNIFORM1I64ARBPROC ProgramUniform1i64ARB;
    // PFNGLPROGRAMUNIFORM2I64ARBPROC ProgramUniform2i64ARB;
    // PFNGLPROGRAMUNIFORM3I64ARBPROC ProgramUniform3i64ARB;
    // PFNGLPROGRAMUNIFORM4I64ARBPROC ProgramUniform4i64ARB;
    // PFNGLPROGRAMUNIFORM1I64VARBPROC ProgramUniform1i64vARB;
    // PFNGLPROGRAMUNIFORM2I64VARBPROC ProgramUniform2i64vARB;
    // PFNGLPROGRAMUNIFORM3I64VARBPROC ProgramUniform3i64vARB;
    // PFNGLPROGRAMUNIFORM4I64VARBPROC ProgramUniform4i64vARB;
    // PFNGLPROGRAMUNIFORM1UI64ARBPROC ProgramUniform1ui64ARB;
    // PFNGLPROGRAMUNIFORM2UI64ARBPROC ProgramUniform2ui64ARB;
    // PFNGLPROGRAMUNIFORM3UI64ARBPROC ProgramUniform3ui64ARB;
    // PFNGLPROGRAMUNIFORM4UI64ARBPROC ProgramUniform4ui64ARB;
    // PFNGLPROGRAMUNIFORM1UI64VARBPROC ProgramUniform1ui64vARB;
    // PFNGLPROGRAMUNIFORM2UI64VARBPROC ProgramUniform2ui64vARB;
    // PFNGLPROGRAMUNIFORM3UI64VARBPROC ProgramUniform3ui64vARB;
    // PFNGLPROGRAMUNIFORM4UI64VARBPROC ProgramUniform4ui64vARB;
    // PFNGLMULTIDRAWARRAYSINDIRECTCOUNTARBPROC MultiDrawArraysIndirectCountARB;
    // PFNGLMULTIDRAWELEMENTSINDIRECTCOUNTARBPROC MultiDrawElementsIndirectCountARB;
    // PFNGLVERTEXATTRIBDIVISORARBPROC VertexAttribDivisorARB;
    // PFNGLMAXSHADERCOMPILERTHREADSARBPROC MaxShaderCompilerThreadsARB;
    // PFNGLGETGRAPHICSRESETSTATUSARBPROC GetGraphicsResetStatusARB;
    // PFNGLGETNTEXIMAGEARBPROC GetnTexImageARB;
    // PFNGLREADNPIXELSARBPROC ReadnPixelsARB;
    // PFNGLGETNCOMPRESSEDTEXIMAGEARBPROC GetnCompressedTexImageARB;
    // PFNGLGETNUNIFORMFVARBPROC GetnUniformfvARB;
    // PFNGLGETNUNIFORMIVARBPROC GetnUniformivARB;
    // PFNGLGETNUNIFORMUIVARBPROC GetnUniformuivARB;
    // PFNGLGETNUNIFORMDVARBPROC GetnUniformdvARB;
    // PFNGLFRAMEBUFFERSAMPLELOCATIONSFVARBPROC FramebufferSampleLocationsfvARB;
    // PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVARBPROC NamedFramebufferSampleLocationsfvARB;
    // PFNGLEVALUATEDEPTHVALUESARBPROC EvaluateDepthValuesARB;
    // PFNGLMINSAMPLESHADINGARBPROC MinSampleShadingARB;
    // PFNGLNAMEDSTRINGARBPROC NamedStringARB;
    // PFNGLDELETENAMEDSTRINGARBPROC DeleteNamedStringARB;
    // PFNGLCOMPILESHADERINCLUDEARBPROC CompileShaderIncludeARB;
    // PFNGLISNAMEDSTRINGARBPROC IsNamedStringARB;
    // PFNGLGETNAMEDSTRINGARBPROC GetNamedStringARB;
    // PFNGLGETNAMEDSTRINGIVARBPROC GetNamedStringivARB;
    // PFNGLBUFFERPAGECOMMITMENTARBPROC BufferPageCommitmentARB;
    // PFNGLNAMEDBUFFERPAGECOMMITMENTEXTPROC NamedBufferPageCommitmentEXT;
    // PFNGLNAMEDBUFFERPAGECOMMITMENTARBPROC NamedBufferPageCommitmentARB;
    // PFNGLTEXPAGECOMMITMENTARBPROC TexPageCommitmentARB;
    // PFNGLTEXBUFFERARBPROC TexBufferARB;
    // PFNGLDEPTHRANGEARRAYDVNVPROC DepthRangeArraydvNV;
    // PFNGLDEPTHRANGEINDEXEDDNVPROC DepthRangeIndexeddNV;
    // PFNGLBLENDBARRIERKHRPROC BlendBarrierKHR;
    // PFNGLMAXSHADERCOMPILERTHREADSKHRPROC MaxShaderCompilerThreadsKHR;
    // PFNGLRENDERBUFFERSTORAGEMULTISAMPLEADVANCEDAMDPROC RenderbufferStorageMultisampleAdvancedAMD;
    // PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEADVANCEDAMDPROC NamedRenderbufferStorageMultisampleAdvancedAMD;
    // PFNGLGETPERFMONITORGROUPSAMDPROC GetPerfMonitorGroupsAMD;
    // PFNGLGETPERFMONITORCOUNTERSAMDPROC GetPerfMonitorCountersAMD;
    // PFNGLGETPERFMONITORGROUPSTRINGAMDPROC GetPerfMonitorGroupStringAMD;
    // PFNGLGETPERFMONITORCOUNTERSTRINGAMDPROC GetPerfMonitorCounterStringAMD;
    // PFNGLGETPERFMONITORCOUNTERINFOAMDPROC GetPerfMonitorCounterInfoAMD;
    // PFNGLGENPERFMONITORSAMDPROC GenPerfMonitorsAMD;
    // PFNGLDELETEPERFMONITORSAMDPROC DeletePerfMonitorsAMD;
    // PFNGLSELECTPERFMONITORCOUNTERSAMDPROC SelectPerfMonitorCountersAMD;
    // PFNGLBEGINPERFMONITORAMDPROC BeginPerfMonitorAMD;
    // PFNGLENDPERFMONITORAMDPROC EndPerfMonitorAMD;
    // PFNGLGETPERFMONITORCOUNTERDATAAMDPROC GetPerfMonitorCounterDataAMD;
    // PFNGLEGLIMAGETARGETTEXSTORAGEEXTPROC EGLImageTargetTexStorageEXT;
    // PFNGLEGLIMAGETARGETTEXTURESTORAGEEXTPROC EGLImageTargetTextureStorageEXT;
    // PFNGLLABELOBJECTEXTPROC LabelObjectEXT;
    // PFNGLGETOBJECTLABELEXTPROC GetObjectLabelEXT;
    // PFNGLINSERTEVENTMARKEREXTPROC InsertEventMarkerEXT;
    // PFNGLPUSHGROUPMARKEREXTPROC PushGroupMarkerEXT;
    // PFNGLPOPGROUPMARKEREXTPROC PopGroupMarkerEXT;
    // PFNGLMATRIXLOADFEXTPROC MatrixLoadfEXT;
    // PFNGLMATRIXLOADDEXTPROC MatrixLoaddEXT;
    // PFNGLMATRIXMULTFEXTPROC MatrixMultfEXT;
    // PFNGLMATRIXMULTDEXTPROC MatrixMultdEXT;
    // PFNGLMATRIXLOADIDENTITYEXTPROC MatrixLoadIdentityEXT;
    // PFNGLMATRIXROTATEFEXTPROC MatrixRotatefEXT;
    // PFNGLMATRIXROTATEDEXTPROC MatrixRotatedEXT;
    // PFNGLMATRIXSCALEFEXTPROC MatrixScalefEXT;
    // PFNGLMATRIXSCALEDEXTPROC MatrixScaledEXT;
    // PFNGLMATRIXTRANSLATEFEXTPROC MatrixTranslatefEXT;
    // PFNGLMATRIXTRANSLATEDEXTPROC MatrixTranslatedEXT;
    // PFNGLMATRIXFRUSTUMEXTPROC MatrixFrustumEXT;
    // PFNGLMATRIXORTHOEXTPROC MatrixOrthoEXT;
    // PFNGLMATRIXPOPEXTPROC MatrixPopEXT;
    // PFNGLMATRIXPUSHEXTPROC MatrixPushEXT;
    // PFNGLCLIENTATTRIBDEFAULTEXTPROC ClientAttribDefaultEXT;
    // PFNGLPUSHCLIENTATTRIBDEFAULTEXTPROC PushClientAttribDefaultEXT;
    // PFNGLTEXTUREPARAMETERFEXTPROC TextureParameterfEXT;
    // PFNGLTEXTUREPARAMETERFVEXTPROC TextureParameterfvEXT;
    // PFNGLTEXTUREPARAMETERIEXTPROC TextureParameteriEXT;
    // PFNGLTEXTUREPARAMETERIVEXTPROC TextureParameterivEXT;
    // PFNGLTEXTUREIMAGE1DEXTPROC TextureImage1DEXT;
    // PFNGLTEXTUREIMAGE2DEXTPROC TextureImage2DEXT;
    // PFNGLTEXTURESUBIMAGE1DEXTPROC TextureSubImage1DEXT;
    // PFNGLTEXTURESUBIMAGE2DEXTPROC TextureSubImage2DEXT;
    // PFNGLCOPYTEXTUREIMAGE1DEXTPROC CopyTextureImage1DEXT;
    // PFNGLCOPYTEXTUREIMAGE2DEXTPROC CopyTextureImage2DEXT;
    // PFNGLCOPYTEXTURESUBIMAGE1DEXTPROC CopyTextureSubImage1DEXT;
    // PFNGLCOPYTEXTURESUBIMAGE2DEXTPROC CopyTextureSubImage2DEXT;
    // PFNGLGETTEXTUREIMAGEEXTPROC GetTextureImageEXT;
    // PFNGLGETTEXTUREPARAMETERFVEXTPROC GetTextureParameterfvEXT;
    // PFNGLGETTEXTUREPARAMETERIVEXTPROC GetTextureParameterivEXT;
    // PFNGLGETTEXTURELEVELPARAMETERFVEXTPROC GetTextureLevelParameterfvEXT;
    // PFNGLGETTEXTURELEVELPARAMETERIVEXTPROC GetTextureLevelParameterivEXT;
    // PFNGLTEXTUREIMAGE3DEXTPROC TextureImage3DEXT;
    // PFNGLTEXTURESUBIMAGE3DEXTPROC TextureSubImage3DEXT;
    // PFNGLCOPYTEXTURESUBIMAGE3DEXTPROC CopyTextureSubImage3DEXT;
    // PFNGLBINDMULTITEXTUREEXTPROC BindMultiTextureEXT;
    // PFNGLMULTITEXCOORDPOINTEREXTPROC MultiTexCoordPointerEXT;
    // PFNGLMULTITEXENVFEXTPROC MultiTexEnvfEXT;
    // PFNGLMULTITEXENVFVEXTPROC MultiTexEnvfvEXT;
    // PFNGLMULTITEXENVIEXTPROC MultiTexEnviEXT;
    // PFNGLMULTITEXENVIVEXTPROC MultiTexEnvivEXT;
    // PFNGLMULTITEXGENDEXTPROC MultiTexGendEXT;
    // PFNGLMULTITEXGENDVEXTPROC MultiTexGendvEXT;
    // PFNGLMULTITEXGENFEXTPROC MultiTexGenfEXT;
    // PFNGLMULTITEXGENFVEXTPROC MultiTexGenfvEXT;
    // PFNGLMULTITEXGENIEXTPROC MultiTexGeniEXT;
    // PFNGLMULTITEXGENIVEXTPROC MultiTexGenivEXT;
    // PFNGLGETMULTITEXENVFVEXTPROC GetMultiTexEnvfvEXT;
    // PFNGLGETMULTITEXENVIVEXTPROC GetMultiTexEnvivEXT;
    // PFNGLGETMULTITEXGENDVEXTPROC GetMultiTexGendvEXT;
    // PFNGLGETMULTITEXGENFVEXTPROC GetMultiTexGenfvEXT;
    // PFNGLGETMULTITEXGENIVEXTPROC GetMultiTexGenivEXT;
    // PFNGLMULTITEXPARAMETERIEXTPROC MultiTexParameteriEXT;
    // PFNGLMULTITEXPARAMETERIVEXTPROC MultiTexParameterivEXT;
    // PFNGLMULTITEXPARAMETERFEXTPROC MultiTexParameterfEXT;
    // PFNGLMULTITEXPARAMETERFVEXTPROC MultiTexParameterfvEXT;
    // PFNGLMULTITEXIMAGE1DEXTPROC MultiTexImage1DEXT;
    // PFNGLMULTITEXIMAGE2DEXTPROC MultiTexImage2DEXT;
    // PFNGLMULTITEXSUBIMAGE1DEXTPROC MultiTexSubImage1DEXT;
    // PFNGLMULTITEXSUBIMAGE2DEXTPROC MultiTexSubImage2DEXT;
    // PFNGLCOPYMULTITEXIMAGE1DEXTPROC CopyMultiTexImage1DEXT;
    // PFNGLCOPYMULTITEXIMAGE2DEXTPROC CopyMultiTexImage2DEXT;
    // PFNGLCOPYMULTITEXSUBIMAGE1DEXTPROC CopyMultiTexSubImage1DEXT;
    // PFNGLCOPYMULTITEXSUBIMAGE2DEXTPROC CopyMultiTexSubImage2DEXT;
    // PFNGLGETMULTITEXIMAGEEXTPROC GetMultiTexImageEXT;
    // PFNGLGETMULTITEXPARAMETERFVEXTPROC GetMultiTexParameterfvEXT;
    // PFNGLGETMULTITEXPARAMETERIVEXTPROC GetMultiTexParameterivEXT;
    // PFNGLGETMULTITEXLEVELPARAMETERFVEXTPROC GetMultiTexLevelParameterfvEXT;
    // PFNGLGETMULTITEXLEVELPARAMETERIVEXTPROC GetMultiTexLevelParameterivEXT;
    // PFNGLMULTITEXIMAGE3DEXTPROC MultiTexImage3DEXT;
    // PFNGLMULTITEXSUBIMAGE3DEXTPROC MultiTexSubImage3DEXT;
    // PFNGLCOPYMULTITEXSUBIMAGE3DEXTPROC CopyMultiTexSubImage3DEXT;
    // PFNGLENABLECLIENTSTATEINDEXEDEXTPROC EnableClientStateIndexedEXT;
    // PFNGLDISABLECLIENTSTATEINDEXEDEXTPROC DisableClientStateIndexedEXT;
    // PFNGLGETFLOATINDEXEDVEXTPROC GetFloatIndexedvEXT;
    // PFNGLGETDOUBLEINDEXEDVEXTPROC GetDoubleIndexedvEXT;
    // PFNGLGETPOINTERINDEXEDVEXTPROC GetPointerIndexedvEXT;
    // PFNGLENABLEINDEXEDEXTPROC EnableIndexedEXT;
    // PFNGLDISABLEINDEXEDEXTPROC DisableIndexedEXT;
    // PFNGLISENABLEDINDEXEDEXTPROC IsEnabledIndexedEXT;
    // PFNGLGETINTEGERINDEXEDVEXTPROC GetIntegerIndexedvEXT;
    // PFNGLGETBOOLEANINDEXEDVEXTPROC GetBooleanIndexedvEXT;
    // PFNGLCOMPRESSEDTEXTUREIMAGE3DEXTPROC CompressedTextureImage3DEXT;
    // PFNGLCOMPRESSEDTEXTUREIMAGE2DEXTPROC CompressedTextureImage2DEXT;
    // PFNGLCOMPRESSEDTEXTUREIMAGE1DEXTPROC CompressedTextureImage1DEXT;
    // PFNGLCOMPRESSEDTEXTURESUBIMAGE3DEXTPROC CompressedTextureSubImage3DEXT;
    // PFNGLCOMPRESSEDTEXTURESUBIMAGE2DEXTPROC CompressedTextureSubImage2DEXT;
    // PFNGLCOMPRESSEDTEXTURESUBIMAGE1DEXTPROC CompressedTextureSubImage1DEXT;
    // PFNGLGETCOMPRESSEDTEXTUREIMAGEEXTPROC GetCompressedTextureImageEXT;
    // PFNGLCOMPRESSEDMULTITEXIMAGE3DEXTPROC CompressedMultiTexImage3DEXT;
    // PFNGLCOMPRESSEDMULTITEXIMAGE2DEXTPROC CompressedMultiTexImage2DEXT;
    // PFNGLCOMPRESSEDMULTITEXIMAGE1DEXTPROC CompressedMultiTexImage1DEXT;
    // PFNGLCOMPRESSEDMULTITEXSUBIMAGE3DEXTPROC CompressedMultiTexSubImage3DEXT;
    // PFNGLCOMPRESSEDMULTITEXSUBIMAGE2DEXTPROC CompressedMultiTexSubImage2DEXT;
    // PFNGLCOMPRESSEDMULTITEXSUBIMAGE1DEXTPROC CompressedMultiTexSubImage1DEXT;
    // PFNGLGETCOMPRESSEDMULTITEXIMAGEEXTPROC GetCompressedMultiTexImageEXT;
    // PFNGLMATRIXLOADTRANSPOSEFEXTPROC MatrixLoadTransposefEXT;
    // PFNGLMATRIXLOADTRANSPOSEDEXTPROC MatrixLoadTransposedEXT;
    // PFNGLMATRIXMULTTRANSPOSEFEXTPROC MatrixMultTransposefEXT;
    // PFNGLMATRIXMULTTRANSPOSEDEXTPROC MatrixMultTransposedEXT;
    // PFNGLNAMEDBUFFERDATAEXTPROC NamedBufferDataEXT;
    // PFNGLNAMEDBUFFERSUBDATAEXTPROC NamedBufferSubDataEXT;
    // PFNGLMAPNAMEDBUFFEREXTPROC MapNamedBufferEXT;
    // PFNGLUNMAPNAMEDBUFFEREXTPROC UnmapNamedBufferEXT;
    // PFNGLGETNAMEDBUFFERPARAMETERIVEXTPROC GetNamedBufferParameterivEXT;
    // PFNGLGETNAMEDBUFFERPOINTERVEXTPROC GetNamedBufferPointervEXT;
    // PFNGLGETNAMEDBUFFERSUBDATAEXTPROC GetNamedBufferSubDataEXT;
    // PFNGLPROGRAMUNIFORM1FEXTPROC ProgramUniform1fEXT;
    // PFNGLPROGRAMUNIFORM2FEXTPROC ProgramUniform2fEXT;
    // PFNGLPROGRAMUNIFORM3FEXTPROC ProgramUniform3fEXT;
    // PFNGLPROGRAMUNIFORM4FEXTPROC ProgramUniform4fEXT;
    // PFNGLPROGRAMUNIFORM1IEXTPROC ProgramUniform1iEXT;
    // PFNGLPROGRAMUNIFORM2IEXTPROC ProgramUniform2iEXT;
    // PFNGLPROGRAMUNIFORM3IEXTPROC ProgramUniform3iEXT;
    // PFNGLPROGRAMUNIFORM4IEXTPROC ProgramUniform4iEXT;
    // PFNGLPROGRAMUNIFORM1FVEXTPROC ProgramUniform1fvEXT;
    // PFNGLPROGRAMUNIFORM2FVEXTPROC ProgramUniform2fvEXT;
    // PFNGLPROGRAMUNIFORM3FVEXTPROC ProgramUniform3fvEXT;
    // PFNGLPROGRAMUNIFORM4FVEXTPROC ProgramUniform4fvEXT;
    // PFNGLPROGRAMUNIFORM1IVEXTPROC ProgramUniform1ivEXT;
    // PFNGLPROGRAMUNIFORM2IVEXTPROC ProgramUniform2ivEXT;
    // PFNGLPROGRAMUNIFORM3IVEXTPROC ProgramUniform3ivEXT;
    // PFNGLPROGRAMUNIFORM4IVEXTPROC ProgramUniform4ivEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2FVEXTPROC ProgramUniformMatrix2fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3FVEXTPROC ProgramUniformMatrix3fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4FVEXTPROC ProgramUniformMatrix4fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2X3FVEXTPROC ProgramUniformMatrix2x3fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3X2FVEXTPROC ProgramUniformMatrix3x2fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2X4FVEXTPROC ProgramUniformMatrix2x4fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4X2FVEXTPROC ProgramUniformMatrix4x2fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3X4FVEXTPROC ProgramUniformMatrix3x4fvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4X3FVEXTPROC ProgramUniformMatrix4x3fvEXT;
    // PFNGLTEXTUREBUFFEREXTPROC TextureBufferEXT;
    // PFNGLMULTITEXBUFFEREXTPROC MultiTexBufferEXT;
    // PFNGLTEXTUREPARAMETERIIVEXTPROC TextureParameterIivEXT;
    // PFNGLTEXTUREPARAMETERIUIVEXTPROC TextureParameterIuivEXT;
    // PFNGLGETTEXTUREPARAMETERIIVEXTPROC GetTextureParameterIivEXT;
    // PFNGLGETTEXTUREPARAMETERIUIVEXTPROC GetTextureParameterIuivEXT;
    // PFNGLMULTITEXPARAMETERIIVEXTPROC MultiTexParameterIivEXT;
    // PFNGLMULTITEXPARAMETERIUIVEXTPROC MultiTexParameterIuivEXT;
    // PFNGLGETMULTITEXPARAMETERIIVEXTPROC GetMultiTexParameterIivEXT;
    // PFNGLGETMULTITEXPARAMETERIUIVEXTPROC GetMultiTexParameterIuivEXT;
    // PFNGLPROGRAMUNIFORM1UIEXTPROC ProgramUniform1uiEXT;
    // PFNGLPROGRAMUNIFORM2UIEXTPROC ProgramUniform2uiEXT;
    // PFNGLPROGRAMUNIFORM3UIEXTPROC ProgramUniform3uiEXT;
    // PFNGLPROGRAMUNIFORM4UIEXTPROC ProgramUniform4uiEXT;
    // PFNGLPROGRAMUNIFORM1UIVEXTPROC ProgramUniform1uivEXT;
    // PFNGLPROGRAMUNIFORM2UIVEXTPROC ProgramUniform2uivEXT;
    // PFNGLPROGRAMUNIFORM3UIVEXTPROC ProgramUniform3uivEXT;
    // PFNGLPROGRAMUNIFORM4UIVEXTPROC ProgramUniform4uivEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERS4FVEXTPROC NamedProgramLocalParameters4fvEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERI4IEXTPROC NamedProgramLocalParameterI4iEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERI4IVEXTPROC NamedProgramLocalParameterI4ivEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERSI4IVEXTPROC NamedProgramLocalParametersI4ivEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIEXTPROC NamedProgramLocalParameterI4uiEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERI4UIVEXTPROC NamedProgramLocalParameterI4uivEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETERSI4UIVEXTPROC NamedProgramLocalParametersI4uivEXT;
    // PFNGLGETNAMEDPROGRAMLOCALPARAMETERIIVEXTPROC GetNamedProgramLocalParameterIivEXT;
    // PFNGLGETNAMEDPROGRAMLOCALPARAMETERIUIVEXTPROC GetNamedProgramLocalParameterIuivEXT;
    // PFNGLENABLECLIENTSTATEIEXTPROC EnableClientStateiEXT;
    // PFNGLDISABLECLIENTSTATEIEXTPROC DisableClientStateiEXT;
    // PFNGLGETFLOATI_VEXTPROC GetFloati_vEXT;
    // PFNGLGETDOUBLEI_VEXTPROC GetDoublei_vEXT;
    // PFNGLGETPOINTERI_VEXTPROC GetPointeri_vEXT;
    // PFNGLNAMEDPROGRAMSTRINGEXTPROC NamedProgramStringEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETER4DEXTPROC NamedProgramLocalParameter4dEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETER4DVEXTPROC NamedProgramLocalParameter4dvEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETER4FEXTPROC NamedProgramLocalParameter4fEXT;
    // PFNGLNAMEDPROGRAMLOCALPARAMETER4FVEXTPROC NamedProgramLocalParameter4fvEXT;
    // PFNGLGETNAMEDPROGRAMLOCALPARAMETERDVEXTPROC GetNamedProgramLocalParameterdvEXT;
    // PFNGLGETNAMEDPROGRAMLOCALPARAMETERFVEXTPROC GetNamedProgramLocalParameterfvEXT;
    // PFNGLGETNAMEDPROGRAMIVEXTPROC GetNamedProgramivEXT;
    // PFNGLGETNAMEDPROGRAMSTRINGEXTPROC GetNamedProgramStringEXT;
    // PFNGLNAMEDRENDERBUFFERSTORAGEEXTPROC NamedRenderbufferStorageEXT;
    // PFNGLGETNAMEDRENDERBUFFERPARAMETERIVEXTPROC GetNamedRenderbufferParameterivEXT;
    // PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLEEXTPROC NamedRenderbufferStorageMultisampleEXT;
    // PFNGLNAMEDRENDERBUFFERSTORAGEMULTISAMPLECOVERAGEEXTPROC NamedRenderbufferStorageMultisampleCoverageEXT;
    // PFNGLCHECKNAMEDFRAMEBUFFERSTATUSEXTPROC CheckNamedFramebufferStatusEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTURE1DEXTPROC NamedFramebufferTexture1DEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTURE2DEXTPROC NamedFramebufferTexture2DEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTURE3DEXTPROC NamedFramebufferTexture3DEXT;
    // PFNGLNAMEDFRAMEBUFFERRENDERBUFFEREXTPROC NamedFramebufferRenderbufferEXT;
    // PFNGLGETNAMEDFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC GetNamedFramebufferAttachmentParameterivEXT;
    // PFNGLGENERATETEXTUREMIPMAPEXTPROC GenerateTextureMipmapEXT;
    // PFNGLGENERATEMULTITEXMIPMAPEXTPROC GenerateMultiTexMipmapEXT;
    // PFNGLFRAMEBUFFERDRAWBUFFEREXTPROC FramebufferDrawBufferEXT;
    // PFNGLFRAMEBUFFERDRAWBUFFERSEXTPROC FramebufferDrawBuffersEXT;
    // PFNGLFRAMEBUFFERREADBUFFEREXTPROC FramebufferReadBufferEXT;
    // PFNGLGETFRAMEBUFFERPARAMETERIVEXTPROC GetFramebufferParameterivEXT;
    // PFNGLNAMEDCOPYBUFFERSUBDATAEXTPROC NamedCopyBufferSubDataEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTUREEXTPROC NamedFramebufferTextureEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTURELAYEREXTPROC NamedFramebufferTextureLayerEXT;
    // PFNGLNAMEDFRAMEBUFFERTEXTUREFACEEXTPROC NamedFramebufferTextureFaceEXT;
    // PFNGLTEXTURERENDERBUFFEREXTPROC TextureRenderbufferEXT;
    // PFNGLMULTITEXRENDERBUFFEREXTPROC MultiTexRenderbufferEXT;
    // PFNGLVERTEXARRAYVERTEXOFFSETEXTPROC VertexArrayVertexOffsetEXT;
    // PFNGLVERTEXARRAYCOLOROFFSETEXTPROC VertexArrayColorOffsetEXT;
    // PFNGLVERTEXARRAYEDGEFLAGOFFSETEXTPROC VertexArrayEdgeFlagOffsetEXT;
    // PFNGLVERTEXARRAYINDEXOFFSETEXTPROC VertexArrayIndexOffsetEXT;
    // PFNGLVERTEXARRAYNORMALOFFSETEXTPROC VertexArrayNormalOffsetEXT;
    // PFNGLVERTEXARRAYTEXCOORDOFFSETEXTPROC VertexArrayTexCoordOffsetEXT;
    // PFNGLVERTEXARRAYMULTITEXCOORDOFFSETEXTPROC VertexArrayMultiTexCoordOffsetEXT;
    // PFNGLVERTEXARRAYFOGCOORDOFFSETEXTPROC VertexArrayFogCoordOffsetEXT;
    // PFNGLVERTEXARRAYSECONDARYCOLOROFFSETEXTPROC VertexArraySecondaryColorOffsetEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBOFFSETEXTPROC VertexArrayVertexAttribOffsetEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBIOFFSETEXTPROC VertexArrayVertexAttribIOffsetEXT;
    // PFNGLENABLEVERTEXARRAYEXTPROC EnableVertexArrayEXT;
    // PFNGLDISABLEVERTEXARRAYEXTPROC DisableVertexArrayEXT;
    // PFNGLENABLEVERTEXARRAYATTRIBEXTPROC EnableVertexArrayAttribEXT;
    // PFNGLDISABLEVERTEXARRAYATTRIBEXTPROC DisableVertexArrayAttribEXT;
    // PFNGLGETVERTEXARRAYINTEGERVEXTPROC GetVertexArrayIntegervEXT;
    // PFNGLGETVERTEXARRAYPOINTERVEXTPROC GetVertexArrayPointervEXT;
    // PFNGLGETVERTEXARRAYINTEGERI_VEXTPROC GetVertexArrayIntegeri_vEXT;
    // PFNGLGETVERTEXARRAYPOINTERI_VEXTPROC GetVertexArrayPointeri_vEXT;
    // PFNGLMAPNAMEDBUFFERRANGEEXTPROC MapNamedBufferRangeEXT;
    // PFNGLFLUSHMAPPEDNAMEDBUFFERRANGEEXTPROC FlushMappedNamedBufferRangeEXT;
    // PFNGLNAMEDBUFFERSTORAGEEXTPROC NamedBufferStorageEXT;
    // PFNGLCLEARNAMEDBUFFERDATAEXTPROC ClearNamedBufferDataEXT;
    // PFNGLCLEARNAMEDBUFFERSUBDATAEXTPROC ClearNamedBufferSubDataEXT;
    // PFNGLNAMEDFRAMEBUFFERPARAMETERIEXTPROC NamedFramebufferParameteriEXT;
    // PFNGLGETNAMEDFRAMEBUFFERPARAMETERIVEXTPROC GetNamedFramebufferParameterivEXT;
    // PFNGLPROGRAMUNIFORM1DEXTPROC ProgramUniform1dEXT;
    // PFNGLPROGRAMUNIFORM2DEXTPROC ProgramUniform2dEXT;
    // PFNGLPROGRAMUNIFORM3DEXTPROC ProgramUniform3dEXT;
    // PFNGLPROGRAMUNIFORM4DEXTPROC ProgramUniform4dEXT;
    // PFNGLPROGRAMUNIFORM1DVEXTPROC ProgramUniform1dvEXT;
    // PFNGLPROGRAMUNIFORM2DVEXTPROC ProgramUniform2dvEXT;
    // PFNGLPROGRAMUNIFORM3DVEXTPROC ProgramUniform3dvEXT;
    // PFNGLPROGRAMUNIFORM4DVEXTPROC ProgramUniform4dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2DVEXTPROC ProgramUniformMatrix2dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3DVEXTPROC ProgramUniformMatrix3dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4DVEXTPROC ProgramUniformMatrix4dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2X3DVEXTPROC ProgramUniformMatrix2x3dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX2X4DVEXTPROC ProgramUniformMatrix2x4dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3X2DVEXTPROC ProgramUniformMatrix3x2dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX3X4DVEXTPROC ProgramUniformMatrix3x4dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4X2DVEXTPROC ProgramUniformMatrix4x2dvEXT;
    // PFNGLPROGRAMUNIFORMMATRIX4X3DVEXTPROC ProgramUniformMatrix4x3dvEXT;
    // PFNGLTEXTUREBUFFERRANGEEXTPROC TextureBufferRangeEXT;
    // PFNGLTEXTURESTORAGE1DEXTPROC TextureStorage1DEXT;
    // PFNGLTEXTURESTORAGE2DEXTPROC TextureStorage2DEXT;
    // PFNGLTEXTURESTORAGE3DEXTPROC TextureStorage3DEXT;
    // PFNGLTEXTURESTORAGE2DMULTISAMPLEEXTPROC TextureStorage2DMultisampleEXT;
    // PFNGLTEXTURESTORAGE3DMULTISAMPLEEXTPROC TextureStorage3DMultisampleEXT;
    // PFNGLVERTEXARRAYBINDVERTEXBUFFEREXTPROC VertexArrayBindVertexBufferEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBFORMATEXTPROC VertexArrayVertexAttribFormatEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBIFORMATEXTPROC VertexArrayVertexAttribIFormatEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBLFORMATEXTPROC VertexArrayVertexAttribLFormatEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBBINDINGEXTPROC VertexArrayVertexAttribBindingEXT;
    // PFNGLVERTEXARRAYVERTEXBINDINGDIVISOREXTPROC VertexArrayVertexBindingDivisorEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBLOFFSETEXTPROC VertexArrayVertexAttribLOffsetEXT;
    // PFNGLTEXTUREPAGECOMMITMENTEXTPROC TexturePageCommitmentEXT;
    // PFNGLVERTEXARRAYVERTEXATTRIBDIVISOREXTPROC VertexArrayVertexAttribDivisorEXT;
    // PFNGLDRAWARRAYSINSTANCEDEXTPROC DrawArraysInstancedEXT;
    // PFNGLDRAWELEMENTSINSTANCEDEXTPROC DrawElementsInstancedEXT;
    // PFNGLPOLYGONOFFSETCLAMPEXTPROC PolygonOffsetClampEXT;
    // PFNGLRASTERSAMPLESEXTPROC RasterSamplesEXT;
    // PFNGLUSESHADERPROGRAMEXTPROC UseShaderProgramEXT;
    // PFNGLACTIVEPROGRAMEXTPROC ActiveProgramEXT;
    // PFNGLCREATESHADERPROGRAMEXTPROC CreateShaderProgramEXT;
    // PFNGLFRAMEBUFFERFETCHBARRIEREXTPROC FramebufferFetchBarrierEXT;
    // PFNGLTEXSTORAGE1DEXTPROC TexStorage1DEXT;
    // PFNGLTEXSTORAGE2DEXTPROC TexStorage2DEXT;
    // PFNGLTEXSTORAGE3DEXTPROC TexStorage3DEXT;
    // PFNGLWINDOWRECTANGLESEXTPROC WindowRectanglesEXT;
    // PFNGLAPPLYFRAMEBUFFERATTACHMENTCMAAINTELPROC ApplyFramebufferAttachmentCMAAINTEL;
    // PFNGLBEGINPERFQUERYINTELPROC BeginPerfQueryINTEL;
    // PFNGLCREATEPERFQUERYINTELPROC CreatePerfQueryINTEL;
    // PFNGLDELETEPERFQUERYINTELPROC DeletePerfQueryINTEL;
    // PFNGLENDPERFQUERYINTELPROC EndPerfQueryINTEL;
    // PFNGLGETFIRSTPERFQUERYIDINTELPROC GetFirstPerfQueryIdINTEL;
    // PFNGLGETNEXTPERFQUERYIDINTELPROC GetNextPerfQueryIdINTEL;
    // PFNGLGETPERFCOUNTERINFOINTELPROC GetPerfCounterInfoINTEL;
    // PFNGLGETPERFQUERYDATAINTELPROC GetPerfQueryDataINTEL;
    // PFNGLGETPERFQUERYIDBYNAMEINTELPROC GetPerfQueryIdByNameINTEL;
    // PFNGLGETPERFQUERYINFOINTELPROC GetPerfQueryInfoINTEL;
    // PFNGLFRAMEBUFFERPARAMETERIMESAPROC FramebufferParameteriMESA;
    // PFNGLGETFRAMEBUFFERPARAMETERIVMESAPROC GetFramebufferParameterivMESA;
    // PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSNVPROC MultiDrawArraysIndirectBindlessNV;
    // PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSNVPROC MultiDrawElementsIndirectBindlessNV;
    // PFNGLMULTIDRAWARRAYSINDIRECTBINDLESSCOUNTNVPROC MultiDrawArraysIndirectBindlessCountNV;
    // PFNGLMULTIDRAWELEMENTSINDIRECTBINDLESSCOUNTNVPROC MultiDrawElementsIndirectBindlessCountNV;
    // PFNGLGETTEXTUREHANDLENVPROC GetTextureHandleNV;
    // PFNGLGETTEXTURESAMPLERHANDLENVPROC GetTextureSamplerHandleNV;
    // PFNGLMAKETEXTUREHANDLERESIDENTNVPROC MakeTextureHandleResidentNV;
    // PFNGLMAKETEXTUREHANDLENONRESIDENTNVPROC MakeTextureHandleNonResidentNV;
    // PFNGLGETIMAGEHANDLENVPROC GetImageHandleNV;
    // PFNGLMAKEIMAGEHANDLERESIDENTNVPROC MakeImageHandleResidentNV;
    // PFNGLMAKEIMAGEHANDLENONRESIDENTNVPROC MakeImageHandleNonResidentNV;
    // PFNGLUNIFORMHANDLEUI64NVPROC UniformHandleui64NV;
    // PFNGLUNIFORMHANDLEUI64VNVPROC UniformHandleui64vNV;
    // PFNGLPROGRAMUNIFORMHANDLEUI64NVPROC ProgramUniformHandleui64NV;
    // PFNGLPROGRAMUNIFORMHANDLEUI64VNVPROC ProgramUniformHandleui64vNV;
    // PFNGLISTEXTUREHANDLERESIDENTNVPROC IsTextureHandleResidentNV;
    // PFNGLISIMAGEHANDLERESIDENTNVPROC IsImageHandleResidentNV;
    // PFNGLBLENDPARAMETERINVPROC BlendParameteriNV;
    // PFNGLBLENDBARRIERNVPROC BlendBarrierNV;
    // PFNGLVIEWPORTPOSITIONWSCALENVPROC ViewportPositionWScaleNV;
    // PFNGLCREATESTATESNVPROC CreateStatesNV;
    // PFNGLDELETESTATESNVPROC DeleteStatesNV;
    // PFNGLISSTATENVPROC IsStateNV;
    // PFNGLSTATECAPTURENVPROC StateCaptureNV;
    // PFNGLGETCOMMANDHEADERNVPROC GetCommandHeaderNV;
    // PFNGLGETSTAGEINDEXNVPROC GetStageIndexNV;
    // PFNGLDRAWCOMMANDSNVPROC DrawCommandsNV;
    // PFNGLDRAWCOMMANDSADDRESSNVPROC DrawCommandsAddressNV;
    // PFNGLDRAWCOMMANDSSTATESNVPROC DrawCommandsStatesNV;
    // PFNGLDRAWCOMMANDSSTATESADDRESSNVPROC DrawCommandsStatesAddressNV;
    // PFNGLCREATECOMMANDLISTSNVPROC CreateCommandListsNV;
    // PFNGLDELETECOMMANDLISTSNVPROC DeleteCommandListsNV;
    // PFNGLISCOMMANDLISTNVPROC IsCommandListNV;
    // PFNGLLISTDRAWCOMMANDSSTATESCLIENTNVPROC ListDrawCommandsStatesClientNV;
    // PFNGLCOMMANDLISTSEGMENTSNVPROC CommandListSegmentsNV;
    // PFNGLCOMPILECOMMANDLISTNVPROC CompileCommandListNV;
    // PFNGLCALLCOMMANDLISTNVPROC CallCommandListNV;
    // PFNGLBEGINCONDITIONALRENDERNVPROC BeginConditionalRenderNV;
    // PFNGLENDCONDITIONALRENDERNVPROC EndConditionalRenderNV;
    // PFNGLSUBPIXELPRECISIONBIASNVPROC SubpixelPrecisionBiasNV;
    // PFNGLCONSERVATIVERASTERPARAMETERFNVPROC ConservativeRasterParameterfNV;
    // PFNGLCONSERVATIVERASTERPARAMETERINVPROC ConservativeRasterParameteriNV;
    // PFNGLDEPTHRANGEDNVPROC DepthRangedNV;
    // PFNGLCLEARDEPTHDNVPROC ClearDepthdNV;
    // PFNGLDEPTHBOUNDSDNVPROC DepthBoundsdNV;
    // PFNGLDRAWVKIMAGENVPROC DrawVkImageNV;
    // PFNGLGETVKPROCADDRNVPROC GetVkProcAddrNV;
    // PFNGLWAITVKSEMAPHORENVPROC WaitVkSemaphoreNV;
    // PFNGLSIGNALVKSEMAPHORENVPROC SignalVkSemaphoreNV;
    // PFNGLSIGNALVKFENCENVPROC SignalVkFenceNV;
    // PFNGLFRAGMENTCOVERAGECOLORNVPROC FragmentCoverageColorNV;
    // PFNGLCOVERAGEMODULATIONTABLENVPROC CoverageModulationTableNV;
    // PFNGLGETCOVERAGEMODULATIONTABLENVPROC GetCoverageModulationTableNV;
    // PFNGLCOVERAGEMODULATIONNVPROC CoverageModulationNV;
    // PFNGLRENDERBUFFERSTORAGEMULTISAMPLECOVERAGENVPROC RenderbufferStorageMultisampleCoverageNV;
    // PFNGLUNIFORM1I64NVPROC Uniform1i64NV;
    // PFNGLUNIFORM2I64NVPROC Uniform2i64NV;
    // PFNGLUNIFORM3I64NVPROC Uniform3i64NV;
    // PFNGLUNIFORM4I64NVPROC Uniform4i64NV;
    // PFNGLUNIFORM1I64VNVPROC Uniform1i64vNV;
    // PFNGLUNIFORM2I64VNVPROC Uniform2i64vNV;
    // PFNGLUNIFORM3I64VNVPROC Uniform3i64vNV;
    // PFNGLUNIFORM4I64VNVPROC Uniform4i64vNV;
    // PFNGLUNIFORM1UI64NVPROC Uniform1ui64NV;
    // PFNGLUNIFORM2UI64NVPROC Uniform2ui64NV;
    // PFNGLUNIFORM3UI64NVPROC Uniform3ui64NV;
    // PFNGLUNIFORM4UI64NVPROC Uniform4ui64NV;
    // PFNGLUNIFORM1UI64VNVPROC Uniform1ui64vNV;
    // PFNGLUNIFORM2UI64VNVPROC Uniform2ui64vNV;
    // PFNGLUNIFORM3UI64VNVPROC Uniform3ui64vNV;
    // PFNGLUNIFORM4UI64VNVPROC Uniform4ui64vNV;
    // PFNGLGETUNIFORMI64VNVPROC GetUniformi64vNV;
    // PFNGLPROGRAMUNIFORM1I64NVPROC ProgramUniform1i64NV;
    // PFNGLPROGRAMUNIFORM2I64NVPROC ProgramUniform2i64NV;
    // PFNGLPROGRAMUNIFORM3I64NVPROC ProgramUniform3i64NV;
    // PFNGLPROGRAMUNIFORM4I64NVPROC ProgramUniform4i64NV;
    // PFNGLPROGRAMUNIFORM1I64VNVPROC ProgramUniform1i64vNV;
    // PFNGLPROGRAMUNIFORM2I64VNVPROC ProgramUniform2i64vNV;
    // PFNGLPROGRAMUNIFORM3I64VNVPROC ProgramUniform3i64vNV;
    // PFNGLPROGRAMUNIFORM4I64VNVPROC ProgramUniform4i64vNV;
    // PFNGLPROGRAMUNIFORM1UI64NVPROC ProgramUniform1ui64NV;
    // PFNGLPROGRAMUNIFORM2UI64NVPROC ProgramUniform2ui64NV;
    // PFNGLPROGRAMUNIFORM3UI64NVPROC ProgramUniform3ui64NV;
    // PFNGLPROGRAMUNIFORM4UI64NVPROC ProgramUniform4ui64NV;
    // PFNGLPROGRAMUNIFORM1UI64VNVPROC ProgramUniform1ui64vNV;
    // PFNGLPROGRAMUNIFORM2UI64VNVPROC ProgramUniform2ui64vNV;
    // PFNGLPROGRAMUNIFORM3UI64VNVPROC ProgramUniform3ui64vNV;
    // PFNGLPROGRAMUNIFORM4UI64VNVPROC ProgramUniform4ui64vNV;
    // PFNGLGETINTERNALFORMATSAMPLEIVNVPROC GetInternalformatSampleivNV;
    // PFNGLGETMEMORYOBJECTDETACHEDRESOURCESUIVNVPROC GetMemoryObjectDetachedResourcesuivNV;
    // PFNGLRESETMEMORYOBJECTPARAMETERNVPROC ResetMemoryObjectParameterNV;
    // PFNGLTEXATTACHMEMORYNVPROC TexAttachMemoryNV;
    // PFNGLBUFFERATTACHMEMORYNVPROC BufferAttachMemoryNV;
    // PFNGLTEXTUREATTACHMEMORYNVPROC TextureAttachMemoryNV;
    // PFNGLNAMEDBUFFERATTACHMEMORYNVPROC NamedBufferAttachMemoryNV;
    // PFNGLBUFFERPAGECOMMITMENTMEMNVPROC BufferPageCommitmentMemNV;
    // PFNGLTEXPAGECOMMITMENTMEMNVPROC TexPageCommitmentMemNV;
    // PFNGLNAMEDBUFFERPAGECOMMITMENTMEMNVPROC NamedBufferPageCommitmentMemNV;
    // PFNGLTEXTUREPAGECOMMITMENTMEMNVPROC TexturePageCommitmentMemNV;
    // PFNGLDRAWMESHTASKSNVPROC DrawMeshTasksNV;
    // PFNGLDRAWMESHTASKSINDIRECTNVPROC DrawMeshTasksIndirectNV;
    // PFNGLMULTIDRAWMESHTASKSINDIRECTNVPROC MultiDrawMeshTasksIndirectNV;
    // PFNGLMULTIDRAWMESHTASKSINDIRECTCOUNTNVPROC MultiDrawMeshTasksIndirectCountNV;
    // PFNGLGENPATHSNVPROC GenPathsNV;
    // PFNGLDELETEPATHSNVPROC DeletePathsNV;
    // PFNGLISPATHNVPROC IsPathNV;
    // PFNGLPATHCOMMANDSNVPROC PathCommandsNV;
    // PFNGLPATHCOORDSNVPROC PathCoordsNV;
    // PFNGLPATHSUBCOMMANDSNVPROC PathSubCommandsNV;
    // PFNGLPATHSUBCOORDSNVPROC PathSubCoordsNV;
    // PFNGLPATHSTRINGNVPROC PathStringNV;
    // PFNGLPATHGLYPHSNVPROC PathGlyphsNV;
    // PFNGLPATHGLYPHRANGENVPROC PathGlyphRangeNV;
    // PFNGLWEIGHTPATHSNVPROC WeightPathsNV;
    // PFNGLCOPYPATHNVPROC CopyPathNV;
    // PFNGLINTERPOLATEPATHSNVPROC InterpolatePathsNV;
    // PFNGLTRANSFORMPATHNVPROC TransformPathNV;
    // PFNGLPATHPARAMETERIVNVPROC PathParameterivNV;
    // PFNGLPATHPARAMETERINVPROC PathParameteriNV;
    // PFNGLPATHPARAMETERFVNVPROC PathParameterfvNV;
    // PFNGLPATHPARAMETERFNVPROC PathParameterfNV;
    // PFNGLPATHDASHARRAYNVPROC PathDashArrayNV;
    // PFNGLPATHSTENCILFUNCNVPROC PathStencilFuncNV;
    // PFNGLPATHSTENCILDEPTHOFFSETNVPROC PathStencilDepthOffsetNV;
    // PFNGLSTENCILFILLPATHNVPROC StencilFillPathNV;
    // PFNGLSTENCILSTROKEPATHNVPROC StencilStrokePathNV;
    // PFNGLSTENCILFILLPATHINSTANCEDNVPROC StencilFillPathInstancedNV;
    // PFNGLSTENCILSTROKEPATHINSTANCEDNVPROC StencilStrokePathInstancedNV;
    // PFNGLPATHCOVERDEPTHFUNCNVPROC PathCoverDepthFuncNV;
    // PFNGLCOVERFILLPATHNVPROC CoverFillPathNV;
    // PFNGLCOVERSTROKEPATHNVPROC CoverStrokePathNV;
    // PFNGLCOVERFILLPATHINSTANCEDNVPROC CoverFillPathInstancedNV;
    // PFNGLCOVERSTROKEPATHINSTANCEDNVPROC CoverStrokePathInstancedNV;
    // PFNGLGETPATHPARAMETERIVNVPROC GetPathParameterivNV;
    // PFNGLGETPATHPARAMETERFVNVPROC GetPathParameterfvNV;
    // PFNGLGETPATHCOMMANDSNVPROC GetPathCommandsNV;
    // PFNGLGETPATHCOORDSNVPROC GetPathCoordsNV;
    // PFNGLGETPATHDASHARRAYNVPROC GetPathDashArrayNV;
    // PFNGLGETPATHMETRICSNVPROC GetPathMetricsNV;
    // PFNGLGETPATHMETRICRANGENVPROC GetPathMetricRangeNV;
    // PFNGLGETPATHSPACINGNVPROC GetPathSpacingNV;
    // PFNGLISPOINTINFILLPATHNVPROC IsPointInFillPathNV;
    // PFNGLISPOINTINSTROKEPATHNVPROC IsPointInStrokePathNV;
    // PFNGLGETPATHLENGTHNVPROC GetPathLengthNV;
    // PFNGLPOINTALONGPATHNVPROC PointAlongPathNV;
    // PFNGLMATRIXLOAD3X2FNVPROC MatrixLoad3x2fNV;
    // PFNGLMATRIXLOAD3X3FNVPROC MatrixLoad3x3fNV;
    // PFNGLMATRIXLOADTRANSPOSE3X3FNVPROC MatrixLoadTranspose3x3fNV;
    // PFNGLMATRIXMULT3X2FNVPROC MatrixMult3x2fNV;
    // PFNGLMATRIXMULT3X3FNVPROC MatrixMult3x3fNV;
    // PFNGLMATRIXMULTTRANSPOSE3X3FNVPROC MatrixMultTranspose3x3fNV;
    // PFNGLSTENCILTHENCOVERFILLPATHNVPROC StencilThenCoverFillPathNV;
    // PFNGLSTENCILTHENCOVERSTROKEPATHNVPROC StencilThenCoverStrokePathNV;
    // PFNGLSTENCILTHENCOVERFILLPATHINSTANCEDNVPROC StencilThenCoverFillPathInstancedNV;
    // PFNGLSTENCILTHENCOVERSTROKEPATHINSTANCEDNVPROC StencilThenCoverStrokePathInstancedNV;
    // PFNGLPATHGLYPHINDEXRANGENVPROC PathGlyphIndexRangeNV;
    // PFNGLPATHGLYPHINDEXARRAYNVPROC PathGlyphIndexArrayNV;
    // PFNGLPATHMEMORYGLYPHINDEXARRAYNVPROC PathMemoryGlyphIndexArrayNV;
    // PFNGLPROGRAMPATHFRAGMENTINPUTGENNVPROC ProgramPathFragmentInputGenNV;
    // PFNGLGETPROGRAMRESOURCEFVNVPROC GetProgramResourcefvNV;
    // PFNGLFRAMEBUFFERSAMPLELOCATIONSFVNVPROC FramebufferSampleLocationsfvNV;
    // PFNGLNAMEDFRAMEBUFFERSAMPLELOCATIONSFVNVPROC NamedFramebufferSampleLocationsfvNV;
    // PFNGLRESOLVEDEPTHVALUESNVPROC ResolveDepthValuesNV;
    // PFNGLSCISSOREXCLUSIVENVPROC ScissorExclusiveNV;
    // PFNGLSCISSOREXCLUSIVEARRAYVNVPROC ScissorExclusiveArrayvNV;
    // PFNGLMAKEBUFFERRESIDENTNVPROC MakeBufferResidentNV;
    // PFNGLMAKEBUFFERNONRESIDENTNVPROC MakeBufferNonResidentNV;
    // PFNGLISBUFFERRESIDENTNVPROC IsBufferResidentNV;
    // PFNGLMAKENAMEDBUFFERRESIDENTNVPROC MakeNamedBufferResidentNV;
    // PFNGLMAKENAMEDBUFFERNONRESIDENTNVPROC MakeNamedBufferNonResidentNV;
    // PFNGLISNAMEDBUFFERRESIDENTNVPROC IsNamedBufferResidentNV;
    // PFNGLGETBUFFERPARAMETERUI64VNVPROC GetBufferParameterui64vNV;
    // PFNGLGETNAMEDBUFFERPARAMETERUI64VNVPROC GetNamedBufferParameterui64vNV;
    // PFNGLGETINTEGERUI64VNVPROC GetIntegerui64vNV;
    // PFNGLUNIFORMUI64NVPROC Uniformui64NV;
    // PFNGLUNIFORMUI64VNVPROC Uniformui64vNV;
    // PFNGLGETUNIFORMUI64VNVPROC GetUniformui64vNV;
    // PFNGLPROGRAMUNIFORMUI64NVPROC ProgramUniformui64NV;
    // PFNGLPROGRAMUNIFORMUI64VNVPROC ProgramUniformui64vNV;
    // PFNGLBINDSHADINGRATEIMAGENVPROC BindShadingRateImageNV;
    // PFNGLGETSHADINGRATEIMAGEPALETTENVPROC GetShadingRateImagePaletteNV;
    // PFNGLGETSHADINGRATESAMPLELOCATIONIVNVPROC GetShadingRateSampleLocationivNV;
    // PFNGLSHADINGRATEIMAGEBARRIERNVPROC ShadingRateImageBarrierNV;
    // PFNGLSHADINGRATEIMAGEPALETTENVPROC ShadingRateImagePaletteNV;
    // PFNGLSHADINGRATESAMPLEORDERNVPROC ShadingRateSampleOrderNV;
    // PFNGLSHADINGRATESAMPLEORDERCUSTOMNVPROC ShadingRateSampleOrderCustomNV;
    // PFNGLTEXTUREBARRIERNVPROC TextureBarrierNV;
    // PFNGLVERTEXATTRIBL1I64NVPROC VertexAttribL1i64NV;
    // PFNGLVERTEXATTRIBL2I64NVPROC VertexAttribL2i64NV;
    // PFNGLVERTEXATTRIBL3I64NVPROC VertexAttribL3i64NV;
    // PFNGLVERTEXATTRIBL4I64NVPROC VertexAttribL4i64NV;
    // PFNGLVERTEXATTRIBL1I64VNVPROC VertexAttribL1i64vNV;
    // PFNGLVERTEXATTRIBL2I64VNVPROC VertexAttribL2i64vNV;
    // PFNGLVERTEXATTRIBL3I64VNVPROC VertexAttribL3i64vNV;
    // PFNGLVERTEXATTRIBL4I64VNVPROC VertexAttribL4i64vNV;
    // PFNGLVERTEXATTRIBL1UI64NVPROC VertexAttribL1ui64NV;
    // PFNGLVERTEXATTRIBL2UI64NVPROC VertexAttribL2ui64NV;
    // PFNGLVERTEXATTRIBL3UI64NVPROC VertexAttribL3ui64NV;
    // PFNGLVERTEXATTRIBL4UI64NVPROC VertexAttribL4ui64NV;
    // PFNGLVERTEXATTRIBL1UI64VNVPROC VertexAttribL1ui64vNV;
    // PFNGLVERTEXATTRIBL2UI64VNVPROC VertexAttribL2ui64vNV;
    // PFNGLVERTEXATTRIBL3UI64VNVPROC VertexAttribL3ui64vNV;
    // PFNGLVERTEXATTRIBL4UI64VNVPROC VertexAttribL4ui64vNV;
    // PFNGLGETVERTEXATTRIBLI64VNVPROC GetVertexAttribLi64vNV;
    // PFNGLGETVERTEXATTRIBLUI64VNVPROC GetVertexAttribLui64vNV;
    // PFNGLVERTEXATTRIBLFORMATNVPROC VertexAttribLFormatNV;
    // PFNGLBUFFERADDRESSRANGENVPROC BufferAddressRangeNV;
    // PFNGLVERTEXFORMATNVPROC VertexFormatNV;
    // PFNGLNORMALFORMATNVPROC NormalFormatNV;
    // PFNGLCOLORFORMATNVPROC ColorFormatNV;
    // PFNGLINDEXFORMATNVPROC IndexFormatNV;
    // PFNGLTEXCOORDFORMATNVPROC TexCoordFormatNV;
    // PFNGLEDGEFLAGFORMATNVPROC EdgeFlagFormatNV;
    // PFNGLSECONDARYCOLORFORMATNVPROC SecondaryColorFormatNV;
    // PFNGLFOGCOORDFORMATNVPROC FogCoordFormatNV;
    // PFNGLVERTEXATTRIBFORMATNVPROC VertexAttribFormatNV;
    // PFNGLVERTEXATTRIBIFORMATNVPROC VertexAttribIFormatNV;
    // PFNGLGETINTEGERUI64I_VNVPROC GetIntegerui64i_vNV;
    // PFNGLVIEWPORTSWIZZLENVPROC ViewportSwizzleNV;
    // PFNGLFRAMEBUFFERTEXTUREMULTIVIEWOVRPROC FramebufferTextureMultiviewOVR;
};

void * load_opengl_function(PyObject * loader, const char * method, const char * name) {
    if (PyErr_Occurred()) {
        return NULL;
    }

    PyObject * res = PyObject_CallMethod(loader, method, "s", name);
    if (!res) {
        return NULL;
    }
    return PyLong_AsVoidPtr(res);
}

GLMethods load_gl_methods(PyObject * loader) {
    GLMethods res = {};

    const char * method = PyObject_HasAttrString(loader, "load_opengl_function") ? "load_opengl_function" : "load";

    #define load(name) res.name = (decltype(res.name))load_opengl_function(loader, method, "gl" # name);

    load(CullFace);
    load(FrontFace);
    load(Hint);
    load(LineWidth);
    load(PointSize);
    load(PolygonMode);
    load(Scissor);
    load(TexParameterf);
    load(TexParameterfv);
    load(TexParameteri);
    load(TexParameteriv);
    load(TexImage1D);
    load(TexImage2D);
    load(DrawBuffer);
    load(Clear);
    load(ClearColor);
    load(ClearStencil);
    load(ClearDepth);
    load(StencilMask);
    load(ColorMask);
    load(DepthMask);
    load(Disable);
    load(Enable);
    load(Finish);
    load(Flush);
    load(BlendFunc);
    load(LogicOp);
    load(StencilFunc);
    load(StencilOp);
    load(DepthFunc);
    load(PixelStoref);
    load(PixelStorei);
    load(ReadBuffer);
    load(ReadPixels);
    load(GetBooleanv);
    load(GetDoublev);
    load(GetError);
    load(GetFloatv);
    load(GetIntegerv);
    load(GetString);
    load(GetTexImage);
    load(GetTexParameterfv);
    load(GetTexParameteriv);
    load(GetTexLevelParameterfv);
    load(GetTexLevelParameteriv);
    load(IsEnabled);
    load(DepthRange);
    load(Viewport);
    load(DrawArrays);
    load(DrawElements);
    load(GetPointerv);
    load(PolygonOffset);
    load(CopyTexImage1D);
    load(CopyTexImage2D);
    load(CopyTexSubImage1D);
    load(CopyTexSubImage2D);
    load(TexSubImage1D);
    load(TexSubImage2D);
    load(BindTexture);
    load(DeleteTextures);
    load(GenTextures);
    load(IsTexture);
    load(DrawRangeElements);
    load(TexImage3D);
    load(TexSubImage3D);
    load(CopyTexSubImage3D);
    load(ActiveTexture);
    load(SampleCoverage);
    load(CompressedTexImage3D);
    load(CompressedTexImage2D);
    load(CompressedTexImage1D);
    load(CompressedTexSubImage3D);
    load(CompressedTexSubImage2D);
    load(CompressedTexSubImage1D);
    load(GetCompressedTexImage);
    load(BlendFuncSeparate);
    load(MultiDrawArrays);
    load(MultiDrawElements);
    load(PointParameterf);
    load(PointParameterfv);
    load(PointParameteri);
    load(PointParameteriv);
    load(BlendColor);
    load(BlendEquation);
    load(GenQueries);
    load(DeleteQueries);
    load(IsQuery);
    load(BeginQuery);
    load(EndQuery);
    load(GetQueryiv);
    load(GetQueryObjectiv);
    load(GetQueryObjectuiv);
    load(BindBuffer);
    load(DeleteBuffers);
    load(GenBuffers);
    load(IsBuffer);
    load(BufferData);
    load(BufferSubData);
    load(GetBufferSubData);
    load(MapBuffer);
    load(UnmapBuffer);
    load(GetBufferParameteriv);
    load(GetBufferPointerv);
    load(BlendEquationSeparate);
    load(DrawBuffers);
    load(StencilOpSeparate);
    load(StencilFuncSeparate);
    load(StencilMaskSeparate);
    load(AttachShader);
    load(BindAttribLocation);
    load(CompileShader);
    load(CreateProgram);
    load(CreateShader);
    load(DeleteProgram);
    load(DeleteShader);
    load(DetachShader);
    load(DisableVertexAttribArray);
    load(EnableVertexAttribArray);
    load(GetActiveAttrib);
    load(GetActiveUniform);
    load(GetAttachedShaders);
    load(GetAttribLocation);
    load(GetProgramiv);
    load(GetProgramInfoLog);
    load(GetShaderiv);
    load(GetShaderInfoLog);
    load(GetShaderSource);
    load(GetUniformLocation);
    load(GetUniformfv);
    load(GetUniformiv);
    load(GetVertexAttribdv);
    load(GetVertexAttribfv);
    load(GetVertexAttribiv);
    load(GetVertexAttribPointerv);
    load(IsProgram);
    load(IsShader);
    load(LinkProgram);
    load(ShaderSource);
    load(UseProgram);
    load(Uniform1f);
    load(Uniform2f);
    load(Uniform3f);
    load(Uniform4f);
    load(Uniform1i);
    load(Uniform2i);
    load(Uniform3i);
    load(Uniform4i);
    load(Uniform1fv);
    load(Uniform2fv);
    load(Uniform3fv);
    load(Uniform4fv);
    load(Uniform1iv);
    load(Uniform2iv);
    load(Uniform3iv);
    load(Uniform4iv);
    load(UniformMatrix2fv);
    load(UniformMatrix3fv);
    load(UniformMatrix4fv);
    load(ValidateProgram);
    load(VertexAttrib1d);
    load(VertexAttrib1dv);
    load(VertexAttrib1f);
    load(VertexAttrib1fv);
    load(VertexAttrib1s);
    load(VertexAttrib1sv);
    load(VertexAttrib2d);
    load(VertexAttrib2dv);
    load(VertexAttrib2f);
    load(VertexAttrib2fv);
    load(VertexAttrib2s);
    load(VertexAttrib2sv);
    load(VertexAttrib3d);
    load(VertexAttrib3dv);
    load(VertexAttrib3f);
    load(VertexAttrib3fv);
    load(VertexAttrib3s);
    load(VertexAttrib3sv);
    load(VertexAttrib4Nbv);
    load(VertexAttrib4Niv);
    load(VertexAttrib4Nsv);
    load(VertexAttrib4Nub);
    load(VertexAttrib4Nubv);
    load(VertexAttrib4Nuiv);
    load(VertexAttrib4Nusv);
    load(VertexAttrib4bv);
    load(VertexAttrib4d);
    load(VertexAttrib4dv);
    load(VertexAttrib4f);
    load(VertexAttrib4fv);
    load(VertexAttrib4iv);
    load(VertexAttrib4s);
    load(VertexAttrib4sv);
    load(VertexAttrib4ubv);
    load(VertexAttrib4uiv);
    load(VertexAttrib4usv);
    load(VertexAttribPointer);
    load(UniformMatrix2x3fv);
    load(UniformMatrix3x2fv);
    load(UniformMatrix2x4fv);
    load(UniformMatrix4x2fv);
    load(UniformMatrix3x4fv);
    load(UniformMatrix4x3fv);
    load(ColorMaski);
    load(GetBooleani_v);
    load(GetIntegeri_v);
    load(Enablei);
    load(Disablei);
    load(IsEnabledi);
    load(BeginTransformFeedback);
    load(EndTransformFeedback);
    load(BindBufferRange);
    load(BindBufferBase);
    load(TransformFeedbackVaryings);
    load(GetTransformFeedbackVarying);
    load(ClampColor);
    load(BeginConditionalRender);
    load(EndConditionalRender);
    load(VertexAttribIPointer);
    load(GetVertexAttribIiv);
    load(GetVertexAttribIuiv);
    load(VertexAttribI1i);
    load(VertexAttribI2i);
    load(VertexAttribI3i);
    load(VertexAttribI4i);
    load(VertexAttribI1ui);
    load(VertexAttribI2ui);
    load(VertexAttribI3ui);
    load(VertexAttribI4ui);
    load(VertexAttribI1iv);
    load(VertexAttribI2iv);
    load(VertexAttribI3iv);
    load(VertexAttribI4iv);
    load(VertexAttribI1uiv);
    load(VertexAttribI2uiv);
    load(VertexAttribI3uiv);
    load(VertexAttribI4uiv);
    load(VertexAttribI4bv);
    load(VertexAttribI4sv);
    load(VertexAttribI4ubv);
    load(VertexAttribI4usv);
    load(GetUniformuiv);
    load(BindFragDataLocation);
    load(GetFragDataLocation);
    load(Uniform1ui);
    load(Uniform2ui);
    load(Uniform3ui);
    load(Uniform4ui);
    load(Uniform1uiv);
    load(Uniform2uiv);
    load(Uniform3uiv);
    load(Uniform4uiv);
    load(TexParameterIiv);
    load(TexParameterIuiv);
    load(GetTexParameterIiv);
    load(GetTexParameterIuiv);
    load(ClearBufferiv);
    load(ClearBufferuiv);
    load(ClearBufferfv);
    load(ClearBufferfi);
    load(GetStringi);
    load(IsRenderbuffer);
    load(BindRenderbuffer);
    load(DeleteRenderbuffers);
    load(GenRenderbuffers);
    load(RenderbufferStorage);
    load(GetRenderbufferParameteriv);
    load(IsFramebuffer);
    load(BindFramebuffer);
    load(DeleteFramebuffers);
    load(GenFramebuffers);
    load(CheckFramebufferStatus);
    load(FramebufferTexture1D);
    load(FramebufferTexture2D);
    load(FramebufferTexture3D);
    load(FramebufferRenderbuffer);
    load(GetFramebufferAttachmentParameteriv);
    load(GenerateMipmap);
    load(BlitFramebuffer);
    load(RenderbufferStorageMultisample);
    load(FramebufferTextureLayer);
    load(MapBufferRange);
    load(FlushMappedBufferRange);
    load(BindVertexArray);
    load(DeleteVertexArrays);
    load(GenVertexArrays);
    load(IsVertexArray);
    load(DrawArraysInstanced);
    load(DrawElementsInstanced);
    load(TexBuffer);
    load(PrimitiveRestartIndex);
    load(CopyBufferSubData);
    load(GetUniformIndices);
    load(GetActiveUniformsiv);
    load(GetActiveUniformName);
    load(GetUniformBlockIndex);
    load(GetActiveUniformBlockiv);
    load(GetActiveUniformBlockName);
    load(UniformBlockBinding);
    load(DrawElementsBaseVertex);
    load(DrawRangeElementsBaseVertex);
    load(DrawElementsInstancedBaseVertex);
    load(MultiDrawElementsBaseVertex);
    load(ProvokingVertex);
    load(FenceSync);
    load(IsSync);
    load(DeleteSync);
    load(ClientWaitSync);
    load(WaitSync);
    load(GetInteger64v);
    load(GetSynciv);
    load(GetInteger64i_v);
    load(GetBufferParameteri64v);
    load(FramebufferTexture);
    load(TexImage2DMultisample);
    load(TexImage3DMultisample);
    load(GetMultisamplefv);
    load(SampleMaski);
    load(BindFragDataLocationIndexed);
    load(GetFragDataIndex);
    load(GenSamplers);
    load(DeleteSamplers);
    load(IsSampler);
    load(BindSampler);
    load(SamplerParameteri);
    load(SamplerParameteriv);
    load(SamplerParameterf);
    load(SamplerParameterfv);
    load(SamplerParameterIiv);
    load(SamplerParameterIuiv);
    load(GetSamplerParameteriv);
    load(GetSamplerParameterIiv);
    load(GetSamplerParameterfv);
    load(GetSamplerParameterIuiv);
    load(QueryCounter);
    load(GetQueryObjecti64v);
    load(GetQueryObjectui64v);
    load(VertexAttribDivisor);
    load(VertexAttribP1ui);
    load(VertexAttribP1uiv);
    load(VertexAttribP2ui);
    load(VertexAttribP2uiv);
    load(VertexAttribP3ui);
    load(VertexAttribP3uiv);
    load(VertexAttribP4ui);
    load(VertexAttribP4uiv);
    load(MinSampleShading);
    load(BlendEquationi);
    load(BlendEquationSeparatei);
    load(BlendFunci);
    load(BlendFuncSeparatei);
    load(DrawArraysIndirect);
    load(DrawElementsIndirect);
    load(Uniform1d);
    load(Uniform2d);
    load(Uniform3d);
    load(Uniform4d);
    load(Uniform1dv);
    load(Uniform2dv);
    load(Uniform3dv);
    load(Uniform4dv);
    load(UniformMatrix2dv);
    load(UniformMatrix3dv);
    load(UniformMatrix4dv);
    load(UniformMatrix2x3dv);
    load(UniformMatrix2x4dv);
    load(UniformMatrix3x2dv);
    load(UniformMatrix3x4dv);
    load(UniformMatrix4x2dv);
    load(UniformMatrix4x3dv);
    load(GetUniformdv);
    load(GetSubroutineUniformLocation);
    load(GetSubroutineIndex);
    load(GetActiveSubroutineUniformiv);
    load(GetActiveSubroutineUniformName);
    load(GetActiveSubroutineName);
    load(UniformSubroutinesuiv);
    load(GetUniformSubroutineuiv);
    load(GetProgramStageiv);
    load(PatchParameteri);
    load(PatchParameterfv);
    load(BindTransformFeedback);
    load(DeleteTransformFeedbacks);
    load(GenTransformFeedbacks);
    load(IsTransformFeedback);
    load(PauseTransformFeedback);
    load(ResumeTransformFeedback);
    load(DrawTransformFeedback);
    load(DrawTransformFeedbackStream);
    load(BeginQueryIndexed);
    load(EndQueryIndexed);
    load(GetQueryIndexediv);
    load(ReleaseShaderCompiler);
    load(ShaderBinary);
    load(GetShaderPrecisionFormat);
    load(DepthRangef);
    load(ClearDepthf);
    load(GetProgramBinary);
    load(ProgramBinary);
    load(ProgramParameteri);
    load(UseProgramStages);
    load(ActiveShaderProgram);
    load(CreateShaderProgramv);
    load(BindProgramPipeline);
    load(DeleteProgramPipelines);
    load(GenProgramPipelines);
    load(IsProgramPipeline);
    load(GetProgramPipelineiv);
    load(ProgramUniform1i);
    load(ProgramUniform1iv);
    load(ProgramUniform1f);
    load(ProgramUniform1fv);
    load(ProgramUniform1d);
    load(ProgramUniform1dv);
    load(ProgramUniform1ui);
    load(ProgramUniform1uiv);
    load(ProgramUniform2i);
    load(ProgramUniform2iv);
    load(ProgramUniform2f);
    load(ProgramUniform2fv);
    load(ProgramUniform2d);
    load(ProgramUniform2dv);
    load(ProgramUniform2ui);
    load(ProgramUniform2uiv);
    load(ProgramUniform3i);
    load(ProgramUniform3iv);
    load(ProgramUniform3f);
    load(ProgramUniform3fv);
    load(ProgramUniform3d);
    load(ProgramUniform3dv);
    load(ProgramUniform3ui);
    load(ProgramUniform3uiv);
    load(ProgramUniform4i);
    load(ProgramUniform4iv);
    load(ProgramUniform4f);
    load(ProgramUniform4fv);
    load(ProgramUniform4d);
    load(ProgramUniform4dv);
    load(ProgramUniform4ui);
    load(ProgramUniform4uiv);
    load(ProgramUniformMatrix2fv);
    load(ProgramUniformMatrix3fv);
    load(ProgramUniformMatrix4fv);
    load(ProgramUniformMatrix2dv);
    load(ProgramUniformMatrix3dv);
    load(ProgramUniformMatrix4dv);
    load(ProgramUniformMatrix2x3fv);
    load(ProgramUniformMatrix3x2fv);
    load(ProgramUniformMatrix2x4fv);
    load(ProgramUniformMatrix4x2fv);
    load(ProgramUniformMatrix3x4fv);
    load(ProgramUniformMatrix4x3fv);
    load(ProgramUniformMatrix2x3dv);
    load(ProgramUniformMatrix3x2dv);
    load(ProgramUniformMatrix2x4dv);
    load(ProgramUniformMatrix4x2dv);
    load(ProgramUniformMatrix3x4dv);
    load(ProgramUniformMatrix4x3dv);
    load(ValidateProgramPipeline);
    load(GetProgramPipelineInfoLog);
    load(VertexAttribL1d);
    load(VertexAttribL2d);
    load(VertexAttribL3d);
    load(VertexAttribL4d);
    load(VertexAttribL1dv);
    load(VertexAttribL2dv);
    load(VertexAttribL3dv);
    load(VertexAttribL4dv);
    load(VertexAttribLPointer);
    load(GetVertexAttribLdv);
    load(ViewportArrayv);
    load(ViewportIndexedf);
    load(ViewportIndexedfv);
    load(ScissorArrayv);
    load(ScissorIndexed);
    load(ScissorIndexedv);
    load(DepthRangeArrayv);
    load(DepthRangeIndexed);
    load(GetFloati_v);
    load(GetDoublei_v);
    load(DrawArraysInstancedBaseInstance);
    load(DrawElementsInstancedBaseInstance);
    load(DrawElementsInstancedBaseVertexBaseInstance);
    load(GetInternalformativ);
    load(GetActiveAtomicCounterBufferiv);
    load(BindImageTexture);
    load(MemoryBarrier);
    load(TexStorage1D);
    load(TexStorage2D);
    load(TexStorage3D);
    load(DrawTransformFeedbackInstanced);
    load(DrawTransformFeedbackStreamInstanced);
    load(ClearBufferData);
    load(ClearBufferSubData);
    load(DispatchCompute);
    load(DispatchComputeIndirect);
    load(CopyImageSubData);
    load(FramebufferParameteri);
    load(GetFramebufferParameteriv);
    load(GetInternalformati64v);
    load(InvalidateTexSubImage);
    load(InvalidateTexImage);
    load(InvalidateBufferSubData);
    load(InvalidateBufferData);
    load(InvalidateFramebuffer);
    load(InvalidateSubFramebuffer);
    load(MultiDrawArraysIndirect);
    load(MultiDrawElementsIndirect);
    load(GetProgramInterfaceiv);
    load(GetProgramResourceIndex);
    load(GetProgramResourceName);
    load(GetProgramResourceiv);
    load(GetProgramResourceLocation);
    load(GetProgramResourceLocationIndex);
    load(ShaderStorageBlockBinding);
    load(TexBufferRange);
    load(TexStorage2DMultisample);
    load(TexStorage3DMultisample);
    load(TextureView);
    load(BindVertexBuffer);
    load(VertexAttribFormat);
    load(VertexAttribIFormat);
    load(VertexAttribLFormat);
    load(VertexAttribBinding);
    load(VertexBindingDivisor);
    load(DebugMessageControl);
    load(DebugMessageInsert);
    load(DebugMessageCallback);
    load(GetDebugMessageLog);
    load(PushDebugGroup);
    load(PopDebugGroup);
    load(ObjectLabel);
    load(GetObjectLabel);
    load(ObjectPtrLabel);
    load(GetObjectPtrLabel);
    load(BufferStorage);
    load(ClearTexImage);
    load(ClearTexSubImage);
    load(BindBuffersBase);
    load(BindBuffersRange);
    load(BindTextures);
    load(BindSamplers);
    load(BindImageTextures);
    load(BindVertexBuffers);
    load(ClipControl);
    load(CreateTransformFeedbacks);
    load(TransformFeedbackBufferBase);
    load(TransformFeedbackBufferRange);
    load(GetTransformFeedbackiv);
    load(GetTransformFeedbacki_v);
    load(GetTransformFeedbacki64_v);
    load(CreateBuffers);
    load(NamedBufferStorage);
    load(NamedBufferData);
    load(NamedBufferSubData);
    load(CopyNamedBufferSubData);
    load(ClearNamedBufferData);
    load(ClearNamedBufferSubData);
    load(MapNamedBuffer);
    load(MapNamedBufferRange);
    load(UnmapNamedBuffer);
    load(FlushMappedNamedBufferRange);
    load(GetNamedBufferParameteriv);
    load(GetNamedBufferParameteri64v);
    load(GetNamedBufferPointerv);
    load(GetNamedBufferSubData);
    load(CreateFramebuffers);
    load(NamedFramebufferRenderbuffer);
    load(NamedFramebufferParameteri);
    load(NamedFramebufferTexture);
    load(NamedFramebufferTextureLayer);
    load(NamedFramebufferDrawBuffer);
    load(NamedFramebufferDrawBuffers);
    load(NamedFramebufferReadBuffer);
    load(InvalidateNamedFramebufferData);
    load(InvalidateNamedFramebufferSubData);
    load(ClearNamedFramebufferiv);
    load(ClearNamedFramebufferuiv);
    load(ClearNamedFramebufferfv);
    load(ClearNamedFramebufferfi);
    load(BlitNamedFramebuffer);
    load(CheckNamedFramebufferStatus);
    load(GetNamedFramebufferParameteriv);
    load(GetNamedFramebufferAttachmentParameteriv);
    load(CreateRenderbuffers);
    load(NamedRenderbufferStorage);
    load(NamedRenderbufferStorageMultisample);
    load(GetNamedRenderbufferParameteriv);
    load(CreateTextures);
    load(TextureBuffer);
    load(TextureBufferRange);
    load(TextureStorage1D);
    load(TextureStorage2D);
    load(TextureStorage3D);
    load(TextureStorage2DMultisample);
    load(TextureStorage3DMultisample);
    load(TextureSubImage1D);
    load(TextureSubImage2D);
    load(TextureSubImage3D);
    load(CompressedTextureSubImage1D);
    load(CompressedTextureSubImage2D);
    load(CompressedTextureSubImage3D);
    load(CopyTextureSubImage1D);
    load(CopyTextureSubImage2D);
    load(CopyTextureSubImage3D);
    load(TextureParameterf);
    load(TextureParameterfv);
    load(TextureParameteri);
    load(TextureParameterIiv);
    load(TextureParameterIuiv);
    load(TextureParameteriv);
    load(GenerateTextureMipmap);
    load(BindTextureUnit);
    load(GetTextureImage);
    load(GetCompressedTextureImage);
    load(GetTextureLevelParameterfv);
    load(GetTextureLevelParameteriv);
    load(GetTextureParameterfv);
    load(GetTextureParameterIiv);
    load(GetTextureParameterIuiv);
    load(GetTextureParameteriv);
    load(CreateVertexArrays);
    load(DisableVertexArrayAttrib);
    load(EnableVertexArrayAttrib);
    load(VertexArrayElementBuffer);
    load(VertexArrayVertexBuffer);
    load(VertexArrayVertexBuffers);
    load(VertexArrayAttribBinding);
    load(VertexArrayAttribFormat);
    load(VertexArrayAttribIFormat);
    load(VertexArrayAttribLFormat);
    load(VertexArrayBindingDivisor);
    load(GetVertexArrayiv);
    load(GetVertexArrayIndexediv);
    load(GetVertexArrayIndexed64iv);
    load(CreateSamplers);
    load(CreateProgramPipelines);
    load(CreateQueries);
    load(GetQueryBufferObjecti64v);
    load(GetQueryBufferObjectiv);
    load(GetQueryBufferObjectui64v);
    load(GetQueryBufferObjectuiv);
    load(MemoryBarrierByRegion);
    load(GetTextureSubImage);
    load(GetCompressedTextureSubImage);
    load(GetGraphicsResetStatus);
    load(GetnCompressedTexImage);
    load(GetnTexImage);
    load(GetnUniformdv);
    load(GetnUniformfv);
    load(GetnUniformiv);
    load(GetnUniformuiv);
    load(ReadnPixels);
    load(TextureBarrier);
    load(SpecializeShader);
    load(MultiDrawArraysIndirectCount);
    load(MultiDrawElementsIndirectCount);
    load(PolygonOffsetClamp);
    // load(PrimitiveBoundingBoxARB);
    load(GetTextureHandleARB);
    // load(GetTextureSamplerHandleARB);
    load(MakeTextureHandleResidentARB);
    load(MakeTextureHandleNonResidentARB);
    // load(GetImageHandleARB);
    // load(MakeImageHandleResidentARB);
    // load(MakeImageHandleNonResidentARB);
    // load(UniformHandleui64ARB);
    // load(UniformHandleui64vARB);
    load(ProgramUniformHandleui64ARB);
    // load(ProgramUniformHandleui64vARB);
    // load(IsTextureHandleResidentARB);
    // load(IsImageHandleResidentARB);
    // load(VertexAttribL1ui64ARB);
    // load(VertexAttribL1ui64vARB);
    // load(GetVertexAttribLui64vARB);
    // load(CreateSyncFromCLeventARB);
    // load(DispatchComputeGroupSizeARB);
    // load(DebugMessageControlARB);
    // load(DebugMessageInsertARB);
    // load(DebugMessageCallbackARB);
    // load(GetDebugMessageLogARB);
    // load(BlendEquationiARB);
    // load(BlendEquationSeparateiARB);
    // load(BlendFunciARB);
    // load(BlendFuncSeparateiARB);
    // load(DrawArraysInstancedARB);
    // load(DrawElementsInstancedARB);
    // load(ProgramParameteriARB);
    // load(FramebufferTextureARB);
    // load(FramebufferTextureLayerARB);
    // load(FramebufferTextureFaceARB);
    // load(SpecializeShaderARB);
    // load(Uniform1i64ARB);
    // load(Uniform2i64ARB);
    // load(Uniform3i64ARB);
    // load(Uniform4i64ARB);
    // load(Uniform1i64vARB);
    // load(Uniform2i64vARB);
    // load(Uniform3i64vARB);
    // load(Uniform4i64vARB);
    // load(Uniform1ui64ARB);
    // load(Uniform2ui64ARB);
    // load(Uniform3ui64ARB);
    // load(Uniform4ui64ARB);
    // load(Uniform1ui64vARB);
    // load(Uniform2ui64vARB);
    // load(Uniform3ui64vARB);
    // load(Uniform4ui64vARB);
    // load(GetUniformi64vARB);
    // load(GetUniformui64vARB);
    // load(GetnUniformi64vARB);
    // load(GetnUniformui64vARB);
    // load(ProgramUniform1i64ARB);
    // load(ProgramUniform2i64ARB);
    // load(ProgramUniform3i64ARB);
    // load(ProgramUniform4i64ARB);
    // load(ProgramUniform1i64vARB);
    // load(ProgramUniform2i64vARB);
    // load(ProgramUniform3i64vARB);
    // load(ProgramUniform4i64vARB);
    // load(ProgramUniform1ui64ARB);
    // load(ProgramUniform2ui64ARB);
    // load(ProgramUniform3ui64ARB);
    // load(ProgramUniform4ui64ARB);
    // load(ProgramUniform1ui64vARB);
    // load(ProgramUniform2ui64vARB);
    // load(ProgramUniform3ui64vARB);
    // load(ProgramUniform4ui64vARB);
    // load(MultiDrawArraysIndirectCountARB);
    // load(MultiDrawElementsIndirectCountARB);
    // load(VertexAttribDivisorARB);
    // load(MaxShaderCompilerThreadsARB);
    // load(GetGraphicsResetStatusARB);
    // load(GetnTexImageARB);
    // load(ReadnPixelsARB);
    // load(GetnCompressedTexImageARB);
    // load(GetnUniformfvARB);
    // load(GetnUniformivARB);
    // load(GetnUniformuivARB);
    // load(GetnUniformdvARB);
    // load(FramebufferSampleLocationsfvARB);
    // load(NamedFramebufferSampleLocationsfvARB);
    // load(EvaluateDepthValuesARB);
    // load(MinSampleShadingARB);
    // load(NamedStringARB);
    // load(DeleteNamedStringARB);
    // load(CompileShaderIncludeARB);
    // load(IsNamedStringARB);
    // load(GetNamedStringARB);
    // load(GetNamedStringivARB);
    // load(BufferPageCommitmentARB);
    // load(NamedBufferPageCommitmentEXT);
    // load(NamedBufferPageCommitmentARB);
    // load(TexPageCommitmentARB);
    // load(TexBufferARB);
    // load(DepthRangeArraydvNV);
    // load(DepthRangeIndexeddNV);
    // load(BlendBarrierKHR);
    // load(MaxShaderCompilerThreadsKHR);
    // load(RenderbufferStorageMultisampleAdvancedAMD);
    // load(NamedRenderbufferStorageMultisampleAdvancedAMD);
    // load(GetPerfMonitorGroupsAMD);
    // load(GetPerfMonitorCountersAMD);
    // load(GetPerfMonitorGroupStringAMD);
    // load(GetPerfMonitorCounterStringAMD);
    // load(GetPerfMonitorCounterInfoAMD);
    // load(GenPerfMonitorsAMD);
    // load(DeletePerfMonitorsAMD);
    // load(SelectPerfMonitorCountersAMD);
    // load(BeginPerfMonitorAMD);
    // load(EndPerfMonitorAMD);
    // load(GetPerfMonitorCounterDataAMD);
    // load(EGLImageTargetTexStorageEXT);
    // load(EGLImageTargetTextureStorageEXT);
    // load(LabelObjectEXT);
    // load(GetObjectLabelEXT);
    // load(InsertEventMarkerEXT);
    // load(PushGroupMarkerEXT);
    // load(PopGroupMarkerEXT);
    // load(MatrixLoadfEXT);
    // load(MatrixLoaddEXT);
    // load(MatrixMultfEXT);
    // load(MatrixMultdEXT);
    // load(MatrixLoadIdentityEXT);
    // load(MatrixRotatefEXT);
    // load(MatrixRotatedEXT);
    // load(MatrixScalefEXT);
    // load(MatrixScaledEXT);
    // load(MatrixTranslatefEXT);
    // load(MatrixTranslatedEXT);
    // load(MatrixFrustumEXT);
    // load(MatrixOrthoEXT);
    // load(MatrixPopEXT);
    // load(MatrixPushEXT);
    // load(ClientAttribDefaultEXT);
    // load(PushClientAttribDefaultEXT);
    // load(TextureParameterfEXT);
    // load(TextureParameterfvEXT);
    // load(TextureParameteriEXT);
    // load(TextureParameterivEXT);
    // load(TextureImage1DEXT);
    // load(TextureImage2DEXT);
    // load(TextureSubImage1DEXT);
    // load(TextureSubImage2DEXT);
    // load(CopyTextureImage1DEXT);
    // load(CopyTextureImage2DEXT);
    // load(CopyTextureSubImage1DEXT);
    // load(CopyTextureSubImage2DEXT);
    // load(GetTextureImageEXT);
    // load(GetTextureParameterfvEXT);
    // load(GetTextureParameterivEXT);
    // load(GetTextureLevelParameterfvEXT);
    // load(GetTextureLevelParameterivEXT);
    // load(TextureImage3DEXT);
    // load(TextureSubImage3DEXT);
    // load(CopyTextureSubImage3DEXT);
    // load(BindMultiTextureEXT);
    // load(MultiTexCoordPointerEXT);
    // load(MultiTexEnvfEXT);
    // load(MultiTexEnvfvEXT);
    // load(MultiTexEnviEXT);
    // load(MultiTexEnvivEXT);
    // load(MultiTexGendEXT);
    // load(MultiTexGendvEXT);
    // load(MultiTexGenfEXT);
    // load(MultiTexGenfvEXT);
    // load(MultiTexGeniEXT);
    // load(MultiTexGenivEXT);
    // load(GetMultiTexEnvfvEXT);
    // load(GetMultiTexEnvivEXT);
    // load(GetMultiTexGendvEXT);
    // load(GetMultiTexGenfvEXT);
    // load(GetMultiTexGenivEXT);
    // load(MultiTexParameteriEXT);
    // load(MultiTexParameterivEXT);
    // load(MultiTexParameterfEXT);
    // load(MultiTexParameterfvEXT);
    // load(MultiTexImage1DEXT);
    // load(MultiTexImage2DEXT);
    // load(MultiTexSubImage1DEXT);
    // load(MultiTexSubImage2DEXT);
    // load(CopyMultiTexImage1DEXT);
    // load(CopyMultiTexImage2DEXT);
    // load(CopyMultiTexSubImage1DEXT);
    // load(CopyMultiTexSubImage2DEXT);
    // load(GetMultiTexImageEXT);
    // load(GetMultiTexParameterfvEXT);
    // load(GetMultiTexParameterivEXT);
    // load(GetMultiTexLevelParameterfvEXT);
    // load(GetMultiTexLevelParameterivEXT);
    // load(MultiTexImage3DEXT);
    // load(MultiTexSubImage3DEXT);
    // load(CopyMultiTexSubImage3DEXT);
    // load(EnableClientStateIndexedEXT);
    // load(DisableClientStateIndexedEXT);
    // load(GetFloatIndexedvEXT);
    // load(GetDoubleIndexedvEXT);
    // load(GetPointerIndexedvEXT);
    // load(EnableIndexedEXT);
    // load(DisableIndexedEXT);
    // load(IsEnabledIndexedEXT);
    // load(GetIntegerIndexedvEXT);
    // load(GetBooleanIndexedvEXT);
    // load(CompressedTextureImage3DEXT);
    // load(CompressedTextureImage2DEXT);
    // load(CompressedTextureImage1DEXT);
    // load(CompressedTextureSubImage3DEXT);
    // load(CompressedTextureSubImage2DEXT);
    // load(CompressedTextureSubImage1DEXT);
    // load(GetCompressedTextureImageEXT);
    // load(CompressedMultiTexImage3DEXT);
    // load(CompressedMultiTexImage2DEXT);
    // load(CompressedMultiTexImage1DEXT);
    // load(CompressedMultiTexSubImage3DEXT);
    // load(CompressedMultiTexSubImage2DEXT);
    // load(CompressedMultiTexSubImage1DEXT);
    // load(GetCompressedMultiTexImageEXT);
    // load(MatrixLoadTransposefEXT);
    // load(MatrixLoadTransposedEXT);
    // load(MatrixMultTransposefEXT);
    // load(MatrixMultTransposedEXT);
    // load(NamedBufferDataEXT);
    // load(NamedBufferSubDataEXT);
    // load(MapNamedBufferEXT);
    // load(UnmapNamedBufferEXT);
    // load(GetNamedBufferParameterivEXT);
    // load(GetNamedBufferPointervEXT);
    // load(GetNamedBufferSubDataEXT);
    // load(ProgramUniform1fEXT);
    // load(ProgramUniform2fEXT);
    // load(ProgramUniform3fEXT);
    // load(ProgramUniform4fEXT);
    // load(ProgramUniform1iEXT);
    // load(ProgramUniform2iEXT);
    // load(ProgramUniform3iEXT);
    // load(ProgramUniform4iEXT);
    // load(ProgramUniform1fvEXT);
    // load(ProgramUniform2fvEXT);
    // load(ProgramUniform3fvEXT);
    // load(ProgramUniform4fvEXT);
    // load(ProgramUniform1ivEXT);
    // load(ProgramUniform2ivEXT);
    // load(ProgramUniform3ivEXT);
    // load(ProgramUniform4ivEXT);
    // load(ProgramUniformMatrix2fvEXT);
    // load(ProgramUniformMatrix3fvEXT);
    // load(ProgramUniformMatrix4fvEXT);
    // load(ProgramUniformMatrix2x3fvEXT);
    // load(ProgramUniformMatrix3x2fvEXT);
    // load(ProgramUniformMatrix2x4fvEXT);
    // load(ProgramUniformMatrix4x2fvEXT);
    // load(ProgramUniformMatrix3x4fvEXT);
    // load(ProgramUniformMatrix4x3fvEXT);
    // load(TextureBufferEXT);
    // load(MultiTexBufferEXT);
    // load(TextureParameterIivEXT);
    // load(TextureParameterIuivEXT);
    // load(GetTextureParameterIivEXT);
    // load(GetTextureParameterIuivEXT);
    // load(MultiTexParameterIivEXT);
    // load(MultiTexParameterIuivEXT);
    // load(GetMultiTexParameterIivEXT);
    // load(GetMultiTexParameterIuivEXT);
    // load(ProgramUniform1uiEXT);
    // load(ProgramUniform2uiEXT);
    // load(ProgramUniform3uiEXT);
    // load(ProgramUniform4uiEXT);
    // load(ProgramUniform1uivEXT);
    // load(ProgramUniform2uivEXT);
    // load(ProgramUniform3uivEXT);
    // load(ProgramUniform4uivEXT);
    // load(NamedProgramLocalParameters4fvEXT);
    // load(NamedProgramLocalParameterI4iEXT);
    // load(NamedProgramLocalParameterI4ivEXT);
    // load(NamedProgramLocalParametersI4ivEXT);
    // load(NamedProgramLocalParameterI4uiEXT);
    // load(NamedProgramLocalParameterI4uivEXT);
    // load(NamedProgramLocalParametersI4uivEXT);
    // load(GetNamedProgramLocalParameterIivEXT);
    // load(GetNamedProgramLocalParameterIuivEXT);
    // load(EnableClientStateiEXT);
    // load(DisableClientStateiEXT);
    // load(GetFloati_vEXT);
    // load(GetDoublei_vEXT);
    // load(GetPointeri_vEXT);
    // load(NamedProgramStringEXT);
    // load(NamedProgramLocalParameter4dEXT);
    // load(NamedProgramLocalParameter4dvEXT);
    // load(NamedProgramLocalParameter4fEXT);
    // load(NamedProgramLocalParameter4fvEXT);
    // load(GetNamedProgramLocalParameterdvEXT);
    // load(GetNamedProgramLocalParameterfvEXT);
    // load(GetNamedProgramivEXT);
    // load(GetNamedProgramStringEXT);
    // load(NamedRenderbufferStorageEXT);
    // load(GetNamedRenderbufferParameterivEXT);
    // load(NamedRenderbufferStorageMultisampleEXT);
    // load(NamedRenderbufferStorageMultisampleCoverageEXT);
    // load(CheckNamedFramebufferStatusEXT);
    // load(NamedFramebufferTexture1DEXT);
    // load(NamedFramebufferTexture2DEXT);
    // load(NamedFramebufferTexture3DEXT);
    // load(NamedFramebufferRenderbufferEXT);
    // load(GetNamedFramebufferAttachmentParameterivEXT);
    // load(GenerateTextureMipmapEXT);
    // load(GenerateMultiTexMipmapEXT);
    // load(FramebufferDrawBufferEXT);
    // load(FramebufferDrawBuffersEXT);
    // load(FramebufferReadBufferEXT);
    // load(GetFramebufferParameterivEXT);
    // load(NamedCopyBufferSubDataEXT);
    // load(NamedFramebufferTextureEXT);
    // load(NamedFramebufferTextureLayerEXT);
    // load(NamedFramebufferTextureFaceEXT);
    // load(TextureRenderbufferEXT);
    // load(MultiTexRenderbufferEXT);
    // load(VertexArrayVertexOffsetEXT);
    // load(VertexArrayColorOffsetEXT);
    // load(VertexArrayEdgeFlagOffsetEXT);
    // load(VertexArrayIndexOffsetEXT);
    // load(VertexArrayNormalOffsetEXT);
    // load(VertexArrayTexCoordOffsetEXT);
    // load(VertexArrayMultiTexCoordOffsetEXT);
    // load(VertexArrayFogCoordOffsetEXT);
    // load(VertexArraySecondaryColorOffsetEXT);
    // load(VertexArrayVertexAttribOffsetEXT);
    // load(VertexArrayVertexAttribIOffsetEXT);
    // load(EnableVertexArrayEXT);
    // load(DisableVertexArrayEXT);
    // load(EnableVertexArrayAttribEXT);
    // load(DisableVertexArrayAttribEXT);
    // load(GetVertexArrayIntegervEXT);
    // load(GetVertexArrayPointervEXT);
    // load(GetVertexArrayIntegeri_vEXT);
    // load(GetVertexArrayPointeri_vEXT);
    // load(MapNamedBufferRangeEXT);
    // load(FlushMappedNamedBufferRangeEXT);
    // load(NamedBufferStorageEXT);
    // load(ClearNamedBufferDataEXT);
    // load(ClearNamedBufferSubDataEXT);
    // load(NamedFramebufferParameteriEXT);
    // load(GetNamedFramebufferParameterivEXT);
    // load(ProgramUniform1dEXT);
    // load(ProgramUniform2dEXT);
    // load(ProgramUniform3dEXT);
    // load(ProgramUniform4dEXT);
    // load(ProgramUniform1dvEXT);
    // load(ProgramUniform2dvEXT);
    // load(ProgramUniform3dvEXT);
    // load(ProgramUniform4dvEXT);
    // load(ProgramUniformMatrix2dvEXT);
    // load(ProgramUniformMatrix3dvEXT);
    // load(ProgramUniformMatrix4dvEXT);
    // load(ProgramUniformMatrix2x3dvEXT);
    // load(ProgramUniformMatrix2x4dvEXT);
    // load(ProgramUniformMatrix3x2dvEXT);
    // load(ProgramUniformMatrix3x4dvEXT);
    // load(ProgramUniformMatrix4x2dvEXT);
    // load(ProgramUniformMatrix4x3dvEXT);
    // load(TextureBufferRangeEXT);
    // load(TextureStorage1DEXT);
    // load(TextureStorage2DEXT);
    // load(TextureStorage3DEXT);
    // load(TextureStorage2DMultisampleEXT);
    // load(TextureStorage3DMultisampleEXT);
    // load(VertexArrayBindVertexBufferEXT);
    // load(VertexArrayVertexAttribFormatEXT);
    // load(VertexArrayVertexAttribIFormatEXT);
    // load(VertexArrayVertexAttribLFormatEXT);
    // load(VertexArrayVertexAttribBindingEXT);
    // load(VertexArrayVertexBindingDivisorEXT);
    // load(VertexArrayVertexAttribLOffsetEXT);
    // load(TexturePageCommitmentEXT);
    // load(VertexArrayVertexAttribDivisorEXT);
    // load(DrawArraysInstancedEXT);
    // load(DrawElementsInstancedEXT);
    // load(PolygonOffsetClampEXT);
    // load(RasterSamplesEXT);
    // load(UseShaderProgramEXT);
    // load(ActiveProgramEXT);
    // load(CreateShaderProgramEXT);
    // load(FramebufferFetchBarrierEXT);
    // load(TexStorage1DEXT);
    // load(TexStorage2DEXT);
    // load(TexStorage3DEXT);
    // load(WindowRectanglesEXT);
    // load(ApplyFramebufferAttachmentCMAAINTEL);
    // load(BeginPerfQueryINTEL);
    // load(CreatePerfQueryINTEL);
    // load(DeletePerfQueryINTEL);
    // load(EndPerfQueryINTEL);
    // load(GetFirstPerfQueryIdINTEL);
    // load(GetNextPerfQueryIdINTEL);
    // load(GetPerfCounterInfoINTEL);
    // load(GetPerfQueryDataINTEL);
    // load(GetPerfQueryIdByNameINTEL);
    // load(GetPerfQueryInfoINTEL);
    // load(FramebufferParameteriMESA);
    // load(GetFramebufferParameterivMESA);
    // load(MultiDrawArraysIndirectBindlessNV);
    // load(MultiDrawElementsIndirectBindlessNV);
    // load(MultiDrawArraysIndirectBindlessCountNV);
    // load(MultiDrawElementsIndirectBindlessCountNV);
    // load(GetTextureHandleNV);
    // load(GetTextureSamplerHandleNV);
    // load(MakeTextureHandleResidentNV);
    // load(MakeTextureHandleNonResidentNV);
    // load(GetImageHandleNV);
    // load(MakeImageHandleResidentNV);
    // load(MakeImageHandleNonResidentNV);
    // load(UniformHandleui64NV);
    // load(UniformHandleui64vNV);
    // load(ProgramUniformHandleui64NV);
    // load(ProgramUniformHandleui64vNV);
    // load(IsTextureHandleResidentNV);
    // load(IsImageHandleResidentNV);
    // load(BlendParameteriNV);
    // load(BlendBarrierNV);
    // load(ViewportPositionWScaleNV);
    // load(CreateStatesNV);
    // load(DeleteStatesNV);
    // load(IsStateNV);
    // load(StateCaptureNV);
    // load(GetCommandHeaderNV);
    // load(GetStageIndexNV);
    // load(DrawCommandsNV);
    // load(DrawCommandsAddressNV);
    // load(DrawCommandsStatesNV);
    // load(DrawCommandsStatesAddressNV);
    // load(CreateCommandListsNV);
    // load(DeleteCommandListsNV);
    // load(IsCommandListNV);
    // load(ListDrawCommandsStatesClientNV);
    // load(CommandListSegmentsNV);
    // load(CompileCommandListNV);
    // load(CallCommandListNV);
    // load(BeginConditionalRenderNV);
    // load(EndConditionalRenderNV);
    // load(SubpixelPrecisionBiasNV);
    // load(ConservativeRasterParameterfNV);
    // load(ConservativeRasterParameteriNV);
    // load(DepthRangedNV);
    // load(ClearDepthdNV);
    // load(DepthBoundsdNV);
    // load(DrawVkImageNV);
    // load(GetVkProcAddrNV);
    // load(WaitVkSemaphoreNV);
    // load(SignalVkSemaphoreNV);
    // load(SignalVkFenceNV);
    // load(FragmentCoverageColorNV);
    // load(CoverageModulationTableNV);
    // load(GetCoverageModulationTableNV);
    // load(CoverageModulationNV);
    // load(RenderbufferStorageMultisampleCoverageNV);
    // load(Uniform1i64NV);
    // load(Uniform2i64NV);
    // load(Uniform3i64NV);
    // load(Uniform4i64NV);
    // load(Uniform1i64vNV);
    // load(Uniform2i64vNV);
    // load(Uniform3i64vNV);
    // load(Uniform4i64vNV);
    // load(Uniform1ui64NV);
    // load(Uniform2ui64NV);
    // load(Uniform3ui64NV);
    // load(Uniform4ui64NV);
    // load(Uniform1ui64vNV);
    // load(Uniform2ui64vNV);
    // load(Uniform3ui64vNV);
    // load(Uniform4ui64vNV);
    // load(GetUniformi64vNV);
    // load(ProgramUniform1i64NV);
    // load(ProgramUniform2i64NV);
    // load(ProgramUniform3i64NV);
    // load(ProgramUniform4i64NV);
    // load(ProgramUniform1i64vNV);
    // load(ProgramUniform2i64vNV);
    // load(ProgramUniform3i64vNV);
    // load(ProgramUniform4i64vNV);
    // load(ProgramUniform1ui64NV);
    // load(ProgramUniform2ui64NV);
    // load(ProgramUniform3ui64NV);
    // load(ProgramUniform4ui64NV);
    // load(ProgramUniform1ui64vNV);
    // load(ProgramUniform2ui64vNV);
    // load(ProgramUniform3ui64vNV);
    // load(ProgramUniform4ui64vNV);
    // load(GetInternalformatSampleivNV);
    // load(GetMemoryObjectDetachedResourcesuivNV);
    // load(ResetMemoryObjectParameterNV);
    // load(TexAttachMemoryNV);
    // load(BufferAttachMemoryNV);
    // load(TextureAttachMemoryNV);
    // load(NamedBufferAttachMemoryNV);
    // load(BufferPageCommitmentMemNV);
    // load(TexPageCommitmentMemNV);
    // load(NamedBufferPageCommitmentMemNV);
    // load(TexturePageCommitmentMemNV);
    // load(DrawMeshTasksNV);
    // load(DrawMeshTasksIndirectNV);
    // load(MultiDrawMeshTasksIndirectNV);
    // load(MultiDrawMeshTasksIndirectCountNV);
    // load(GenPathsNV);
    // load(DeletePathsNV);
    // load(IsPathNV);
    // load(PathCommandsNV);
    // load(PathCoordsNV);
    // load(PathSubCommandsNV);
    // load(PathSubCoordsNV);
    // load(PathStringNV);
    // load(PathGlyphsNV);
    // load(PathGlyphRangeNV);
    // load(WeightPathsNV);
    // load(CopyPathNV);
    // load(InterpolatePathsNV);
    // load(TransformPathNV);
    // load(PathParameterivNV);
    // load(PathParameteriNV);
    // load(PathParameterfvNV);
    // load(PathParameterfNV);
    // load(PathDashArrayNV);
    // load(PathStencilFuncNV);
    // load(PathStencilDepthOffsetNV);
    // load(StencilFillPathNV);
    // load(StencilStrokePathNV);
    // load(StencilFillPathInstancedNV);
    // load(StencilStrokePathInstancedNV);
    // load(PathCoverDepthFuncNV);
    // load(CoverFillPathNV);
    // load(CoverStrokePathNV);
    // load(CoverFillPathInstancedNV);
    // load(CoverStrokePathInstancedNV);
    // load(GetPathParameterivNV);
    // load(GetPathParameterfvNV);
    // load(GetPathCommandsNV);
    // load(GetPathCoordsNV);
    // load(GetPathDashArrayNV);
    // load(GetPathMetricsNV);
    // load(GetPathMetricRangeNV);
    // load(GetPathSpacingNV);
    // load(IsPointInFillPathNV);
    // load(IsPointInStrokePathNV);
    // load(GetPathLengthNV);
    // load(PointAlongPathNV);
    // load(MatrixLoad3x2fNV);
    // load(MatrixLoad3x3fNV);
    // load(MatrixLoadTranspose3x3fNV);
    // load(MatrixMult3x2fNV);
    // load(MatrixMult3x3fNV);
    // load(MatrixMultTranspose3x3fNV);
    // load(StencilThenCoverFillPathNV);
    // load(StencilThenCoverStrokePathNV);
    // load(StencilThenCoverFillPathInstancedNV);
    // load(StencilThenCoverStrokePathInstancedNV);
    // load(PathGlyphIndexRangeNV);
    // load(PathGlyphIndexArrayNV);
    // load(PathMemoryGlyphIndexArrayNV);
    // load(ProgramPathFragmentInputGenNV);
    // load(GetProgramResourcefvNV);
    // load(FramebufferSampleLocationsfvNV);
    // load(NamedFramebufferSampleLocationsfvNV);
    // load(ResolveDepthValuesNV);
    // load(ScissorExclusiveNV);
    // load(ScissorExclusiveArrayvNV);
    // load(MakeBufferResidentNV);
    // load(MakeBufferNonResidentNV);
    // load(IsBufferResidentNV);
    // load(MakeNamedBufferResidentNV);
    // load(MakeNamedBufferNonResidentNV);
    // load(IsNamedBufferResidentNV);
    // load(GetBufferParameterui64vNV);
    // load(GetNamedBufferParameterui64vNV);
    // load(GetIntegerui64vNV);
    // load(Uniformui64NV);
    // load(Uniformui64vNV);
    // load(GetUniformui64vNV);
    // load(ProgramUniformui64NV);
    // load(ProgramUniformui64vNV);
    // load(BindShadingRateImageNV);
    // load(GetShadingRateImagePaletteNV);
    // load(GetShadingRateSampleLocationivNV);
    // load(ShadingRateImageBarrierNV);
    // load(ShadingRateImagePaletteNV);
    // load(ShadingRateSampleOrderNV);
    // load(ShadingRateSampleOrderCustomNV);
    // load(TextureBarrierNV);
    // load(VertexAttribL1i64NV);
    // load(VertexAttribL2i64NV);
    // load(VertexAttribL3i64NV);
    // load(VertexAttribL4i64NV);
    // load(VertexAttribL1i64vNV);
    // load(VertexAttribL2i64vNV);
    // load(VertexAttribL3i64vNV);
    // load(VertexAttribL4i64vNV);
    // load(VertexAttribL1ui64NV);
    // load(VertexAttribL2ui64NV);
    // load(VertexAttribL3ui64NV);
    // load(VertexAttribL4ui64NV);
    // load(VertexAttribL1ui64vNV);
    // load(VertexAttribL2ui64vNV);
    // load(VertexAttribL3ui64vNV);
    // load(VertexAttribL4ui64vNV);
    // load(GetVertexAttribLi64vNV);
    // load(GetVertexAttribLui64vNV);
    // load(VertexAttribLFormatNV);
    // load(BufferAddressRangeNV);
    // load(VertexFormatNV);
    // load(NormalFormatNV);
    // load(ColorFormatNV);
    // load(IndexFormatNV);
    // load(TexCoordFormatNV);
    // load(EdgeFlagFormatNV);
    // load(SecondaryColorFormatNV);
    // load(FogCoordFormatNV);
    // load(VertexAttribFormatNV);
    // load(VertexAttribIFormatNV);
    // load(GetIntegerui64i_vNV);
    // load(ViewportSwizzleNV);
    // load(FramebufferTextureMultiviewOVR);

    #undef load

    return res;
};
