# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional, TYPE_CHECKING

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class ComponentLinkedStorageAccounts(ProxyResource):
    """An Application Insights component linked storage accounts.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar linked_storage_account: Linked storage account resource ID.
    :vartype linked_storage_account: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "linked_storage_account": {"key": "properties.linkedStorageAccount", "type": "str"},
    }

    def __init__(self, *, linked_storage_account: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword linked_storage_account: Linked storage account resource ID.
        :paramtype linked_storage_account: str
        """
        super().__init__(**kwargs)
        self.linked_storage_account = linked_storage_account


class ComponentLinkedStorageAccountsPatch(_serialization.Model):
    """An Application Insights component linked storage accounts patch.

    :ivar linked_storage_account: Linked storage account resource ID.
    :vartype linked_storage_account: str
    """

    _attribute_map = {
        "linked_storage_account": {"key": "properties.linkedStorageAccount", "type": "str"},
    }

    def __init__(self, *, linked_storage_account: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword linked_storage_account: Linked storage account resource ID.
        :paramtype linked_storage_account: str
        """
        super().__init__(**kwargs)
        self.linked_storage_account = linked_storage_account


class ErrorResponseLinkedStorage(_serialization.Model):
    """ErrorResponseLinkedStorage.

    :ivar error: Error response indicates Insights service is not able to process the incoming
     request. The reason is provided in the error message.
    :vartype error:
     ~azure.mgmt.applicationinsights.v2020_03_01_preview.models.ErrorResponseLinkedStorageError
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorResponseLinkedStorageError"},
    }

    def __init__(self, *, error: Optional["_models.ErrorResponseLinkedStorageError"] = None, **kwargs: Any) -> None:
        """
        :keyword error: Error response indicates Insights service is not able to process the incoming
         request. The reason is provided in the error message.
        :paramtype error:
         ~azure.mgmt.applicationinsights.v2020_03_01_preview.models.ErrorResponseLinkedStorageError
        """
        super().__init__(**kwargs)
        self.error = error


class ErrorResponseLinkedStorageError(_serialization.Model):
    """Error response indicates Insights service is not able to process the incoming request. The
    reason is provided in the error message.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
