# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PipelineReference(Model):
    """Pipeline reference type.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. Pipeline reference type. Default value:
     "PipelineReference" .
    :vartype type: str
    :param reference_name: Required. Reference pipeline name.
    :type reference_name: str
    :param name: Reference name.
    :type name: str
    """

    _validation = {
        'type': {'required': True, 'constant': True},
        'reference_name': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'reference_name': {'key': 'referenceName', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    type = "PipelineReference"

    def __init__(self, *, reference_name: str, name: str=None, **kwargs) -> None:
        super(PipelineReference, self).__init__(**kwargs)
        self.reference_name = reference_name
        self.name = name
