/*	Words_test

CVS ID: Words_test.java,v 1.13 2012/04/16 06:15:36 castalia Exp

Copyright (C) 2004-2012  Arizona Board of Regents on behalf of the
Planetary Image Research Laboratory, Lunar and Planetary Laboratory at
the University of Arizona.

This file is part of the PIRL Java Packages.

The PIRL Java Packages are free software; you can redistribute them
and/or modify them under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation, either version 3 of
the License, or (at your option) any later version.

The PIRL Java Packages are distributed in the hope that they will be
useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser
General Public License for more details.

You should have received a copy of the GNU Lesser General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.

*******************************************************************************/

import	PIRL.Strings.Words;
import	PIRL.Utilities.Checker;

import	java.util.Vector;


public class Words_test
{
public static void main (String[] arguments) 
{
System.out.println ("*** Words_test: " + Words.ID);
Checker
	checker = new Checker ();
String
	string;

if (arguments.length > 0 &&
	arguments[0].startsWith ("-v"))
	checker.Verbose = true;

string = "  First\tSecond\n\tThird=third&Fourth=fourth";
if (checker.Verbose)
	System.out.println ("--- words = new Words (String)\n"
		+"    String -\n>|" + string + "|<");
Words
	words = new Words (string);
checker.Check ("new Words (\"" + string + "\"); toString ()",
	string, words.toString ());


checker.Check ("First words.Next_Word ()",
	"First", words.Next_Word ());

checker.Check ("Second words.Next_Word ()",
	"Second", words.Next_Word ());

checker.Check ("Third words.Next_Word ()",
	"Third=third&Fourth=fourth", words.Next_Word ());

checker.Check ("Fourth words.Next_Word ()",
	"", words.Next_Word ());

words.Location (3);
checker.Check ("words.Location (3), Start_Index",
	3, words.Start_Index);
checker.Check ("words.Location (3), End_Index",
	3, words.End_Index);

words.Restore ();
checker.Check ("words.Restore (), Start_Index",
	0, words.Start_Index);
checker.Check ("words.Restore (), End_Index",
	0, words.End_Index);

words.Delimiters (Words.DEFAULT_DELIMITERS + "=&");
checker.Check ("words.Delimiters (Words.DEFAULT_DELIMITERS + \"=&\")",
	Words.DEFAULT_DELIMITERS + "=&", words.Delimiters ());

words.Mask ("XXX");
checker.Check ("words.Mask (\"XXX\")",
	"XXX", words.Mask ());

Vector
	names = new Vector (),
	expected_names = new Vector ();
names.add ("Third");
names.add ("Fourth");
words.Mask (names);
checker.Check ("words.Mask (Vector " + names + ")",
	"  First\tSecond\n\tThird=XXX&Fourth=XXX", words.toString ());

names = words.Restore ().Split ();
expected_names.clear ();
expected_names.add ("First");
expected_names.add ("Second");
expected_names.add ("Third");
expected_names.add ("XXX");
expected_names.add ("Fourth");
expected_names.add ("XXX");
checker.Check ("words.Restore ().Split ()",
	expected_names, names);

names = words.Characters ("First/1 second ").Delimiters ("/ ").Split (2);
expected_names.clear ();
expected_names.add ("First");
expected_names.add ("1 second ");
checker.Check ("words.Characters (\"First/1 second \").Delimiters (\"/ \").Split (2)",
	expected_names, names);

names = words.Restore ().Split (3);
expected_names.clear ();
expected_names.add ("First");
expected_names.add ("1");
expected_names.add ("second ");
checker.Check ("words.Restore ().Split (3)",
	expected_names, names);

names = words.Restore ().Split (-3);
expected_names.clear ();
expected_names.add ("First");
expected_names.add ("1");
expected_names.add (" second ");
checker.Check ("words.Restore ().Split (-3)",
	expected_names, names);

names = words.Restore ().Split ();
expected_names.clear ();
expected_names.add ("First");
expected_names.add ("1");
expected_names.add ("second");
checker.Check ("words.Restore ().Split ()",
	expected_names, names);


//	Quoted words.

string = "con\"joined\"";
names = words.Characters (string).Delimit_at_Quote (false).Split ();
expected_names.clear ();
expected_names.add ("con\"joined\"");
checker.Check ("words.Characters (\"" + string + "\").Delimit_at_Quote (false).Split ()",
	expected_names, names);

string = "A \"quoted \\\"word\\\" string\" line'test'";
words.Characters (string).Delimit_at_Quote (true);
checker.Check ("words.Characters (\"" + string + "\").Delimit_at_Quote (true)",
	string, words.toString ());

checker.Check ("First unquoted words.Next_Word ()",
	"A", words.Next_Word ());

checker.Check ("Second quoted words.Next_Word ()",
	"\"quoted \\\"word\\\" string\"", words.Next_Word ());

checker.Check ("Third unquoted words.Next_Word () preceeding contiguous quote",
	"line", words.Next_Word ());

checker.Check ("Contiguous quoted fourth words.Next_Word ()",
	"'test'", words.Next_Word ());


words.Quoted_Words (false);
checker.Check ("words.Quoted_Words (false)",
	false, words.Quoted_Words ());

checker.Check ("words.Restore ().toString ()",
	string, words.Restore ().toString ());

checker.Check ("Ignore quotes first words.Next_Word ()",
	"A", words.Next_Word ());

checker.Check ("Ignore quotes second words.Next_Word ()",
	"\"quoted", words.Next_Word ());

checker.Check ("Ignore quotes third words.Next_Word ()",
	"\\\"word\\\"", words.Next_Word ());

checker.Check ("Ignore quotes fourth words.Next_Word ()",
	"string\"", words.Next_Word ());

checker.Check ("Ignore quotes fifth words.Next_Word ()",
	"line'test'", words.Next_Word ());


string = "(A)','B','(C)";
if (checker.Verbose)
	System.out.println
		("--- words.Characters (\"" + string + "\").Quoted_Words (true).Parenthesized_Words (true)");
words.Characters (string).Quoted_Words (true).Parenthesized_Words (true);
checker.Check ("Combined paren/quote/clear/quote/paren first words.Next_Word ()",
	"(A)", words.Next_Word ());
checker.Check ("Combined paren/quote/clear/quote/paren second words.Next_Word ()",
	"','", words.Next_Word ());
checker.Check ("Combined paren/quote/clear/quote/paren third words.Next_Word ()",
	"B", words.Next_Word ());
checker.Check ("Combined paren/quote/clear/quote/paren fourth words.Next_Word ()",
	"','", words.Next_Word ());
checker.Check ("Combined paren/quote/clear/quote/paren fifth words.Next_Word ()",
	"(C)", words.Next_Word ());


//	Parenthesized words.

string = "The (parens) (are (nested)) word(characters)";
words.Characters (string).Parenthesized_Words (false);
checker.Check ("words.Characters (\"" + string + "\")",
	string, words.toString ());
checker.Check ("Ignore parenthesizes first words.Next_Word ()",
	"The", words.Next_Word ());
checker.Check ("Ignore parenthesizes second words.Next_Word ()",
	"(parens)", words.Next_Word ());
checker.Check ("Ignore parenthesizes third words.Next_Word ()",
	"(are", words.Next_Word ());
checker.Check ("Ignore parenthesizes fourth words.Next_Word ()",
	"(nested))", words.Next_Word ());
checker.Check ("Ignore parenthesizes fifth words.Next_Word ()",
	"word(characters)", words.Next_Word ());


words.Parenthesized_Words (true).Restore ();
checker.Check ("words.Parenthesized_Words (true)",
	true, words.Parenthesized_Words ());

checker.Check ("words.Restore ().toString ()",
	string, words.Restore ().toString ());

checker.Check ("First unparenthesized words.Next_Word ()",
	"The", words.Next_Word ());
checker.Check ("Second parenthesized words.Next_Word ()",
	"(parens)", words.Next_Word ());
checker.Check ("Third parenthesized with nested parentheses words.Next_Word ()",
	"(are (nested))", words.Next_Word ());
checker.Check ("Fourth unparenthesized words.Next_Word () preceeding contiguous paren",
	"word", words.Next_Word ());


if (checker.Verbose)
	System.out.println ("--- words.Mark ()");
words.Mark ();
checker.Check ("words.Mark_Index.Start_Index",
	28, words.Mark_Index.Start_Index);
checker.Check ("words.Mark_Index.End_Index",
	32, words.Mark_Index.End_Index);


checker.Check ("Contiguous parenthesized fifth words.Next_Word ()",
	"(characters)", words.Next_Word ());


words.Restore ();
checker.Check ("words.Restore (); words.Mark_Index.Start_Index",
	28, words.Mark_Index.Start_Index);
checker.Check ("words.Mark_Index.End_Index",
	32, words.Mark_Index.End_Index);


checker.Check ("After Restore contiguous parenthesized fifth words.Next_Word ()",
	"(characters)", words.Next_Word ());


System.out.println
	("Checks: " + checker.Checks_Total + '\n'
	+"Passed: " + checker.Checks_Passed);

System.exit (checker.Checks_Total - checker.Checks_Passed);
}
}
