#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "libs.h"
#include "log.h"
#include "db.h"
#include "dep.h"

int try_socket_(int logdepth, const char *includes, const char *test_c, const char *cflags, const char *ldflags);

/* try test program without fetching any implicits */
int try_socket_pure(int logdepth, const char *prefix, const char *includes, const char *defs, const char *test_c, const char *cflags, const char *ldflags, int printreport);

/* try test program with socket init/uninit defines, includes, ldflags and cflags appended */
int try_socket(int logdepth, const char *prefix, const char *includes, const char *test_c, const char *cflags, const char *ldflags, int printreport);

/* try test program with socket init/uninit defines, includes, special defines, ldflags and cflags appended */
int try_socket_def(int logdepth, const char *prefix, const char *includes, char *defs_, const char *test_c, const char *cflags, const char *ldflags, int printreport);

/* socket API detection */
int find_socket_socket(int logdepth, int fatal);
int find_socket_wsasocket(int logdepth, int fatal);
int find_socket_socketpair(int logdepth, int fatal);
int find_socket_select(int logdepth, int fatal);
int find_socket_poll(int logdepth, int fatal);
int find_socket_types(int logdepth, int fatal);
int find_socket_ioctlsocket(int logdepth, int fatal);
int find_socket_closesocket(int logdepth, int fatal);
int find_socket_SHUT(int logdepth, int fatal);
int find_socket_SD(int logdepth, int fatal);
int find_socket_shutdown(int logdepth, int fatal);
int find_socket_fionbio(int logdepth, int fatal);
int find_socket_sockaddr_in(int logdepth, int fatal);
int find_socket_lac(int logdepth, int fatal);
int find_socket_recvsend(int logdepth, int fatal);
int find_socket_readwrite(int logdepth, int fatal);
int find_socket_ntoh(int logdepth, int fatal);

int find_socket_getaddrinfo(int logdepth, int fatal);
int find_socket_getnameinfo(int logdepth, int fatal);
