/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse;

import com.sourceforge.knecs.util.converters.FormatException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.bse.Matrix;
import org.scidac.cmcs.tools.bse.ShellFilter;
import org.scidac.cmcs.tools.pertable.PerTable;

public class MolproInputToBasisXml
extends AbstractBasisSetToXml {
    protected PerTable mPertable = PerTable.getPerTable();
    protected static final int MAXLINES = 100;
    protected boolean mSkipSPLogic = false;

    @Override
    public Vector convert(String title, String xmlFileName, String harmonicType, String description, InputStream inputStream) throws IOException, FormatException {
        Vector ret = null;
        this.mSkipSPLogic = false;
        boolean hasBasisSet = false;
        boolean hasEcp = false;
        boolean hasSo = false;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        int lineCnt = 0;
        while ((line = reader.readLine()) != null) {
            if (++lineCnt > 100) {
                throw new FormatException("Expected to find basis keyword within first 100 lines.");
            }
            if (!(line = line.trim().toUpperCase()).startsWith("BASIS=")) continue;
            ret = this.loadBasisSet(reader, line, title, xmlFileName, harmonicType, description);
            break;
        }
        if (ret.size() == 0) {
            throw new FormatException("Unable to find start of basis set data.  Make sure you have specified the correct file type.");
        }
        for (Document doc : ret) {
            String docType = doc.getRootElement().getName().toLowerCase();
            if (!docType.equals("basisset")) continue;
            this.convertToSharedSP(doc);
            if (ret.size() == 2) {
                doc.getRootElement().addContent(this.createEcpLink(xmlFileName));
            }
            if (ret.size() != 3) continue;
            doc.getRootElement().addContent(this.createSoLink(xmlFileName));
        }
        return ret;
    }

    protected Vector loadBasisSet(BufferedReader reader, String options, String name, String xmlFileName, String harmonicType, String description) throws IOException, FormatException {
        Vector<Document> ret = new Vector<Document>();
        Element bsroot = this.createBasisRoot();
        bsroot.addContent(this.createBasisMime());
        bsroot.addContent(this.createTitle(name));
        bsroot.addContent(this.createHarmonicType(harmonicType));
        boolean segmented = false;
        Element contrType = this.createContractionType("segmented");
        bsroot.addContent(contrType);
        bsroot.addContent(this.createRefLink(xmlFileName + "-BS-REF.xml"));
        bsroot.addContent(this.createDescription(description));
        String line = "";
        String maxShell = this.getMinimumShell();
        String lastElement = "";
        Element contractions = null;
        Document ecps = null;
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim().toUpperCase()).length() == 0 || line.startsWith("!")) continue;
            if (line.startsWith("ECP")) {
                ecps = this.loadECPs(reader, line, name, xmlFileName);
                continue;
            }
            if (line.equals("}")) continue;
            Vector exponents = this.tokenize(line, ", ");
            String shell = (String)exponents.get(0);
            exponents.remove(0);
            if (!this.isValidShell(shell)) {
                throw new FormatException("Unrecognized shell type " + shell);
            }
            String element = (String)exponents.get(0);
            exponents.remove(0);
            element = this.mPertable.formatSymbol(element);
            if (!this.mPertable.isValid(element)) {
                throw new FormatException("Unrecognized element: " + element);
            }
            while (line.endsWith(";")) {
                line = reader.readLine();
                line = line.trim().toUpperCase();
                exponents.addAll(this.tokenize(line, ", "));
            }
            Vector coeffs = new Vector();
            Vector contrNums = new Vector();
            Vector numExps = new Vector();
            this.getCoeffLines(reader, coeffs, contrNums, numExps);
            if (coeffs.size() == 0) {
                throw new FormatException("Coefficient data not found: " + line);
            }
            if (!element.equals(lastElement)) {
                contractions = this.createContractions(element);
                bsroot.addContent(contractions);
                lastElement = element;
                maxShell = this.getMinimumShell();
            }
            segmented = this.buildContractedSets(exponents, coeffs, contrNums, numExps, contractions, shell);
        }
        if (!segmented) {
            contrType.setText("general");
        }
        ret.add(new Document(bsroot));
        if (ecps != null) {
            ret.add(ecps);
        }
        return ret;
    }

    protected boolean buildContractedSets(Vector exponents, Vector coeffs, Vector contrNums, Vector numExps, Element contractions, String shell) throws FormatException {
        boolean segmented = false;
        Element contraction = null;
        int contNum = 0;
        Vector matrix = new Vector();
        int num = 0;
        int numExp = 0;
        boolean prevnum = false;
        int prevnumExp = -1;
        Element matrixEl = null;
        int numBlocks = coeffs.size();
        for (int idx = 0; idx < numBlocks; ++idx) {
            num = (Integer)contrNums.get(idx);
            if (num != (numExp = ((Integer)numExps.get(idx)).intValue())) {
                segmented = true;
            }
            if (contNum != num) {
                contNum = num;
                if (num == numExp && numExp <= prevnumExp) {
                    this.mSkipSPLogic = true;
                    Matrix origmatrix = new Matrix(matrixEl);
                    Vector column = (Vector)coeffs.get(idx);
                    Matrix result = origmatrix.appendContraction(numExp - 1, (String)column.get(0));
                    contraction.removeContent();
                    matrixEl = this.createMatrix(result);
                    contraction.addContent(matrixEl);
                    continue;
                }
                contraction = this.createContraction(shell);
                contractions.addContent(contraction);
                matrix.clear();
                prevnumExp = numExp;
            }
            int maxExp = this.getNumExpForContraction(idx, contrNums, numExps);
            int numCols = 0;
            int row = 0;
            int jdx = num;
            while (jdx <= maxExp) {
                numCols = 0;
                matrix.add(exponents.get(jdx - 1));
                for (int kdx = idx; kdx < coeffs.size(); ++kdx) {
                    int num1 = (Integer)contrNums.get(kdx);
                    int exp1 = (Integer)numExps.get(kdx);
                    if (num1 != num) break;
                    Vector col = (Vector)coeffs.get(kdx);
                    if (row >= col.size()) {
                        this.mSkipSPLogic = true;
                        matrix.add("0.0");
                    } else {
                        matrix.add(col.get(row));
                    }
                    ++numCols;
                }
                ++jdx;
                ++row;
            }
            idx += numCols - 1;
            matrixEl = this.createMatrix(matrix, maxExp - num + 1, numCols + 1);
            contraction.addContent(matrixEl);
        }
        return segmented;
    }

    protected int getNumExpForContraction(int startIdx, Vector contrNums, Vector numExps) {
        int maxExp = 1;
        int num = (Integer)contrNums.get(startIdx);
        for (int idx = startIdx; idx < numExps.size(); ++idx) {
            int thisNumExp = (Integer)numExps.get(idx);
            int thisNumContr = (Integer)contrNums.get(idx);
            if (thisNumContr != num) break;
            if (thisNumExp <= maxExp) continue;
            maxExp = thisNumExp;
        }
        return maxExp;
    }

    protected Document loadECPs(BufferedReader reader, String firstLine, String name, String xmlFileName) throws IOException, FormatException {
        Element root = this.createEcpRoot();
        root.addContent(this.createEcpMime());
        root.addContent(this.createTitle(name));
        root.addContent(this.createEcpType("type"));
        if (xmlFileName.endsWith("-ECP")) {
            root.addContent(this.createRefLink(xmlFileName + "-REF.xml"));
        } else {
            root.addContent(this.createRefLink(xmlFileName + "-ECP-REF.xml"));
        }
        String line = firstLine;
        while ((line = line.trim().toUpperCase()).length() != 0) {
            if (!line.startsWith("!")) {
                Vector columns = this.tokenize(line, ", ;");
                String element = (String)columns.get(1);
                if (!this.mPertable.isValid(element = this.mPertable.formatSymbol(element))) {
                    throw new FormatException("Unrecognized element: " + element);
                }
                if (columns.size() < 4) {
                    throw new FormatException("Missing nelec: " + line);
                }
                String nElectrons = (String)columns.get(2);
                Element potentials = this.createPotentials(element, nElectrons);
                root.addContent(potentials);
                while ((line = reader.readLine()) != null && (line = line.trim().toUpperCase()).length() != 0 && !line.startsWith("}") && !line.startsWith("ECP")) {
                    String desc = "";
                    String shell = "?";
                    int numLines = Integer.parseInt(line.substring(0, line.indexOf(";")));
                    int exPos = line.indexOf("!");
                    if (exPos > 0) {
                        desc = line.substring(exPos + 1).trim();
                        shell = desc.substring(0, 1);
                    }
                    Element potential = this.createPotential(desc, shell);
                    potentials.addContent(potential);
                    Vector matrix = new Vector();
                    int numCol = 0;
                    for (int idx = 0; idx < numLines; ++idx) {
                        line = reader.readLine();
                        if (line == null) {
                            throw new FormatException("Unable to read more ECP data.");
                        }
                        Vector lineData = this.tokenize(line, ", ;");
                        numCol = lineData.size();
                        matrix.addAll(lineData);
                    }
                    Element matrixEl = this.createMatrix(matrix, numLines, numCol);
                    potential.addContent(matrixEl);
                    reader.mark(80);
                }
                reader.reset();
                if (line == null) break;
            }
            if (!line.equals("}") && (line = reader.readLine()) != null) continue;
        }
        return root != null ? new Document(root) : null;
    }

    protected void getCoeffLines(BufferedReader reader, Vector coeffs, Vector contrNums, Vector numExps) throws IOException {
        String line;
        while ((line = reader.readLine()) != null && (line = line.trim()).length() != 0) {
            if (line.startsWith("}")) {
                reader.reset();
                break;
            }
            if (line.startsWith("c")) {
                Vector data = this.tokenize(line, ", ");
                data.remove(0);
                Vector info = this.tokenize((String)data.get(0), ".");
                data.remove(0);
                int num1 = Integer.parseInt((String)info.get(0));
                int numExp = Integer.parseInt((String)info.get(1));
                coeffs.add(data);
                contrNums.add(new Integer(num1));
                numExps.add(new Integer(numExp));
                reader.mark(512);
                continue;
            }
            reader.reset();
            break;
        }
    }

    protected void convertToSharedSP(Document doc) throws FormatException {
        if (!this.mSkipSPLogic) {
            Element root = doc.getRootElement();
            List elements = root.getChildren("contractions", mEmslNs);
            int numElements = elements.size();
            boolean uncontractedRuleHolds = true;
            Vector shellMatrices = new Vector();
            for (int idx = 0; idx < numElements; ++idx) {
                Element atom = (Element)elements.get(idx);
                ShellFilter pfilter = new ShellFilter("contraction", mEmslNs, "P");
                List pcontractions = atom.getContent(pfilter);
                for (int pdx = pcontractions.size() - 1; pdx >= 0; --pdx) {
                    Element pel = (Element)pcontractions.get(pdx);
                    List pmatrices = pel.getChildren("matrix", mCmlNs);
                    Element pmatrixEl = (Element)pmatrices.get(0);
                    Matrix pmatrix = new Matrix(pmatrixEl);
                    ShellFilter sfilter = new ShellFilter("contraction", mEmslNs, "S");
                    List scontractions = atom.getContent(sfilter);
                    for (int sdx = 0; sdx < scontractions.size(); ++sdx) {
                        Element sel = (Element)scontractions.get(sdx);
                        List smatrices = sel.getChildren("matrix", mCmlNs);
                        Element smatrixEl = (Element)smatrices.get(0);
                        Matrix smatrix = new Matrix(smatrixEl);
                        if (!pmatrix.matchesExponentsExact(smatrix)) continue;
                        Matrix sp = smatrix.mergeSP(pmatrix);
                        atom.removeContent(pel);
                        sel.removeContent();
                        sel.addContent(this.createMatrix(sp));
                        sel.setAttribute("shell", "SP");
                    }
                }
            }
        }
    }
}

