/*
 * Decompiled with CFR 0.152.
 */
package org.scidac.cmcs.tools.bse.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import org.jdom.Document;
import org.scidac.cmcs.tools.bse.AbstractBasisSetToXml;
import org.scidac.cmcs.tools.bse.GamessInputToBasisXml;
import org.scidac.cmcs.tools.bse.GaussianInputToBasisXml;
import org.scidac.cmcs.tools.bse.MolproInputToBasisXml;
import org.scidac.cmcs.tools.bse.MolproIntInputToBasisXml;
import org.scidac.cmcs.tools.bse.NWChemInputToBasisXml;

public class TestBasisSetToXml {
    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: ");
            System.out.println("\tTestBassiSetToXml <file> <tmpdir> <type>");
            System.out.println("\t<type> is one of [nw g94 molpro molproi gamessus]");
            System.exit(-1);
        }
        String input = args[0];
        String tmpdir = args[1];
        String type = "nw";
        if (args.length == 3) {
            type = args[2];
        }
        System.out.println("Converting " + input + " of type " + type);
        try {
            AbstractBasisSetToXml converter;
            if (type.equals("nw")) {
                converter = new NWChemInputToBasisXml();
            } else if (type.equals("gamessus")) {
                converter = new GamessInputToBasisXml();
            } else if (type.equals("molpro")) {
                converter = new MolproInputToBasisXml();
            } else if (type.equals("g94")) {
                converter = new GaussianInputToBasisXml();
            } else if (type.equals("molproi")) {
                converter = new MolproIntInputToBasisXml();
            } else {
                throw new Exception("Unrecognized type " + type);
            }
            FileInputStream is = new FileInputStream(input);
            File file = new File(input);
            Vector files = converter.convert(file.getName(), file.getName(), "Spherical", "my description", is);
            System.out.println("Files generated = " + files.size());
            File tmp = new File(tmpdir);
            for (int idx = 0; idx < files.size(); ++idx) {
                Document doc = (Document)files.get(idx);
                String[] types = converter.getContractionTypes(doc);
                System.out.println("Determining contraction types:" + types[0] + " " + types[1]);
                if (!types[1].equals("segmented")) {
                    converter.convertToGenerallyContracted(doc);
                    converter.setContractionType(doc, types[1]);
                } else {
                    converter.setContractionType(doc, types[0]);
                }
                AbstractBasisSetToXml.addContractionDescriptions(doc);
                File out = File.createTempFile("txt2xml", "xml", tmp);
                System.out.println("Writing to file " + out.getName());
                AbstractBasisSetToXml.makeFile(out, doc);
            }
        }
        catch (Exception ex) {
            System.out.println("Oh Oh " + ex.getMessage() + ex);
            ex.printStackTrace();
        }
    }
}

