# Interface: Document

### Properties

* [childNodes](#childnodes)
* [children](#children)
* [firstChild](#firstchild)
* [lastChild](#lastchild)
* [name](#name)
* [next](#next)
* [nextSibling](#nextsibling)
* [nodeType](#nodetype)
* [parent](#parent)
* [parentNode](#parentnode)
* [prev](#prev)
* [previousSibling](#previoussibling)
* [type](#type)
* [x-mode](#x_mode)

---

## Properties

<a id="childnodes"></a>

###  childNodes

**● childNodes**: *Node[]*

Same as [children](#children). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="children"></a>

###  children

**● children**: *Node[]*

Child nodes.

___
<a id="firstchild"></a>

###  firstChild

**● firstChild**: *Node*

First child of the node.

___
<a id="lastchild"></a>

###  lastChild

**● lastChild**: *Node*

Last child of the node.

___
<a id="name"></a>

###  name

**● name**: *"root"*

The name of the node.

___
<a id="next"></a>

###  next

**● next**: *Node*

Next sibling.

___
<a id="nextsibling"></a>

###  nextSibling

**● nextSibling**: *Node*

Same as [next](#next). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="nodetype"></a>

###  nodeType

**● nodeType**: *`number`*

[DOM spec](https://dom.spec.whatwg.org/#dom-node-nodetype)-compatible node [type](#type).

___
<a id="parent"></a>

###  parent

**● parent**: *Node*

Parent node.

___
<a id="parentnode"></a>

###  parentNode

**● parentNode**: *Node*

Same as [parent](#parent). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="prev"></a>

###  prev

**● prev**: *Node*

Previous sibling.

___
<a id="previoussibling"></a>

###  previousSibling

**● previousSibling**: *Node*

Same as [prev](#prev). [DOM spec](https://dom.spec.whatwg.org)-compatible alias.

___
<a id="type"></a>

###  type

**● type**: *"root"*

The type of the node.

___
<a id="x_mode"></a>

###  x-mode

**● x-mode**: *"no-quirks" | "quirks" | "limited-quirks"*

[Document mode](https://dom.spec.whatwg.org/#concept-document-limited-quirks).

___

