#ifndef _UTIL_H
#define _UTIL_H

/* utils.h
  
   Data structures and function declarations for facitilities provided in
   utils.c

   Copyright (C) 2008, 2009 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "numbers.h"
#include "pdu-ipx.h"

extern unsigned short _pb_cksum(void *data, int len);
extern char *_pb_make_prefix(int level);
extern char *_pb_mac_to_ascii(eth_addr_t *);
extern char *_pb_ip6addr2str(ip6_addr_t);
extern void _pb_array_shift_left(unsigned char *, size_t, int);
extern void _pb_dump_bytes(const unsigned char *, unsigned);
extern int _pb_format_ethernet_addr(const char *, uint8_t [ETH_ADDR_LEN]);
extern char *_pb_ipx_to_ascii(struct ipx_address *);
extern int _pb_format_ipx_addr(const char *, struct ipx_address *);
extern void _pb_random_block(uint8_t *, size_t);

#endif /* _UTIL_H */
