// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/devtools/build/v1/publish_build_event.proto

package build

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The service level of the build request. Backends only uses this value when
// the BuildEnqueued event is published to determine what level of service
// this build should receive.
type PublishLifecycleEventRequest_ServiceLevel int32

const (
	// Non-interactive builds can tolerate longer event latencies. This is the
	// default ServiceLevel if callers do not specify one.
	PublishLifecycleEventRequest_NONINTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 0
	// The events of an interactive build should be delivered with low latency.
	PublishLifecycleEventRequest_INTERACTIVE PublishLifecycleEventRequest_ServiceLevel = 1
)

var PublishLifecycleEventRequest_ServiceLevel_name = map[int32]string{
	0: "NONINTERACTIVE",
	1: "INTERACTIVE",
}

var PublishLifecycleEventRequest_ServiceLevel_value = map[string]int32{
	"NONINTERACTIVE": 0,
	"INTERACTIVE":    1,
}

func (x PublishLifecycleEventRequest_ServiceLevel) String() string {
	return proto.EnumName(PublishLifecycleEventRequest_ServiceLevel_name, int32(x))
}

func (PublishLifecycleEventRequest_ServiceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_81da11d19c4841eb, []int{0, 0}
}

// Publishes 'lifecycle events' that update the high-level state of a build:
// - BuildEnqueued: When a build is scheduled.
// - InvocationAttemptStarted: When work for a build starts; there can be
//     multiple invocations for a build (e.g. retries).
// - InvocationAttemptCompleted: When work for a build finishes.
// - BuildFinished: When a build is finished.
type PublishLifecycleEventRequest struct {
	// The interactivity of this build.
	ServiceLevel PublishLifecycleEventRequest_ServiceLevel `protobuf:"varint,1,opt,name=service_level,json=serviceLevel,proto3,enum=google.devtools.build.v1.PublishLifecycleEventRequest_ServiceLevel" json:"service_level,omitempty"`
	// Required. The lifecycle build event. If this is a build tool event, the RPC will fail
	// with INVALID_REQUEST.
	BuildEvent *OrderedBuildEvent `protobuf:"bytes,2,opt,name=build_event,json=buildEvent,proto3" json:"build_event,omitempty"`
	// If the next event for this build or invocation (depending on the event
	// type) hasn't been published after this duration from when {build_event}
	// is written to BES, consider this stream expired. If this field is not set,
	// BES backend will use its own default value.
	StreamTimeout *duration.Duration `protobuf:"bytes,3,opt,name=stream_timeout,json=streamTimeout,proto3" json:"stream_timeout,omitempty"`
	// Additional information about a build request. These are define by the event
	// publishers, and the Build Event Service does not validate or interpret
	// them. They are used while notifying internal systems of new builds and
	// invocations if the OrderedBuildEvent.event type is
	// BuildEnqueued/InvocationAttemptStarted.
	NotificationKeywords []string `protobuf:"bytes,4,rep,name=notification_keywords,json=notificationKeywords,proto3" json:"notification_keywords,omitempty"`
	// Required. The project this build is associated with.
	// This should match the project used for the initial call to
	// PublishLifecycleEvent (containing a BuildEnqueued message).
	ProjectId            string   `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublishLifecycleEventRequest) Reset()         { *m = PublishLifecycleEventRequest{} }
func (m *PublishLifecycleEventRequest) String() string { return proto.CompactTextString(m) }
func (*PublishLifecycleEventRequest) ProtoMessage()    {}
func (*PublishLifecycleEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81da11d19c4841eb, []int{0}
}

func (m *PublishLifecycleEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishLifecycleEventRequest.Unmarshal(m, b)
}
func (m *PublishLifecycleEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishLifecycleEventRequest.Marshal(b, m, deterministic)
}
func (m *PublishLifecycleEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishLifecycleEventRequest.Merge(m, src)
}
func (m *PublishLifecycleEventRequest) XXX_Size() int {
	return xxx_messageInfo_PublishLifecycleEventRequest.Size(m)
}
func (m *PublishLifecycleEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishLifecycleEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PublishLifecycleEventRequest proto.InternalMessageInfo

func (m *PublishLifecycleEventRequest) GetServiceLevel() PublishLifecycleEventRequest_ServiceLevel {
	if m != nil {
		return m.ServiceLevel
	}
	return PublishLifecycleEventRequest_NONINTERACTIVE
}

func (m *PublishLifecycleEventRequest) GetBuildEvent() *OrderedBuildEvent {
	if m != nil {
		return m.BuildEvent
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetStreamTimeout() *duration.Duration {
	if m != nil {
		return m.StreamTimeout
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetNotificationKeywords() []string {
	if m != nil {
		return m.NotificationKeywords
	}
	return nil
}

func (m *PublishLifecycleEventRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

// States which event has been committed. Any failure to commit will cause
// RPC errors, hence not recorded by this proto.
type PublishBuildToolEventStreamResponse struct {
	// The stream that contains this event.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The sequence number of this event that has been committed.
	SequenceNumber       int64    `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublishBuildToolEventStreamResponse) Reset()         { *m = PublishBuildToolEventStreamResponse{} }
func (m *PublishBuildToolEventStreamResponse) String() string { return proto.CompactTextString(m) }
func (*PublishBuildToolEventStreamResponse) ProtoMessage()    {}
func (*PublishBuildToolEventStreamResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_81da11d19c4841eb, []int{1}
}

func (m *PublishBuildToolEventStreamResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishBuildToolEventStreamResponse.Unmarshal(m, b)
}
func (m *PublishBuildToolEventStreamResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishBuildToolEventStreamResponse.Marshal(b, m, deterministic)
}
func (m *PublishBuildToolEventStreamResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishBuildToolEventStreamResponse.Merge(m, src)
}
func (m *PublishBuildToolEventStreamResponse) XXX_Size() int {
	return xxx_messageInfo_PublishBuildToolEventStreamResponse.Size(m)
}
func (m *PublishBuildToolEventStreamResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishBuildToolEventStreamResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PublishBuildToolEventStreamResponse proto.InternalMessageInfo

func (m *PublishBuildToolEventStreamResponse) GetStreamId() *StreamId {
	if m != nil {
		return m.StreamId
	}
	return nil
}

func (m *PublishBuildToolEventStreamResponse) GetSequenceNumber() int64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

// Build event with contextual information about the stream it belongs to and
// its position in that stream.
type OrderedBuildEvent struct {
	// Which build event stream this event belongs to.
	StreamId *StreamId `protobuf:"bytes,1,opt,name=stream_id,json=streamId,proto3" json:"stream_id,omitempty"`
	// The position of this event in the stream. The sequence numbers for a build
	// event stream should be a sequence of consecutive natural numbers starting
	// from one. (1, 2, 3, ...)
	SequenceNumber int64 `protobuf:"varint,2,opt,name=sequence_number,json=sequenceNumber,proto3" json:"sequence_number,omitempty"`
	// The actual event.
	Event                *BuildEvent `protobuf:"bytes,3,opt,name=event,proto3" json:"event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *OrderedBuildEvent) Reset()         { *m = OrderedBuildEvent{} }
func (m *OrderedBuildEvent) String() string { return proto.CompactTextString(m) }
func (*OrderedBuildEvent) ProtoMessage()    {}
func (*OrderedBuildEvent) Descriptor() ([]byte, []int) {
	return fileDescriptor_81da11d19c4841eb, []int{2}
}

func (m *OrderedBuildEvent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OrderedBuildEvent.Unmarshal(m, b)
}
func (m *OrderedBuildEvent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OrderedBuildEvent.Marshal(b, m, deterministic)
}
func (m *OrderedBuildEvent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OrderedBuildEvent.Merge(m, src)
}
func (m *OrderedBuildEvent) XXX_Size() int {
	return xxx_messageInfo_OrderedBuildEvent.Size(m)
}
func (m *OrderedBuildEvent) XXX_DiscardUnknown() {
	xxx_messageInfo_OrderedBuildEvent.DiscardUnknown(m)
}

var xxx_messageInfo_OrderedBuildEvent proto.InternalMessageInfo

func (m *OrderedBuildEvent) GetStreamId() *StreamId {
	if m != nil {
		return m.StreamId
	}
	return nil
}

func (m *OrderedBuildEvent) GetSequenceNumber() int64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

func (m *OrderedBuildEvent) GetEvent() *BuildEvent {
	if m != nil {
		return m.Event
	}
	return nil
}

// Streaming request message for PublishBuildToolEventStream.
type PublishBuildToolEventStreamRequest struct {
	// Required. The build event with position info.
	// New publishing clients should use this field rather than the 3 above.
	OrderedBuildEvent *OrderedBuildEvent `protobuf:"bytes,4,opt,name=ordered_build_event,json=orderedBuildEvent,proto3" json:"ordered_build_event,omitempty"`
	// The keywords to be attached to the notification which notifies the start
	// of a new build event stream. BES only reads this field when sequence_number
	// or ordered_build_event.sequence_number is 1 in this message. If this field
	// is empty, BES will not publish notification messages for this stream.
	NotificationKeywords []string `protobuf:"bytes,5,rep,name=notification_keywords,json=notificationKeywords,proto3" json:"notification_keywords,omitempty"`
	// Required. The project this build is associated with.
	// This should match the project used for the initial call to
	// PublishLifecycleEvent (containing a BuildEnqueued message).
	ProjectId            string   `protobuf:"bytes,6,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PublishBuildToolEventStreamRequest) Reset()         { *m = PublishBuildToolEventStreamRequest{} }
func (m *PublishBuildToolEventStreamRequest) String() string { return proto.CompactTextString(m) }
func (*PublishBuildToolEventStreamRequest) ProtoMessage()    {}
func (*PublishBuildToolEventStreamRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_81da11d19c4841eb, []int{3}
}

func (m *PublishBuildToolEventStreamRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PublishBuildToolEventStreamRequest.Unmarshal(m, b)
}
func (m *PublishBuildToolEventStreamRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PublishBuildToolEventStreamRequest.Marshal(b, m, deterministic)
}
func (m *PublishBuildToolEventStreamRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PublishBuildToolEventStreamRequest.Merge(m, src)
}
func (m *PublishBuildToolEventStreamRequest) XXX_Size() int {
	return xxx_messageInfo_PublishBuildToolEventStreamRequest.Size(m)
}
func (m *PublishBuildToolEventStreamRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PublishBuildToolEventStreamRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PublishBuildToolEventStreamRequest proto.InternalMessageInfo

func (m *PublishBuildToolEventStreamRequest) GetOrderedBuildEvent() *OrderedBuildEvent {
	if m != nil {
		return m.OrderedBuildEvent
	}
	return nil
}

func (m *PublishBuildToolEventStreamRequest) GetNotificationKeywords() []string {
	if m != nil {
		return m.NotificationKeywords
	}
	return nil
}

func (m *PublishBuildToolEventStreamRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.devtools.build.v1.PublishLifecycleEventRequest_ServiceLevel", PublishLifecycleEventRequest_ServiceLevel_name, PublishLifecycleEventRequest_ServiceLevel_value)
	proto.RegisterType((*PublishLifecycleEventRequest)(nil), "google.devtools.build.v1.PublishLifecycleEventRequest")
	proto.RegisterType((*PublishBuildToolEventStreamResponse)(nil), "google.devtools.build.v1.PublishBuildToolEventStreamResponse")
	proto.RegisterType((*OrderedBuildEvent)(nil), "google.devtools.build.v1.OrderedBuildEvent")
	proto.RegisterType((*PublishBuildToolEventStreamRequest)(nil), "google.devtools.build.v1.PublishBuildToolEventStreamRequest")
}

func init() {
	proto.RegisterFile("google/devtools/build/v1/publish_build_event.proto", fileDescriptor_81da11d19c4841eb)
}

var fileDescriptor_81da11d19c4841eb = []byte{
	// 765 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0x3d, 0x6f, 0xd3, 0x4e,
	0x18, 0xff, 0x5f, 0xd2, 0x56, 0xff, 0x5c, 0xda, 0x94, 0x1e, 0x94, 0x86, 0xb4, 0x82, 0xc8, 0x20,
	0x11, 0xb5, 0xc5, 0xa6, 0x09, 0x62, 0x08, 0x54, 0x90, 0x94, 0x48, 0x44, 0x54, 0x69, 0x71, 0x23,
	0x86, 0x2e, 0xae, 0x63, 0x5f, 0x12, 0x53, 0xc7, 0x67, 0x7c, 0xe7, 0x44, 0x15, 0x62, 0x41, 0x62,
	0x66, 0xe0, 0x3b, 0xb0, 0xf0, 0x09, 0xf8, 0x08, 0x30, 0xc2, 0xc6, 0x00, 0x0c, 0x7c, 0x08, 0x46,
	0xe4, 0x3b, 0xa7, 0x31, 0x4d, 0x1d, 0xa4, 0x22, 0xb1, 0xf9, 0x9e, 0xdf, 0xf3, 0xfa, 0x7b, 0x5e,
	0x0c, 0x8b, 0x1d, 0x42, 0x3a, 0x36, 0x56, 0x4c, 0xdc, 0x67, 0x84, 0xd8, 0x54, 0x69, 0xf9, 0x96,
	0x6d, 0x2a, 0xfd, 0x0d, 0xc5, 0xf5, 0x5b, 0xb6, 0x45, 0xbb, 0x1a, 0x17, 0x68, 0xb8, 0x8f, 0x1d,
	0x26, 0xbb, 0x1e, 0x61, 0x04, 0x65, 0x85, 0x8d, 0x3c, 0xb4, 0x91, 0xb9, 0x8a, 0xdc, 0xdf, 0xc8,
	0xad, 0x84, 0xde, 0x74, 0xd7, 0x52, 0x74, 0xc7, 0x21, 0x4c, 0x67, 0x16, 0x71, 0xa8, 0xb0, 0xcb,
	0x2d, 0x45, 0x50, 0xc3, 0xb6, 0x8e, 0x1d, 0xe6, 0xae, 0x44, 0x80, 0xb6, 0x85, 0x6d, 0x53, 0x6b,
	0xe1, 0xae, 0xde, 0xb7, 0x88, 0x17, 0x2a, 0xac, 0xc5, 0x66, 0x19, 0xc9, 0x6e, 0x18, 0xe6, 0x72,
	0xa8, 0xcc, 0x5f, 0x2d, 0xbf, 0xad, 0x98, 0xbe, 0xc7, 0xf3, 0x08, 0xf1, 0xe5, 0x93, 0x38, 0xee,
	0xb9, 0xec, 0x48, 0x80, 0xd2, 0xbb, 0x24, 0x5c, 0xd9, 0x15, 0x95, 0x6f, 0x5b, 0x6d, 0x6c, 0x1c,
	0x19, 0x36, 0xae, 0x05, 0xde, 0x55, 0xfc, 0xcc, 0xc7, 0x94, 0xa1, 0x2e, 0x9c, 0xa3, 0xd8, 0xeb,
	0x5b, 0x06, 0xd6, 0x6c, 0xdc, 0xc7, 0x76, 0x16, 0xe4, 0x41, 0x21, 0x53, 0xdc, 0x92, 0xe3, 0x48,
	0x91, 0x27, 0xb9, 0x93, 0xf7, 0x84, 0xaf, 0xed, 0xc0, 0x95, 0x3a, 0x4b, 0x23, 0x2f, 0xf4, 0x18,
	0xa6, 0x23, 0xd5, 0x65, 0x13, 0x79, 0x50, 0x48, 0x17, 0xd7, 0xe2, 0xe3, 0xec, 0x78, 0x26, 0xf6,
	0xb0, 0x59, 0x0d, 0xde, 0x3c, 0x46, 0x35, 0xf9, 0xbd, 0x92, 0x50, 0x61, 0xeb, 0x58, 0x80, 0xee,
	0xc3, 0x0c, 0x65, 0x1e, 0xd6, 0x7b, 0x1a, 0xb3, 0x7a, 0x98, 0xf8, 0x2c, 0x9b, 0xe4, 0x5e, 0x2f,
	0x0d, 0xbd, 0x0e, 0x39, 0x91, 0x1f, 0x84, 0x9c, 0xa9, 0x73, 0xc2, 0xa0, 0x29, 0xf4, 0x51, 0x09,
	0x2e, 0x3a, 0x84, 0x59, 0x6d, 0xcb, 0xe0, 0xb0, 0x76, 0x88, 0x8f, 0x06, 0xc4, 0x33, 0x69, 0x76,
	0x2a, 0x9f, 0x2c, 0xa4, 0xd4, 0x0b, 0x51, 0xf0, 0x51, 0x88, 0x21, 0x09, 0x42, 0xd7, 0x23, 0x4f,
	0xb1, 0xc1, 0x34, 0xcb, 0xcc, 0xce, 0xe4, 0x41, 0x21, 0x25, 0x72, 0x4b, 0x85, 0xe2, 0xba, 0x29,
	0x95, 0xe0, 0x6c, 0x94, 0x0b, 0x84, 0x60, 0xa6, 0xb1, 0xd3, 0xa8, 0x37, 0x9a, 0x35, 0xb5, 0xb2,
	0xd5, 0xac, 0x3f, 0xa9, 0x9d, 0xfb, 0x0f, 0xcd, 0xc3, 0x74, 0x54, 0x00, 0xa4, 0xd7, 0x00, 0x5e,
	0x0d, 0xe9, 0xe5, 0x65, 0x37, 0x09, 0xb1, 0x79, 0xa5, 0x7b, 0x3c, 0x69, 0x15, 0x53, 0x97, 0x38,
	0x14, 0xa3, 0x7b, 0x30, 0x15, 0xd6, 0x6d, 0x99, 0xbc, 0x61, 0xe9, 0xa2, 0x14, 0x4f, 0xa4, 0x30,
	0xae, 0x9b, 0xea, 0xff, 0x34, 0xfc, 0x42, 0xd7, 0xe1, 0x3c, 0x0d, 0x3a, 0xe6, 0x18, 0x58, 0x73,
	0xfc, 0x5e, 0x0b, 0x7b, 0xbc, 0x1f, 0x49, 0x35, 0x33, 0x14, 0x37, 0xb8, 0x54, 0x7a, 0x0f, 0xe0,
	0xc2, 0x58, 0x23, 0xfe, 0x5d, 0x7c, 0x54, 0x86, 0xd3, 0x62, 0x5c, 0x44, 0x63, 0xaf, 0xc5, 0x47,
	0x19, 0xa5, 0xa7, 0x0a, 0x13, 0xe9, 0x1b, 0x80, 0xd2, 0x44, 0x36, 0xc5, 0x06, 0x1c, 0xc0, 0xf3,
	0x44, 0x54, 0x18, 0xbd, 0x0d, 0xd9, 0xa9, 0x33, 0xce, 0xe7, 0x02, 0x19, 0xa3, 0x2b, 0x76, 0xc8,
	0xa6, 0xff, 0x6e, 0xc8, 0x8a, 0x5f, 0xa7, 0xe0, 0x42, 0xb4, 0x42, 0x11, 0xee, 0x03, 0x80, 0x8b,
	0xa7, 0x2e, 0x29, 0xba, 0x7d, 0xb6, 0xad, 0xce, 0x5d, 0x1c, 0xdb, 0xa7, 0x5a, 0x70, 0x63, 0xa4,
	0x83, 0x97, 0x9f, 0x7f, 0xbc, 0x49, 0xec, 0x4b, 0x25, 0x7e, 0x60, 0x45, 0x5a, 0x54, 0x79, 0x3e,
	0xca, 0x7b, 0x73, 0xf5, 0x85, 0x62, 0xff, 0xe6, 0x92, 0x96, 0xc3, 0x43, 0x5c, 0x06, 0xab, 0xfb,
	0x79, 0x69, 0x39, 0xb0, 0x8c, 0xd7, 0x40, 0x6f, 0x13, 0x70, 0x79, 0x42, 0x0f, 0xd1, 0xdd, 0x3f,
	0x56, 0x34, 0xa1, 0xf5, 0xb9, 0xcd, 0x33, 0x5a, 0x8b, 0x35, 0x94, 0x5e, 0x81, 0x2f, 0x95, 0x5b,
	0xa7, 0xcc, 0xce, 0xfa, 0xa9, 0xdd, 0x5e, 0x1f, 0xd1, 0xc2, 0x69, 0x7b, 0x28, 0xad, 0x4e, 0xa2,
	0x0d, 0x8f, 0xb1, 0xb5, 0x24, 0xa1, 0xc0, 0x60, 0x0c, 0x28, 0x80, 0x9b, 0x20, 0xd7, 0xfc, 0x58,
	0xc9, 0xf3, 0x14, 0x04, 0x2c, 0x4e, 0x4f, 0x58, 0x9e, 0xee, 0x5a, 0x54, 0x36, 0x48, 0xef, 0x53,
	0x45, 0xee, 0x32, 0xe6, 0xd2, 0xb2, 0xa2, 0x0c, 0x06, 0x83, 0x13, 0xa0, 0xa2, 0xfb, 0xac, 0xab,
	0x18, 0x36, 0xf1, 0xcd, 0x1b, 0xae, 0xad, 0xb3, 0x36, 0xf1, 0x7a, 0x55, 0x17, 0xae, 0x18, 0xa4,
	0x17, 0xcb, 0x52, 0x75, 0xb6, 0xaa, 0x1b, 0x87, 0xd8, 0x31, 0x77, 0x83, 0xb9, 0xd8, 0x05, 0xfb,
	0x9b, 0xa1, 0x66, 0x87, 0xd8, 0xba, 0xd3, 0x91, 0x89, 0xd7, 0x51, 0x3a, 0xd8, 0xe1, 0x53, 0xa3,
	0x8c, 0xc2, 0x8d, 0xff, 0xf7, 0xee, 0xf0, 0x8f, 0x9f, 0x00, 0xb4, 0x66, 0xb8, 0x72, 0xe9, 0x57,
	0x00, 0x00, 0x00, 0xff, 0xff, 0xfd, 0x30, 0x00, 0xec, 0xc9, 0x07, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PublishBuildEventClient is the client API for PublishBuildEvent service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PublishBuildEventClient interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). The BuildEnqueued event must be publishd before all other
	// events for the same build ID.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error)
}

type publishBuildEventClient struct {
	cc grpc.ClientConnInterface
}

func NewPublishBuildEventClient(cc grpc.ClientConnInterface) PublishBuildEventClient {
	return &publishBuildEventClient{cc}
}

func (c *publishBuildEventClient) PublishLifecycleEvent(ctx context.Context, in *PublishLifecycleEventRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *publishBuildEventClient) PublishBuildToolEventStream(ctx context.Context, opts ...grpc.CallOption) (PublishBuildEvent_PublishBuildToolEventStreamClient, error) {
	stream, err := c.cc.NewStream(ctx, &_PublishBuildEvent_serviceDesc.Streams[0], "/google.devtools.build.v1.PublishBuildEvent/PublishBuildToolEventStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &publishBuildEventPublishBuildToolEventStreamClient{stream}
	return x, nil
}

type PublishBuildEvent_PublishBuildToolEventStreamClient interface {
	Send(*PublishBuildToolEventStreamRequest) error
	Recv() (*PublishBuildToolEventStreamResponse, error)
	grpc.ClientStream
}

type publishBuildEventPublishBuildToolEventStreamClient struct {
	grpc.ClientStream
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Send(m *PublishBuildToolEventStreamRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamClient) Recv() (*PublishBuildToolEventStreamResponse, error) {
	m := new(PublishBuildToolEventStreamResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// PublishBuildEventServer is the server API for PublishBuildEvent service.
type PublishBuildEventServer interface {
	// Publish a build event stating the new state of a build (typically from the
	// build queue). The BuildEnqueued event must be publishd before all other
	// events for the same build ID.
	//
	// The backend will persist the event and deliver it to registered frontend
	// jobs immediately without batching.
	//
	// The commit status of the request is reported by the RPC's util_status()
	// function. The error code is the canoncial error code defined in
	// //util/task/codes.proto.
	PublishLifecycleEvent(context.Context, *PublishLifecycleEventRequest) (*empty.Empty, error)
	// Publish build tool events belonging to the same stream to a backend job
	// using bidirectional streaming.
	PublishBuildToolEventStream(PublishBuildEvent_PublishBuildToolEventStreamServer) error
}

// UnimplementedPublishBuildEventServer can be embedded to have forward compatible implementations.
type UnimplementedPublishBuildEventServer struct {
}

func (*UnimplementedPublishBuildEventServer) PublishLifecycleEvent(ctx context.Context, req *PublishLifecycleEventRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PublishLifecycleEvent not implemented")
}
func (*UnimplementedPublishBuildEventServer) PublishBuildToolEventStream(srv PublishBuildEvent_PublishBuildToolEventStreamServer) error {
	return status.Errorf(codes.Unimplemented, "method PublishBuildToolEventStream not implemented")
}

func RegisterPublishBuildEventServer(s *grpc.Server, srv PublishBuildEventServer) {
	s.RegisterService(&_PublishBuildEvent_serviceDesc, srv)
}

func _PublishBuildEvent_PublishLifecycleEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PublishLifecycleEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.build.v1.PublishBuildEvent/PublishLifecycleEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PublishBuildEventServer).PublishLifecycleEvent(ctx, req.(*PublishLifecycleEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PublishBuildEvent_PublishBuildToolEventStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PublishBuildEventServer).PublishBuildToolEventStream(&publishBuildEventPublishBuildToolEventStreamServer{stream})
}

type PublishBuildEvent_PublishBuildToolEventStreamServer interface {
	Send(*PublishBuildToolEventStreamResponse) error
	Recv() (*PublishBuildToolEventStreamRequest, error)
	grpc.ServerStream
}

type publishBuildEventPublishBuildToolEventStreamServer struct {
	grpc.ServerStream
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Send(m *PublishBuildToolEventStreamResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *publishBuildEventPublishBuildToolEventStreamServer) Recv() (*PublishBuildToolEventStreamRequest, error) {
	m := new(PublishBuildToolEventStreamRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _PublishBuildEvent_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.build.v1.PublishBuildEvent",
	HandlerType: (*PublishBuildEventServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "PublishLifecycleEvent",
			Handler:    _PublishBuildEvent_PublishLifecycleEvent_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "PublishBuildToolEventStream",
			Handler:       _PublishBuildEvent_PublishBuildToolEventStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/devtools/build/v1/publish_build_event.proto",
}
