// Code generated by protoc-gen-go.
// source: google.golang.org/appengine/internal/taskqueue/taskqueue_service.proto
// DO NOT EDIT!

/*
Package taskqueue is a generated protocol buffer package.

It is generated from these files:
	google.golang.org/appengine/internal/taskqueue/taskqueue_service.proto

It has these top-level messages:
	TaskQueueServiceError
	TaskPayload
	TaskQueueRetryParameters
	TaskQueueAcl
	TaskQueueHttpHeader
	TaskQueueMode
	TaskQueueAddRequest
	TaskQueueAddResponse
	TaskQueueBulkAddRequest
	TaskQueueBulkAddResponse
	TaskQueueDeleteRequest
	TaskQueueDeleteResponse
	TaskQueueForceRunRequest
	TaskQueueForceRunResponse
	TaskQueueUpdateQueueRequest
	TaskQueueUpdateQueueResponse
	TaskQueueFetchQueuesRequest
	TaskQueueFetchQueuesResponse
	TaskQueueFetchQueueStatsRequest
	TaskQueueScannerQueueInfo
	TaskQueueFetchQueueStatsResponse
	TaskQueuePauseQueueRequest
	TaskQueuePauseQueueResponse
	TaskQueuePurgeQueueRequest
	TaskQueuePurgeQueueResponse
	TaskQueueDeleteQueueRequest
	TaskQueueDeleteQueueResponse
	TaskQueueDeleteGroupRequest
	TaskQueueDeleteGroupResponse
	TaskQueueQueryTasksRequest
	TaskQueueQueryTasksResponse
	TaskQueueFetchTaskRequest
	TaskQueueFetchTaskResponse
	TaskQueueUpdateStorageLimitRequest
	TaskQueueUpdateStorageLimitResponse
	TaskQueueQueryAndOwnTasksRequest
	TaskQueueQueryAndOwnTasksResponse
	TaskQueueModifyTaskLeaseRequest
	TaskQueueModifyTaskLeaseResponse
*/
package taskqueue

import proto "github.com/golang/protobuf/proto"
import math "math"
import appengine "google.golang.org/appengine/internal/datastore"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = math.Inf

type TaskQueueServiceError_ErrorCode int32

const (
	TaskQueueServiceError_OK                              TaskQueueServiceError_ErrorCode = 0
	TaskQueueServiceError_UNKNOWN_QUEUE                   TaskQueueServiceError_ErrorCode = 1
	TaskQueueServiceError_TRANSIENT_ERROR                 TaskQueueServiceError_ErrorCode = 2
	TaskQueueServiceError_INTERNAL_ERROR                  TaskQueueServiceError_ErrorCode = 3
	TaskQueueServiceError_TASK_TOO_LARGE                  TaskQueueServiceError_ErrorCode = 4
	TaskQueueServiceError_INVALID_TASK_NAME               TaskQueueServiceError_ErrorCode = 5
	TaskQueueServiceError_INVALID_QUEUE_NAME              TaskQueueServiceError_ErrorCode = 6
	TaskQueueServiceError_INVALID_URL                     TaskQueueServiceError_ErrorCode = 7
	TaskQueueServiceError_INVALID_QUEUE_RATE              TaskQueueServiceError_ErrorCode = 8
	TaskQueueServiceError_PERMISSION_DENIED               TaskQueueServiceError_ErrorCode = 9
	TaskQueueServiceError_TASK_ALREADY_EXISTS             TaskQueueServiceError_ErrorCode = 10
	TaskQueueServiceError_TOMBSTONED_TASK                 TaskQueueServiceError_ErrorCode = 11
	TaskQueueServiceError_INVALID_ETA                     TaskQueueServiceError_ErrorCode = 12
	TaskQueueServiceError_INVALID_REQUEST                 TaskQueueServiceError_ErrorCode = 13
	TaskQueueServiceError_UNKNOWN_TASK                    TaskQueueServiceError_ErrorCode = 14
	TaskQueueServiceError_TOMBSTONED_QUEUE                TaskQueueServiceError_ErrorCode = 15
	TaskQueueServiceError_DUPLICATE_TASK_NAME             TaskQueueServiceError_ErrorCode = 16
	TaskQueueServiceError_SKIPPED                         TaskQueueServiceError_ErrorCode = 17
	TaskQueueServiceError_TOO_MANY_TASKS                  TaskQueueServiceError_ErrorCode = 18
	TaskQueueServiceError_INVALID_PAYLOAD                 TaskQueueServiceError_ErrorCode = 19
	TaskQueueServiceError_INVALID_RETRY_PARAMETERS        TaskQueueServiceError_ErrorCode = 20
	TaskQueueServiceError_INVALID_QUEUE_MODE              TaskQueueServiceError_ErrorCode = 21
	TaskQueueServiceError_ACL_LOOKUP_ERROR                TaskQueueServiceError_ErrorCode = 22
	TaskQueueServiceError_TRANSACTIONAL_REQUEST_TOO_LARGE TaskQueueServiceError_ErrorCode = 23
	TaskQueueServiceError_INCORRECT_CREATOR_NAME          TaskQueueServiceError_ErrorCode = 24
	TaskQueueServiceError_TASK_LEASE_EXPIRED              TaskQueueServiceError_ErrorCode = 25
	TaskQueueServiceError_QUEUE_PAUSED                    TaskQueueServiceError_ErrorCode = 26
	TaskQueueServiceError_INVALID_TAG                     TaskQueueServiceError_ErrorCode = 27
	// Reserved range for the Datastore error codes.
	// Original Datastore error code is shifted by DATASTORE_ERROR offset.
	TaskQueueServiceError_DATASTORE_ERROR TaskQueueServiceError_ErrorCode = 10000
)

var TaskQueueServiceError_ErrorCode_name = map[int32]string{
	0:     "OK",
	1:     "UNKNOWN_QUEUE",
	2:     "TRANSIENT_ERROR",
	3:     "INTERNAL_ERROR",
	4:     "TASK_TOO_LARGE",
	5:     "INVALID_TASK_NAME",
	6:     "INVALID_QUEUE_NAME",
	7:     "INVALID_URL",
	8:     "INVALID_QUEUE_RATE",
	9:     "PERMISSION_DENIED",
	10:    "TASK_ALREADY_EXISTS",
	11:    "TOMBSTONED_TASK",
	12:    "INVALID_ETA",
	13:    "INVALID_REQUEST",
	14:    "UNKNOWN_TASK",
	15:    "TOMBSTONED_QUEUE",
	16:    "DUPLICATE_TASK_NAME",
	17:    "SKIPPED",
	18:    "TOO_MANY_TASKS",
	19:    "INVALID_PAYLOAD",
	20:    "INVALID_RETRY_PARAMETERS",
	21:    "INVALID_QUEUE_MODE",
	22:    "ACL_LOOKUP_ERROR",
	23:    "TRANSACTIONAL_REQUEST_TOO_LARGE",
	24:    "INCORRECT_CREATOR_NAME",
	25:    "TASK_LEASE_EXPIRED",
	26:    "QUEUE_PAUSED",
	27:    "INVALID_TAG",
	10000: "DATASTORE_ERROR",
}
var TaskQueueServiceError_ErrorCode_value = map[string]int32{
	"OK":                              0,
	"UNKNOWN_QUEUE":                   1,
	"TRANSIENT_ERROR":                 2,
	"INTERNAL_ERROR":                  3,
	"TASK_TOO_LARGE":                  4,
	"INVALID_TASK_NAME":               5,
	"INVALID_QUEUE_NAME":              6,
	"INVALID_URL":                     7,
	"INVALID_QUEUE_RATE":              8,
	"PERMISSION_DENIED":               9,
	"TASK_ALREADY_EXISTS":             10,
	"TOMBSTONED_TASK":                 11,
	"INVALID_ETA":                     12,
	"INVALID_REQUEST":                 13,
	"UNKNOWN_TASK":                    14,
	"TOMBSTONED_QUEUE":                15,
	"DUPLICATE_TASK_NAME":             16,
	"SKIPPED":                         17,
	"TOO_MANY_TASKS":                  18,
	"INVALID_PAYLOAD":                 19,
	"INVALID_RETRY_PARAMETERS":        20,
	"INVALID_QUEUE_MODE":              21,
	"ACL_LOOKUP_ERROR":                22,
	"TRANSACTIONAL_REQUEST_TOO_LARGE": 23,
	"INCORRECT_CREATOR_NAME":          24,
	"TASK_LEASE_EXPIRED":              25,
	"QUEUE_PAUSED":                    26,
	"INVALID_TAG":                     27,
	"DATASTORE_ERROR":                 10000,
}

func (x TaskQueueServiceError_ErrorCode) Enum() *TaskQueueServiceError_ErrorCode {
	p := new(TaskQueueServiceError_ErrorCode)
	*p = x
	return p
}
func (x TaskQueueServiceError_ErrorCode) String() string {
	return proto.EnumName(TaskQueueServiceError_ErrorCode_name, int32(x))
}
func (x *TaskQueueServiceError_ErrorCode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskQueueServiceError_ErrorCode_value, data, "TaskQueueServiceError_ErrorCode")
	if err != nil {
		return err
	}
	*x = TaskQueueServiceError_ErrorCode(value)
	return nil
}

type TaskQueueMode_Mode int32

const (
	TaskQueueMode_PUSH TaskQueueMode_Mode = 0
	TaskQueueMode_PULL TaskQueueMode_Mode = 1
)

var TaskQueueMode_Mode_name = map[int32]string{
	0: "PUSH",
	1: "PULL",
}
var TaskQueueMode_Mode_value = map[string]int32{
	"PUSH": 0,
	"PULL": 1,
}

func (x TaskQueueMode_Mode) Enum() *TaskQueueMode_Mode {
	p := new(TaskQueueMode_Mode)
	*p = x
	return p
}
func (x TaskQueueMode_Mode) String() string {
	return proto.EnumName(TaskQueueMode_Mode_name, int32(x))
}
func (x *TaskQueueMode_Mode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskQueueMode_Mode_value, data, "TaskQueueMode_Mode")
	if err != nil {
		return err
	}
	*x = TaskQueueMode_Mode(value)
	return nil
}

type TaskQueueAddRequest_RequestMethod int32

const (
	TaskQueueAddRequest_GET    TaskQueueAddRequest_RequestMethod = 1
	TaskQueueAddRequest_POST   TaskQueueAddRequest_RequestMethod = 2
	TaskQueueAddRequest_HEAD   TaskQueueAddRequest_RequestMethod = 3
	TaskQueueAddRequest_PUT    TaskQueueAddRequest_RequestMethod = 4
	TaskQueueAddRequest_DELETE TaskQueueAddRequest_RequestMethod = 5
)

var TaskQueueAddRequest_RequestMethod_name = map[int32]string{
	1: "GET",
	2: "POST",
	3: "HEAD",
	4: "PUT",
	5: "DELETE",
}
var TaskQueueAddRequest_RequestMethod_value = map[string]int32{
	"GET":    1,
	"POST":   2,
	"HEAD":   3,
	"PUT":    4,
	"DELETE": 5,
}

func (x TaskQueueAddRequest_RequestMethod) Enum() *TaskQueueAddRequest_RequestMethod {
	p := new(TaskQueueAddRequest_RequestMethod)
	*p = x
	return p
}
func (x TaskQueueAddRequest_RequestMethod) String() string {
	return proto.EnumName(TaskQueueAddRequest_RequestMethod_name, int32(x))
}
func (x *TaskQueueAddRequest_RequestMethod) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskQueueAddRequest_RequestMethod_value, data, "TaskQueueAddRequest_RequestMethod")
	if err != nil {
		return err
	}
	*x = TaskQueueAddRequest_RequestMethod(value)
	return nil
}

type TaskQueueQueryTasksResponse_Task_RequestMethod int32

const (
	TaskQueueQueryTasksResponse_Task_GET    TaskQueueQueryTasksResponse_Task_RequestMethod = 1
	TaskQueueQueryTasksResponse_Task_POST   TaskQueueQueryTasksResponse_Task_RequestMethod = 2
	TaskQueueQueryTasksResponse_Task_HEAD   TaskQueueQueryTasksResponse_Task_RequestMethod = 3
	TaskQueueQueryTasksResponse_Task_PUT    TaskQueueQueryTasksResponse_Task_RequestMethod = 4
	TaskQueueQueryTasksResponse_Task_DELETE TaskQueueQueryTasksResponse_Task_RequestMethod = 5
)

var TaskQueueQueryTasksResponse_Task_RequestMethod_name = map[int32]string{
	1: "GET",
	2: "POST",
	3: "HEAD",
	4: "PUT",
	5: "DELETE",
}
var TaskQueueQueryTasksResponse_Task_RequestMethod_value = map[string]int32{
	"GET":    1,
	"POST":   2,
	"HEAD":   3,
	"PUT":    4,
	"DELETE": 5,
}

func (x TaskQueueQueryTasksResponse_Task_RequestMethod) Enum() *TaskQueueQueryTasksResponse_Task_RequestMethod {
	p := new(TaskQueueQueryTasksResponse_Task_RequestMethod)
	*p = x
	return p
}
func (x TaskQueueQueryTasksResponse_Task_RequestMethod) String() string {
	return proto.EnumName(TaskQueueQueryTasksResponse_Task_RequestMethod_name, int32(x))
}
func (x *TaskQueueQueryTasksResponse_Task_RequestMethod) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TaskQueueQueryTasksResponse_Task_RequestMethod_value, data, "TaskQueueQueryTasksResponse_Task_RequestMethod")
	if err != nil {
		return err
	}
	*x = TaskQueueQueryTasksResponse_Task_RequestMethod(value)
	return nil
}

type TaskQueueServiceError struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueServiceError) Reset()         { *m = TaskQueueServiceError{} }
func (m *TaskQueueServiceError) String() string { return proto.CompactTextString(m) }
func (*TaskQueueServiceError) ProtoMessage()    {}

type TaskPayload struct {
	XXX_extensions   map[int32]proto.Extension `json:"-"`
	XXX_unrecognized []byte                    `json:"-"`
}

func (m *TaskPayload) Reset()         { *m = TaskPayload{} }
func (m *TaskPayload) String() string { return proto.CompactTextString(m) }
func (*TaskPayload) ProtoMessage()    {}

func (m *TaskPayload) Marshal() ([]byte, error) {
	return proto.MarshalMessageSet(m.ExtensionMap())
}
func (m *TaskPayload) Unmarshal(buf []byte) error {
	return proto.UnmarshalMessageSet(buf, m.ExtensionMap())
}
func (m *TaskPayload) MarshalJSON() ([]byte, error) {
	return proto.MarshalMessageSetJSON(m.XXX_extensions)
}
func (m *TaskPayload) UnmarshalJSON(buf []byte) error {
	return proto.UnmarshalMessageSetJSON(buf, m.XXX_extensions)
}

// ensure TaskPayload satisfies proto.Marshaler and proto.Unmarshaler
var _ proto.Marshaler = (*TaskPayload)(nil)
var _ proto.Unmarshaler = (*TaskPayload)(nil)

var extRange_TaskPayload = []proto.ExtensionRange{
	{10, 2147483646},
}

func (*TaskPayload) ExtensionRangeArray() []proto.ExtensionRange {
	return extRange_TaskPayload
}
func (m *TaskPayload) ExtensionMap() map[int32]proto.Extension {
	if m.XXX_extensions == nil {
		m.XXX_extensions = make(map[int32]proto.Extension)
	}
	return m.XXX_extensions
}

type TaskQueueRetryParameters struct {
	RetryLimit       *int32   `protobuf:"varint,1,opt,name=retry_limit" json:"retry_limit,omitempty"`
	AgeLimitSec      *int64   `protobuf:"varint,2,opt,name=age_limit_sec" json:"age_limit_sec,omitempty"`
	MinBackoffSec    *float64 `protobuf:"fixed64,3,opt,name=min_backoff_sec,def=0.1" json:"min_backoff_sec,omitempty"`
	MaxBackoffSec    *float64 `protobuf:"fixed64,4,opt,name=max_backoff_sec,def=3600" json:"max_backoff_sec,omitempty"`
	MaxDoublings     *int32   `protobuf:"varint,5,opt,name=max_doublings,def=16" json:"max_doublings,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueRetryParameters) Reset()         { *m = TaskQueueRetryParameters{} }
func (m *TaskQueueRetryParameters) String() string { return proto.CompactTextString(m) }
func (*TaskQueueRetryParameters) ProtoMessage()    {}

const Default_TaskQueueRetryParameters_MinBackoffSec float64 = 0.1
const Default_TaskQueueRetryParameters_MaxBackoffSec float64 = 3600
const Default_TaskQueueRetryParameters_MaxDoublings int32 = 16

func (m *TaskQueueRetryParameters) GetRetryLimit() int32 {
	if m != nil && m.RetryLimit != nil {
		return *m.RetryLimit
	}
	return 0
}

func (m *TaskQueueRetryParameters) GetAgeLimitSec() int64 {
	if m != nil && m.AgeLimitSec != nil {
		return *m.AgeLimitSec
	}
	return 0
}

func (m *TaskQueueRetryParameters) GetMinBackoffSec() float64 {
	if m != nil && m.MinBackoffSec != nil {
		return *m.MinBackoffSec
	}
	return Default_TaskQueueRetryParameters_MinBackoffSec
}

func (m *TaskQueueRetryParameters) GetMaxBackoffSec() float64 {
	if m != nil && m.MaxBackoffSec != nil {
		return *m.MaxBackoffSec
	}
	return Default_TaskQueueRetryParameters_MaxBackoffSec
}

func (m *TaskQueueRetryParameters) GetMaxDoublings() int32 {
	if m != nil && m.MaxDoublings != nil {
		return *m.MaxDoublings
	}
	return Default_TaskQueueRetryParameters_MaxDoublings
}

type TaskQueueAcl struct {
	UserEmail        [][]byte `protobuf:"bytes,1,rep,name=user_email" json:"user_email,omitempty"`
	WriterEmail      [][]byte `protobuf:"bytes,2,rep,name=writer_email" json:"writer_email,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueAcl) Reset()         { *m = TaskQueueAcl{} }
func (m *TaskQueueAcl) String() string { return proto.CompactTextString(m) }
func (*TaskQueueAcl) ProtoMessage()    {}

func (m *TaskQueueAcl) GetUserEmail() [][]byte {
	if m != nil {
		return m.UserEmail
	}
	return nil
}

func (m *TaskQueueAcl) GetWriterEmail() [][]byte {
	if m != nil {
		return m.WriterEmail
	}
	return nil
}

type TaskQueueHttpHeader struct {
	Key              []byte `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Value            []byte `protobuf:"bytes,2,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueHttpHeader) Reset()         { *m = TaskQueueHttpHeader{} }
func (m *TaskQueueHttpHeader) String() string { return proto.CompactTextString(m) }
func (*TaskQueueHttpHeader) ProtoMessage()    {}

func (m *TaskQueueHttpHeader) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TaskQueueHttpHeader) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type TaskQueueMode struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueMode) Reset()         { *m = TaskQueueMode{} }
func (m *TaskQueueMode) String() string { return proto.CompactTextString(m) }
func (*TaskQueueMode) ProtoMessage()    {}

type TaskQueueAddRequest struct {
	QueueName        []byte                             `protobuf:"bytes,1,req,name=queue_name" json:"queue_name,omitempty"`
	TaskName         []byte                             `protobuf:"bytes,2,req,name=task_name" json:"task_name,omitempty"`
	EtaUsec          *int64                             `protobuf:"varint,3,req,name=eta_usec" json:"eta_usec,omitempty"`
	Method           *TaskQueueAddRequest_RequestMethod `protobuf:"varint,5,opt,name=method,enum=appengine.TaskQueueAddRequest_RequestMethod,def=2" json:"method,omitempty"`
	Url              []byte                             `protobuf:"bytes,4,opt,name=url" json:"url,omitempty"`
	Header           []*TaskQueueAddRequest_Header      `protobuf:"group,6,rep" json:"header,omitempty"`
	Body             []byte                             `protobuf:"bytes,9,opt,name=body" json:"body,omitempty"`
	Transaction      *appengine.Transaction             `protobuf:"bytes,10,opt,name=transaction" json:"transaction,omitempty"`
	AppId            []byte                             `protobuf:"bytes,11,opt,name=app_id" json:"app_id,omitempty"`
	Crontimetable    *TaskQueueAddRequest_CronTimetable `protobuf:"group,12,opt,name=CronTimetable" json:"crontimetable,omitempty"`
	Description      []byte                             `protobuf:"bytes,15,opt,name=description" json:"description,omitempty"`
	Payload          *TaskPayload                       `protobuf:"bytes,16,opt,name=payload" json:"payload,omitempty"`
	RetryParameters  *TaskQueueRetryParameters          `protobuf:"bytes,17,opt,name=retry_parameters" json:"retry_parameters,omitempty"`
	Mode             *TaskQueueMode_Mode                `protobuf:"varint,18,opt,name=mode,enum=appengine.TaskQueueMode_Mode,def=0" json:"mode,omitempty"`
	Tag              []byte                             `protobuf:"bytes,19,opt,name=tag" json:"tag,omitempty"`
	XXX_unrecognized []byte                             `json:"-"`
}

func (m *TaskQueueAddRequest) Reset()         { *m = TaskQueueAddRequest{} }
func (m *TaskQueueAddRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueAddRequest) ProtoMessage()    {}

const Default_TaskQueueAddRequest_Method TaskQueueAddRequest_RequestMethod = TaskQueueAddRequest_POST
const Default_TaskQueueAddRequest_Mode TaskQueueMode_Mode = TaskQueueMode_PUSH

func (m *TaskQueueAddRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueAddRequest) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

func (m *TaskQueueAddRequest) GetEtaUsec() int64 {
	if m != nil && m.EtaUsec != nil {
		return *m.EtaUsec
	}
	return 0
}

func (m *TaskQueueAddRequest) GetMethod() TaskQueueAddRequest_RequestMethod {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return Default_TaskQueueAddRequest_Method
}

func (m *TaskQueueAddRequest) GetUrl() []byte {
	if m != nil {
		return m.Url
	}
	return nil
}

func (m *TaskQueueAddRequest) GetHeader() []*TaskQueueAddRequest_Header {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *TaskQueueAddRequest) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *TaskQueueAddRequest) GetTransaction() *appengine.Transaction {
	if m != nil {
		return m.Transaction
	}
	return nil
}

func (m *TaskQueueAddRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueAddRequest) GetCrontimetable() *TaskQueueAddRequest_CronTimetable {
	if m != nil {
		return m.Crontimetable
	}
	return nil
}

func (m *TaskQueueAddRequest) GetDescription() []byte {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *TaskQueueAddRequest) GetPayload() *TaskPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *TaskQueueAddRequest) GetRetryParameters() *TaskQueueRetryParameters {
	if m != nil {
		return m.RetryParameters
	}
	return nil
}

func (m *TaskQueueAddRequest) GetMode() TaskQueueMode_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_TaskQueueAddRequest_Mode
}

func (m *TaskQueueAddRequest) GetTag() []byte {
	if m != nil {
		return m.Tag
	}
	return nil
}

type TaskQueueAddRequest_Header struct {
	Key              []byte `protobuf:"bytes,7,req,name=key" json:"key,omitempty"`
	Value            []byte `protobuf:"bytes,8,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueAddRequest_Header) Reset()         { *m = TaskQueueAddRequest_Header{} }
func (m *TaskQueueAddRequest_Header) String() string { return proto.CompactTextString(m) }
func (*TaskQueueAddRequest_Header) ProtoMessage()    {}

func (m *TaskQueueAddRequest_Header) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TaskQueueAddRequest_Header) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type TaskQueueAddRequest_CronTimetable struct {
	Schedule         []byte `protobuf:"bytes,13,req,name=schedule" json:"schedule,omitempty"`
	Timezone         []byte `protobuf:"bytes,14,req,name=timezone" json:"timezone,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueAddRequest_CronTimetable) Reset()         { *m = TaskQueueAddRequest_CronTimetable{} }
func (m *TaskQueueAddRequest_CronTimetable) String() string { return proto.CompactTextString(m) }
func (*TaskQueueAddRequest_CronTimetable) ProtoMessage()    {}

func (m *TaskQueueAddRequest_CronTimetable) GetSchedule() []byte {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *TaskQueueAddRequest_CronTimetable) GetTimezone() []byte {
	if m != nil {
		return m.Timezone
	}
	return nil
}

type TaskQueueAddResponse struct {
	ChosenTaskName   []byte `protobuf:"bytes,1,opt,name=chosen_task_name" json:"chosen_task_name,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueAddResponse) Reset()         { *m = TaskQueueAddResponse{} }
func (m *TaskQueueAddResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueAddResponse) ProtoMessage()    {}

func (m *TaskQueueAddResponse) GetChosenTaskName() []byte {
	if m != nil {
		return m.ChosenTaskName
	}
	return nil
}

type TaskQueueBulkAddRequest struct {
	AddRequest       []*TaskQueueAddRequest `protobuf:"bytes,1,rep,name=add_request" json:"add_request,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TaskQueueBulkAddRequest) Reset()         { *m = TaskQueueBulkAddRequest{} }
func (m *TaskQueueBulkAddRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueBulkAddRequest) ProtoMessage()    {}

func (m *TaskQueueBulkAddRequest) GetAddRequest() []*TaskQueueAddRequest {
	if m != nil {
		return m.AddRequest
	}
	return nil
}

type TaskQueueBulkAddResponse struct {
	Taskresult       []*TaskQueueBulkAddResponse_TaskResult `protobuf:"group,1,rep,name=TaskResult" json:"taskresult,omitempty"`
	XXX_unrecognized []byte                                 `json:"-"`
}

func (m *TaskQueueBulkAddResponse) Reset()         { *m = TaskQueueBulkAddResponse{} }
func (m *TaskQueueBulkAddResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueBulkAddResponse) ProtoMessage()    {}

func (m *TaskQueueBulkAddResponse) GetTaskresult() []*TaskQueueBulkAddResponse_TaskResult {
	if m != nil {
		return m.Taskresult
	}
	return nil
}

type TaskQueueBulkAddResponse_TaskResult struct {
	Result           *TaskQueueServiceError_ErrorCode `protobuf:"varint,2,req,name=result,enum=appengine.TaskQueueServiceError_ErrorCode" json:"result,omitempty"`
	ChosenTaskName   []byte                           `protobuf:"bytes,3,opt,name=chosen_task_name" json:"chosen_task_name,omitempty"`
	XXX_unrecognized []byte                           `json:"-"`
}

func (m *TaskQueueBulkAddResponse_TaskResult) Reset()         { *m = TaskQueueBulkAddResponse_TaskResult{} }
func (m *TaskQueueBulkAddResponse_TaskResult) String() string { return proto.CompactTextString(m) }
func (*TaskQueueBulkAddResponse_TaskResult) ProtoMessage()    {}

func (m *TaskQueueBulkAddResponse_TaskResult) GetResult() TaskQueueServiceError_ErrorCode {
	if m != nil && m.Result != nil {
		return *m.Result
	}
	return TaskQueueServiceError_OK
}

func (m *TaskQueueBulkAddResponse_TaskResult) GetChosenTaskName() []byte {
	if m != nil {
		return m.ChosenTaskName
	}
	return nil
}

type TaskQueueDeleteRequest struct {
	QueueName        []byte   `protobuf:"bytes,1,req,name=queue_name" json:"queue_name,omitempty"`
	TaskName         [][]byte `protobuf:"bytes,2,rep,name=task_name" json:"task_name,omitempty"`
	AppId            []byte   `protobuf:"bytes,3,opt,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueDeleteRequest) Reset()         { *m = TaskQueueDeleteRequest{} }
func (m *TaskQueueDeleteRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteRequest) ProtoMessage()    {}

func (m *TaskQueueDeleteRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueDeleteRequest) GetTaskName() [][]byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

func (m *TaskQueueDeleteRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type TaskQueueDeleteResponse struct {
	Result           []TaskQueueServiceError_ErrorCode `protobuf:"varint,3,rep,name=result,enum=appengine.TaskQueueServiceError_ErrorCode" json:"result,omitempty"`
	XXX_unrecognized []byte                            `json:"-"`
}

func (m *TaskQueueDeleteResponse) Reset()         { *m = TaskQueueDeleteResponse{} }
func (m *TaskQueueDeleteResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteResponse) ProtoMessage()    {}

func (m *TaskQueueDeleteResponse) GetResult() []TaskQueueServiceError_ErrorCode {
	if m != nil {
		return m.Result
	}
	return nil
}

type TaskQueueForceRunRequest struct {
	AppId            []byte `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	TaskName         []byte `protobuf:"bytes,3,req,name=task_name" json:"task_name,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueForceRunRequest) Reset()         { *m = TaskQueueForceRunRequest{} }
func (m *TaskQueueForceRunRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueForceRunRequest) ProtoMessage()    {}

func (m *TaskQueueForceRunRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueForceRunRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueForceRunRequest) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

type TaskQueueForceRunResponse struct {
	Result           *TaskQueueServiceError_ErrorCode `protobuf:"varint,3,req,name=result,enum=appengine.TaskQueueServiceError_ErrorCode" json:"result,omitempty"`
	XXX_unrecognized []byte                           `json:"-"`
}

func (m *TaskQueueForceRunResponse) Reset()         { *m = TaskQueueForceRunResponse{} }
func (m *TaskQueueForceRunResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueForceRunResponse) ProtoMessage()    {}

func (m *TaskQueueForceRunResponse) GetResult() TaskQueueServiceError_ErrorCode {
	if m != nil && m.Result != nil {
		return *m.Result
	}
	return TaskQueueServiceError_OK
}

type TaskQueueUpdateQueueRequest struct {
	AppId                 []byte                    `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName             []byte                    `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	BucketRefillPerSecond *float64                  `protobuf:"fixed64,3,req,name=bucket_refill_per_second" json:"bucket_refill_per_second,omitempty"`
	BucketCapacity        *int32                    `protobuf:"varint,4,req,name=bucket_capacity" json:"bucket_capacity,omitempty"`
	UserSpecifiedRate     *string                   `protobuf:"bytes,5,opt,name=user_specified_rate" json:"user_specified_rate,omitempty"`
	RetryParameters       *TaskQueueRetryParameters `protobuf:"bytes,6,opt,name=retry_parameters" json:"retry_parameters,omitempty"`
	MaxConcurrentRequests *int32                    `protobuf:"varint,7,opt,name=max_concurrent_requests" json:"max_concurrent_requests,omitempty"`
	Mode                  *TaskQueueMode_Mode       `protobuf:"varint,8,opt,name=mode,enum=appengine.TaskQueueMode_Mode,def=0" json:"mode,omitempty"`
	Acl                   *TaskQueueAcl             `protobuf:"bytes,9,opt,name=acl" json:"acl,omitempty"`
	HeaderOverride        []*TaskQueueHttpHeader    `protobuf:"bytes,10,rep,name=header_override" json:"header_override,omitempty"`
	XXX_unrecognized      []byte                    `json:"-"`
}

func (m *TaskQueueUpdateQueueRequest) Reset()         { *m = TaskQueueUpdateQueueRequest{} }
func (m *TaskQueueUpdateQueueRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueUpdateQueueRequest) ProtoMessage()    {}

const Default_TaskQueueUpdateQueueRequest_Mode TaskQueueMode_Mode = TaskQueueMode_PUSH

func (m *TaskQueueUpdateQueueRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueUpdateQueueRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueUpdateQueueRequest) GetBucketRefillPerSecond() float64 {
	if m != nil && m.BucketRefillPerSecond != nil {
		return *m.BucketRefillPerSecond
	}
	return 0
}

func (m *TaskQueueUpdateQueueRequest) GetBucketCapacity() int32 {
	if m != nil && m.BucketCapacity != nil {
		return *m.BucketCapacity
	}
	return 0
}

func (m *TaskQueueUpdateQueueRequest) GetUserSpecifiedRate() string {
	if m != nil && m.UserSpecifiedRate != nil {
		return *m.UserSpecifiedRate
	}
	return ""
}

func (m *TaskQueueUpdateQueueRequest) GetRetryParameters() *TaskQueueRetryParameters {
	if m != nil {
		return m.RetryParameters
	}
	return nil
}

func (m *TaskQueueUpdateQueueRequest) GetMaxConcurrentRequests() int32 {
	if m != nil && m.MaxConcurrentRequests != nil {
		return *m.MaxConcurrentRequests
	}
	return 0
}

func (m *TaskQueueUpdateQueueRequest) GetMode() TaskQueueMode_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_TaskQueueUpdateQueueRequest_Mode
}

func (m *TaskQueueUpdateQueueRequest) GetAcl() *TaskQueueAcl {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *TaskQueueUpdateQueueRequest) GetHeaderOverride() []*TaskQueueHttpHeader {
	if m != nil {
		return m.HeaderOverride
	}
	return nil
}

type TaskQueueUpdateQueueResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueUpdateQueueResponse) Reset()         { *m = TaskQueueUpdateQueueResponse{} }
func (m *TaskQueueUpdateQueueResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueUpdateQueueResponse) ProtoMessage()    {}

type TaskQueueFetchQueuesRequest struct {
	AppId            []byte `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	MaxRows          *int32 `protobuf:"varint,2,req,name=max_rows" json:"max_rows,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueFetchQueuesRequest) Reset()         { *m = TaskQueueFetchQueuesRequest{} }
func (m *TaskQueueFetchQueuesRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchQueuesRequest) ProtoMessage()    {}

func (m *TaskQueueFetchQueuesRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueFetchQueuesRequest) GetMaxRows() int32 {
	if m != nil && m.MaxRows != nil {
		return *m.MaxRows
	}
	return 0
}

type TaskQueueFetchQueuesResponse struct {
	Queue            []*TaskQueueFetchQueuesResponse_Queue `protobuf:"group,1,rep" json:"queue,omitempty"`
	XXX_unrecognized []byte                                `json:"-"`
}

func (m *TaskQueueFetchQueuesResponse) Reset()         { *m = TaskQueueFetchQueuesResponse{} }
func (m *TaskQueueFetchQueuesResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchQueuesResponse) ProtoMessage()    {}

func (m *TaskQueueFetchQueuesResponse) GetQueue() []*TaskQueueFetchQueuesResponse_Queue {
	if m != nil {
		return m.Queue
	}
	return nil
}

type TaskQueueFetchQueuesResponse_Queue struct {
	QueueName             []byte                    `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	BucketRefillPerSecond *float64                  `protobuf:"fixed64,3,req,name=bucket_refill_per_second" json:"bucket_refill_per_second,omitempty"`
	BucketCapacity        *float64                  `protobuf:"fixed64,4,req,name=bucket_capacity" json:"bucket_capacity,omitempty"`
	UserSpecifiedRate     *string                   `protobuf:"bytes,5,opt,name=user_specified_rate" json:"user_specified_rate,omitempty"`
	Paused                *bool                     `protobuf:"varint,6,req,name=paused,def=0" json:"paused,omitempty"`
	RetryParameters       *TaskQueueRetryParameters `protobuf:"bytes,7,opt,name=retry_parameters" json:"retry_parameters,omitempty"`
	MaxConcurrentRequests *int32                    `protobuf:"varint,8,opt,name=max_concurrent_requests" json:"max_concurrent_requests,omitempty"`
	Mode                  *TaskQueueMode_Mode       `protobuf:"varint,9,opt,name=mode,enum=appengine.TaskQueueMode_Mode,def=0" json:"mode,omitempty"`
	Acl                   *TaskQueueAcl             `protobuf:"bytes,10,opt,name=acl" json:"acl,omitempty"`
	HeaderOverride        []*TaskQueueHttpHeader    `protobuf:"bytes,11,rep,name=header_override" json:"header_override,omitempty"`
	CreatorName           *string                   `protobuf:"bytes,12,opt,name=creator_name,def=apphosting" json:"creator_name,omitempty"`
	XXX_unrecognized      []byte                    `json:"-"`
}

func (m *TaskQueueFetchQueuesResponse_Queue) Reset()         { *m = TaskQueueFetchQueuesResponse_Queue{} }
func (m *TaskQueueFetchQueuesResponse_Queue) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchQueuesResponse_Queue) ProtoMessage()    {}

const Default_TaskQueueFetchQueuesResponse_Queue_Paused bool = false
const Default_TaskQueueFetchQueuesResponse_Queue_Mode TaskQueueMode_Mode = TaskQueueMode_PUSH
const Default_TaskQueueFetchQueuesResponse_Queue_CreatorName string = "apphosting"

func (m *TaskQueueFetchQueuesResponse_Queue) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetBucketRefillPerSecond() float64 {
	if m != nil && m.BucketRefillPerSecond != nil {
		return *m.BucketRefillPerSecond
	}
	return 0
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetBucketCapacity() float64 {
	if m != nil && m.BucketCapacity != nil {
		return *m.BucketCapacity
	}
	return 0
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetUserSpecifiedRate() string {
	if m != nil && m.UserSpecifiedRate != nil {
		return *m.UserSpecifiedRate
	}
	return ""
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetPaused() bool {
	if m != nil && m.Paused != nil {
		return *m.Paused
	}
	return Default_TaskQueueFetchQueuesResponse_Queue_Paused
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetRetryParameters() *TaskQueueRetryParameters {
	if m != nil {
		return m.RetryParameters
	}
	return nil
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetMaxConcurrentRequests() int32 {
	if m != nil && m.MaxConcurrentRequests != nil {
		return *m.MaxConcurrentRequests
	}
	return 0
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetMode() TaskQueueMode_Mode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return Default_TaskQueueFetchQueuesResponse_Queue_Mode
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetAcl() *TaskQueueAcl {
	if m != nil {
		return m.Acl
	}
	return nil
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetHeaderOverride() []*TaskQueueHttpHeader {
	if m != nil {
		return m.HeaderOverride
	}
	return nil
}

func (m *TaskQueueFetchQueuesResponse_Queue) GetCreatorName() string {
	if m != nil && m.CreatorName != nil {
		return *m.CreatorName
	}
	return Default_TaskQueueFetchQueuesResponse_Queue_CreatorName
}

type TaskQueueFetchQueueStatsRequest struct {
	AppId            []byte   `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName        [][]byte `protobuf:"bytes,2,rep,name=queue_name" json:"queue_name,omitempty"`
	MaxNumTasks      *int32   `protobuf:"varint,3,opt,name=max_num_tasks,def=0" json:"max_num_tasks,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueFetchQueueStatsRequest) Reset()         { *m = TaskQueueFetchQueueStatsRequest{} }
func (m *TaskQueueFetchQueueStatsRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchQueueStatsRequest) ProtoMessage()    {}

const Default_TaskQueueFetchQueueStatsRequest_MaxNumTasks int32 = 0

func (m *TaskQueueFetchQueueStatsRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueFetchQueueStatsRequest) GetQueueName() [][]byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueFetchQueueStatsRequest) GetMaxNumTasks() int32 {
	if m != nil && m.MaxNumTasks != nil {
		return *m.MaxNumTasks
	}
	return Default_TaskQueueFetchQueueStatsRequest_MaxNumTasks
}

type TaskQueueScannerQueueInfo struct {
	ExecutedLastMinute      *int64   `protobuf:"varint,1,req,name=executed_last_minute" json:"executed_last_minute,omitempty"`
	ExecutedLastHour        *int64   `protobuf:"varint,2,req,name=executed_last_hour" json:"executed_last_hour,omitempty"`
	SamplingDurationSeconds *float64 `protobuf:"fixed64,3,req,name=sampling_duration_seconds" json:"sampling_duration_seconds,omitempty"`
	RequestsInFlight        *int32   `protobuf:"varint,4,opt,name=requests_in_flight" json:"requests_in_flight,omitempty"`
	EnforcedRate            *float64 `protobuf:"fixed64,5,opt,name=enforced_rate" json:"enforced_rate,omitempty"`
	XXX_unrecognized        []byte   `json:"-"`
}

func (m *TaskQueueScannerQueueInfo) Reset()         { *m = TaskQueueScannerQueueInfo{} }
func (m *TaskQueueScannerQueueInfo) String() string { return proto.CompactTextString(m) }
func (*TaskQueueScannerQueueInfo) ProtoMessage()    {}

func (m *TaskQueueScannerQueueInfo) GetExecutedLastMinute() int64 {
	if m != nil && m.ExecutedLastMinute != nil {
		return *m.ExecutedLastMinute
	}
	return 0
}

func (m *TaskQueueScannerQueueInfo) GetExecutedLastHour() int64 {
	if m != nil && m.ExecutedLastHour != nil {
		return *m.ExecutedLastHour
	}
	return 0
}

func (m *TaskQueueScannerQueueInfo) GetSamplingDurationSeconds() float64 {
	if m != nil && m.SamplingDurationSeconds != nil {
		return *m.SamplingDurationSeconds
	}
	return 0
}

func (m *TaskQueueScannerQueueInfo) GetRequestsInFlight() int32 {
	if m != nil && m.RequestsInFlight != nil {
		return *m.RequestsInFlight
	}
	return 0
}

func (m *TaskQueueScannerQueueInfo) GetEnforcedRate() float64 {
	if m != nil && m.EnforcedRate != nil {
		return *m.EnforcedRate
	}
	return 0
}

type TaskQueueFetchQueueStatsResponse struct {
	Queuestats       []*TaskQueueFetchQueueStatsResponse_QueueStats `protobuf:"group,1,rep,name=QueueStats" json:"queuestats,omitempty"`
	XXX_unrecognized []byte                                         `json:"-"`
}

func (m *TaskQueueFetchQueueStatsResponse) Reset()         { *m = TaskQueueFetchQueueStatsResponse{} }
func (m *TaskQueueFetchQueueStatsResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchQueueStatsResponse) ProtoMessage()    {}

func (m *TaskQueueFetchQueueStatsResponse) GetQueuestats() []*TaskQueueFetchQueueStatsResponse_QueueStats {
	if m != nil {
		return m.Queuestats
	}
	return nil
}

type TaskQueueFetchQueueStatsResponse_QueueStats struct {
	NumTasks         *int32                     `protobuf:"varint,2,req,name=num_tasks" json:"num_tasks,omitempty"`
	OldestEtaUsec    *int64                     `protobuf:"varint,3,req,name=oldest_eta_usec" json:"oldest_eta_usec,omitempty"`
	ScannerInfo      *TaskQueueScannerQueueInfo `protobuf:"bytes,4,opt,name=scanner_info" json:"scanner_info,omitempty"`
	XXX_unrecognized []byte                     `json:"-"`
}

func (m *TaskQueueFetchQueueStatsResponse_QueueStats) Reset() {
	*m = TaskQueueFetchQueueStatsResponse_QueueStats{}
}
func (m *TaskQueueFetchQueueStatsResponse_QueueStats) String() string {
	return proto.CompactTextString(m)
}
func (*TaskQueueFetchQueueStatsResponse_QueueStats) ProtoMessage() {}

func (m *TaskQueueFetchQueueStatsResponse_QueueStats) GetNumTasks() int32 {
	if m != nil && m.NumTasks != nil {
		return *m.NumTasks
	}
	return 0
}

func (m *TaskQueueFetchQueueStatsResponse_QueueStats) GetOldestEtaUsec() int64 {
	if m != nil && m.OldestEtaUsec != nil {
		return *m.OldestEtaUsec
	}
	return 0
}

func (m *TaskQueueFetchQueueStatsResponse_QueueStats) GetScannerInfo() *TaskQueueScannerQueueInfo {
	if m != nil {
		return m.ScannerInfo
	}
	return nil
}

type TaskQueuePauseQueueRequest struct {
	AppId            []byte `protobuf:"bytes,1,req,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	Pause            *bool  `protobuf:"varint,3,req,name=pause" json:"pause,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueuePauseQueueRequest) Reset()         { *m = TaskQueuePauseQueueRequest{} }
func (m *TaskQueuePauseQueueRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueuePauseQueueRequest) ProtoMessage()    {}

func (m *TaskQueuePauseQueueRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueuePauseQueueRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueuePauseQueueRequest) GetPause() bool {
	if m != nil && m.Pause != nil {
		return *m.Pause
	}
	return false
}

type TaskQueuePauseQueueResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueuePauseQueueResponse) Reset()         { *m = TaskQueuePauseQueueResponse{} }
func (m *TaskQueuePauseQueueResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueuePauseQueueResponse) ProtoMessage()    {}

type TaskQueuePurgeQueueRequest struct {
	AppId            []byte `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueuePurgeQueueRequest) Reset()         { *m = TaskQueuePurgeQueueRequest{} }
func (m *TaskQueuePurgeQueueRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueuePurgeQueueRequest) ProtoMessage()    {}

func (m *TaskQueuePurgeQueueRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueuePurgeQueueRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

type TaskQueuePurgeQueueResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueuePurgeQueueResponse) Reset()         { *m = TaskQueuePurgeQueueResponse{} }
func (m *TaskQueuePurgeQueueResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueuePurgeQueueResponse) ProtoMessage()    {}

type TaskQueueDeleteQueueRequest struct {
	AppId            []byte `protobuf:"bytes,1,req,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueDeleteQueueRequest) Reset()         { *m = TaskQueueDeleteQueueRequest{} }
func (m *TaskQueueDeleteQueueRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteQueueRequest) ProtoMessage()    {}

func (m *TaskQueueDeleteQueueRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueDeleteQueueRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

type TaskQueueDeleteQueueResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueDeleteQueueResponse) Reset()         { *m = TaskQueueDeleteQueueResponse{} }
func (m *TaskQueueDeleteQueueResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteQueueResponse) ProtoMessage()    {}

type TaskQueueDeleteGroupRequest struct {
	AppId            []byte `protobuf:"bytes,1,req,name=app_id" json:"app_id,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueDeleteGroupRequest) Reset()         { *m = TaskQueueDeleteGroupRequest{} }
func (m *TaskQueueDeleteGroupRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteGroupRequest) ProtoMessage()    {}

func (m *TaskQueueDeleteGroupRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

type TaskQueueDeleteGroupResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueDeleteGroupResponse) Reset()         { *m = TaskQueueDeleteGroupResponse{} }
func (m *TaskQueueDeleteGroupResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueDeleteGroupResponse) ProtoMessage()    {}

type TaskQueueQueryTasksRequest struct {
	AppId            []byte `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	StartTaskName    []byte `protobuf:"bytes,3,opt,name=start_task_name" json:"start_task_name,omitempty"`
	StartEtaUsec     *int64 `protobuf:"varint,4,opt,name=start_eta_usec" json:"start_eta_usec,omitempty"`
	StartTag         []byte `protobuf:"bytes,6,opt,name=start_tag" json:"start_tag,omitempty"`
	MaxRows          *int32 `protobuf:"varint,5,opt,name=max_rows,def=1" json:"max_rows,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueQueryTasksRequest) Reset()         { *m = TaskQueueQueryTasksRequest{} }
func (m *TaskQueueQueryTasksRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryTasksRequest) ProtoMessage()    {}

const Default_TaskQueueQueryTasksRequest_MaxRows int32 = 1

func (m *TaskQueueQueryTasksRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueQueryTasksRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueQueryTasksRequest) GetStartTaskName() []byte {
	if m != nil {
		return m.StartTaskName
	}
	return nil
}

func (m *TaskQueueQueryTasksRequest) GetStartEtaUsec() int64 {
	if m != nil && m.StartEtaUsec != nil {
		return *m.StartEtaUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksRequest) GetStartTag() []byte {
	if m != nil {
		return m.StartTag
	}
	return nil
}

func (m *TaskQueueQueryTasksRequest) GetMaxRows() int32 {
	if m != nil && m.MaxRows != nil {
		return *m.MaxRows
	}
	return Default_TaskQueueQueryTasksRequest_MaxRows
}

type TaskQueueQueryTasksResponse struct {
	Task             []*TaskQueueQueryTasksResponse_Task `protobuf:"group,1,rep" json:"task,omitempty"`
	XXX_unrecognized []byte                              `json:"-"`
}

func (m *TaskQueueQueryTasksResponse) Reset()         { *m = TaskQueueQueryTasksResponse{} }
func (m *TaskQueueQueryTasksResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryTasksResponse) ProtoMessage()    {}

func (m *TaskQueueQueryTasksResponse) GetTask() []*TaskQueueQueryTasksResponse_Task {
	if m != nil {
		return m.Task
	}
	return nil
}

type TaskQueueQueryTasksResponse_Task struct {
	TaskName         []byte                                          `protobuf:"bytes,2,req,name=task_name" json:"task_name,omitempty"`
	EtaUsec          *int64                                          `protobuf:"varint,3,req,name=eta_usec" json:"eta_usec,omitempty"`
	Url              []byte                                          `protobuf:"bytes,4,opt,name=url" json:"url,omitempty"`
	Method           *TaskQueueQueryTasksResponse_Task_RequestMethod `protobuf:"varint,5,opt,name=method,enum=appengine.TaskQueueQueryTasksResponse_Task_RequestMethod" json:"method,omitempty"`
	RetryCount       *int32                                          `protobuf:"varint,6,opt,name=retry_count,def=0" json:"retry_count,omitempty"`
	Header           []*TaskQueueQueryTasksResponse_Task_Header      `protobuf:"group,7,rep" json:"header,omitempty"`
	BodySize         *int32                                          `protobuf:"varint,10,opt,name=body_size" json:"body_size,omitempty"`
	Body             []byte                                          `protobuf:"bytes,11,opt,name=body" json:"body,omitempty"`
	CreationTimeUsec *int64                                          `protobuf:"varint,12,req,name=creation_time_usec" json:"creation_time_usec,omitempty"`
	Crontimetable    *TaskQueueQueryTasksResponse_Task_CronTimetable `protobuf:"group,13,opt,name=CronTimetable" json:"crontimetable,omitempty"`
	Runlog           *TaskQueueQueryTasksResponse_Task_RunLog        `protobuf:"group,16,opt,name=RunLog" json:"runlog,omitempty"`
	Description      []byte                                          `protobuf:"bytes,21,opt,name=description" json:"description,omitempty"`
	Payload          *TaskPayload                                    `protobuf:"bytes,22,opt,name=payload" json:"payload,omitempty"`
	RetryParameters  *TaskQueueRetryParameters                       `protobuf:"bytes,23,opt,name=retry_parameters" json:"retry_parameters,omitempty"`
	FirstTryUsec     *int64                                          `protobuf:"varint,24,opt,name=first_try_usec" json:"first_try_usec,omitempty"`
	Tag              []byte                                          `protobuf:"bytes,25,opt,name=tag" json:"tag,omitempty"`
	ExecutionCount   *int32                                          `protobuf:"varint,26,opt,name=execution_count,def=0" json:"execution_count,omitempty"`
	XXX_unrecognized []byte                                          `json:"-"`
}

func (m *TaskQueueQueryTasksResponse_Task) Reset()         { *m = TaskQueueQueryTasksResponse_Task{} }
func (m *TaskQueueQueryTasksResponse_Task) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryTasksResponse_Task) ProtoMessage()    {}

const Default_TaskQueueQueryTasksResponse_Task_RetryCount int32 = 0
const Default_TaskQueueQueryTasksResponse_Task_ExecutionCount int32 = 0

func (m *TaskQueueQueryTasksResponse_Task) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetEtaUsec() int64 {
	if m != nil && m.EtaUsec != nil {
		return *m.EtaUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task) GetUrl() []byte {
	if m != nil {
		return m.Url
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetMethod() TaskQueueQueryTasksResponse_Task_RequestMethod {
	if m != nil && m.Method != nil {
		return *m.Method
	}
	return TaskQueueQueryTasksResponse_Task_GET
}

func (m *TaskQueueQueryTasksResponse_Task) GetRetryCount() int32 {
	if m != nil && m.RetryCount != nil {
		return *m.RetryCount
	}
	return Default_TaskQueueQueryTasksResponse_Task_RetryCount
}

func (m *TaskQueueQueryTasksResponse_Task) GetHeader() []*TaskQueueQueryTasksResponse_Task_Header {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetBodySize() int32 {
	if m != nil && m.BodySize != nil {
		return *m.BodySize
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetCreationTimeUsec() int64 {
	if m != nil && m.CreationTimeUsec != nil {
		return *m.CreationTimeUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task) GetCrontimetable() *TaskQueueQueryTasksResponse_Task_CronTimetable {
	if m != nil {
		return m.Crontimetable
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetRunlog() *TaskQueueQueryTasksResponse_Task_RunLog {
	if m != nil {
		return m.Runlog
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetDescription() []byte {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetPayload() *TaskPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetRetryParameters() *TaskQueueRetryParameters {
	if m != nil {
		return m.RetryParameters
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetFirstTryUsec() int64 {
	if m != nil && m.FirstTryUsec != nil {
		return *m.FirstTryUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task) GetTag() []byte {
	if m != nil {
		return m.Tag
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task) GetExecutionCount() int32 {
	if m != nil && m.ExecutionCount != nil {
		return *m.ExecutionCount
	}
	return Default_TaskQueueQueryTasksResponse_Task_ExecutionCount
}

type TaskQueueQueryTasksResponse_Task_Header struct {
	Key              []byte `protobuf:"bytes,8,req,name=key" json:"key,omitempty"`
	Value            []byte `protobuf:"bytes,9,req,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueQueryTasksResponse_Task_Header) Reset() {
	*m = TaskQueueQueryTasksResponse_Task_Header{}
}
func (m *TaskQueueQueryTasksResponse_Task_Header) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryTasksResponse_Task_Header) ProtoMessage()    {}

func (m *TaskQueueQueryTasksResponse_Task_Header) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task_Header) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

type TaskQueueQueryTasksResponse_Task_CronTimetable struct {
	Schedule         []byte `protobuf:"bytes,14,req,name=schedule" json:"schedule,omitempty"`
	Timezone         []byte `protobuf:"bytes,15,req,name=timezone" json:"timezone,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueQueryTasksResponse_Task_CronTimetable) Reset() {
	*m = TaskQueueQueryTasksResponse_Task_CronTimetable{}
}
func (m *TaskQueueQueryTasksResponse_Task_CronTimetable) String() string {
	return proto.CompactTextString(m)
}
func (*TaskQueueQueryTasksResponse_Task_CronTimetable) ProtoMessage() {}

func (m *TaskQueueQueryTasksResponse_Task_CronTimetable) GetSchedule() []byte {
	if m != nil {
		return m.Schedule
	}
	return nil
}

func (m *TaskQueueQueryTasksResponse_Task_CronTimetable) GetTimezone() []byte {
	if m != nil {
		return m.Timezone
	}
	return nil
}

type TaskQueueQueryTasksResponse_Task_RunLog struct {
	DispatchedUsec   *int64  `protobuf:"varint,17,req,name=dispatched_usec" json:"dispatched_usec,omitempty"`
	LagUsec          *int64  `protobuf:"varint,18,req,name=lag_usec" json:"lag_usec,omitempty"`
	ElapsedUsec      *int64  `protobuf:"varint,19,req,name=elapsed_usec" json:"elapsed_usec,omitempty"`
	ResponseCode     *int64  `protobuf:"varint,20,opt,name=response_code" json:"response_code,omitempty"`
	RetryReason      *string `protobuf:"bytes,27,opt,name=retry_reason" json:"retry_reason,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) Reset() {
	*m = TaskQueueQueryTasksResponse_Task_RunLog{}
}
func (m *TaskQueueQueryTasksResponse_Task_RunLog) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryTasksResponse_Task_RunLog) ProtoMessage()    {}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) GetDispatchedUsec() int64 {
	if m != nil && m.DispatchedUsec != nil {
		return *m.DispatchedUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) GetLagUsec() int64 {
	if m != nil && m.LagUsec != nil {
		return *m.LagUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) GetElapsedUsec() int64 {
	if m != nil && m.ElapsedUsec != nil {
		return *m.ElapsedUsec
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) GetResponseCode() int64 {
	if m != nil && m.ResponseCode != nil {
		return *m.ResponseCode
	}
	return 0
}

func (m *TaskQueueQueryTasksResponse_Task_RunLog) GetRetryReason() string {
	if m != nil && m.RetryReason != nil {
		return *m.RetryReason
	}
	return ""
}

type TaskQueueFetchTaskRequest struct {
	AppId            []byte `protobuf:"bytes,1,opt,name=app_id" json:"app_id,omitempty"`
	QueueName        []byte `protobuf:"bytes,2,req,name=queue_name" json:"queue_name,omitempty"`
	TaskName         []byte `protobuf:"bytes,3,req,name=task_name" json:"task_name,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueFetchTaskRequest) Reset()         { *m = TaskQueueFetchTaskRequest{} }
func (m *TaskQueueFetchTaskRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchTaskRequest) ProtoMessage()    {}

func (m *TaskQueueFetchTaskRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueFetchTaskRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueFetchTaskRequest) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

type TaskQueueFetchTaskResponse struct {
	Task             *TaskQueueQueryTasksResponse `protobuf:"bytes,1,req,name=task" json:"task,omitempty"`
	XXX_unrecognized []byte                       `json:"-"`
}

func (m *TaskQueueFetchTaskResponse) Reset()         { *m = TaskQueueFetchTaskResponse{} }
func (m *TaskQueueFetchTaskResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueFetchTaskResponse) ProtoMessage()    {}

func (m *TaskQueueFetchTaskResponse) GetTask() *TaskQueueQueryTasksResponse {
	if m != nil {
		return m.Task
	}
	return nil
}

type TaskQueueUpdateStorageLimitRequest struct {
	AppId            []byte `protobuf:"bytes,1,req,name=app_id" json:"app_id,omitempty"`
	Limit            *int64 `protobuf:"varint,2,req,name=limit" json:"limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueUpdateStorageLimitRequest) Reset()         { *m = TaskQueueUpdateStorageLimitRequest{} }
func (m *TaskQueueUpdateStorageLimitRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueUpdateStorageLimitRequest) ProtoMessage()    {}

func (m *TaskQueueUpdateStorageLimitRequest) GetAppId() []byte {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *TaskQueueUpdateStorageLimitRequest) GetLimit() int64 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

type TaskQueueUpdateStorageLimitResponse struct {
	NewLimit         *int64 `protobuf:"varint,1,req,name=new_limit" json:"new_limit,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueUpdateStorageLimitResponse) Reset()         { *m = TaskQueueUpdateStorageLimitResponse{} }
func (m *TaskQueueUpdateStorageLimitResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueUpdateStorageLimitResponse) ProtoMessage()    {}

func (m *TaskQueueUpdateStorageLimitResponse) GetNewLimit() int64 {
	if m != nil && m.NewLimit != nil {
		return *m.NewLimit
	}
	return 0
}

type TaskQueueQueryAndOwnTasksRequest struct {
	QueueName        []byte   `protobuf:"bytes,1,req,name=queue_name" json:"queue_name,omitempty"`
	LeaseSeconds     *float64 `protobuf:"fixed64,2,req,name=lease_seconds" json:"lease_seconds,omitempty"`
	MaxTasks         *int64   `protobuf:"varint,3,req,name=max_tasks" json:"max_tasks,omitempty"`
	GroupByTag       *bool    `protobuf:"varint,4,opt,name=group_by_tag,def=0" json:"group_by_tag,omitempty"`
	Tag              []byte   `protobuf:"bytes,5,opt,name=tag" json:"tag,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueQueryAndOwnTasksRequest) Reset()         { *m = TaskQueueQueryAndOwnTasksRequest{} }
func (m *TaskQueueQueryAndOwnTasksRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryAndOwnTasksRequest) ProtoMessage()    {}

const Default_TaskQueueQueryAndOwnTasksRequest_GroupByTag bool = false

func (m *TaskQueueQueryAndOwnTasksRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueQueryAndOwnTasksRequest) GetLeaseSeconds() float64 {
	if m != nil && m.LeaseSeconds != nil {
		return *m.LeaseSeconds
	}
	return 0
}

func (m *TaskQueueQueryAndOwnTasksRequest) GetMaxTasks() int64 {
	if m != nil && m.MaxTasks != nil {
		return *m.MaxTasks
	}
	return 0
}

func (m *TaskQueueQueryAndOwnTasksRequest) GetGroupByTag() bool {
	if m != nil && m.GroupByTag != nil {
		return *m.GroupByTag
	}
	return Default_TaskQueueQueryAndOwnTasksRequest_GroupByTag
}

func (m *TaskQueueQueryAndOwnTasksRequest) GetTag() []byte {
	if m != nil {
		return m.Tag
	}
	return nil
}

type TaskQueueQueryAndOwnTasksResponse struct {
	Task             []*TaskQueueQueryAndOwnTasksResponse_Task `protobuf:"group,1,rep" json:"task,omitempty"`
	XXX_unrecognized []byte                                    `json:"-"`
}

func (m *TaskQueueQueryAndOwnTasksResponse) Reset()         { *m = TaskQueueQueryAndOwnTasksResponse{} }
func (m *TaskQueueQueryAndOwnTasksResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryAndOwnTasksResponse) ProtoMessage()    {}

func (m *TaskQueueQueryAndOwnTasksResponse) GetTask() []*TaskQueueQueryAndOwnTasksResponse_Task {
	if m != nil {
		return m.Task
	}
	return nil
}

type TaskQueueQueryAndOwnTasksResponse_Task struct {
	TaskName         []byte `protobuf:"bytes,2,req,name=task_name" json:"task_name,omitempty"`
	EtaUsec          *int64 `protobuf:"varint,3,req,name=eta_usec" json:"eta_usec,omitempty"`
	RetryCount       *int32 `protobuf:"varint,4,opt,name=retry_count,def=0" json:"retry_count,omitempty"`
	Body             []byte `protobuf:"bytes,5,opt,name=body" json:"body,omitempty"`
	Tag              []byte `protobuf:"bytes,6,opt,name=tag" json:"tag,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueQueryAndOwnTasksResponse_Task) Reset() {
	*m = TaskQueueQueryAndOwnTasksResponse_Task{}
}
func (m *TaskQueueQueryAndOwnTasksResponse_Task) String() string { return proto.CompactTextString(m) }
func (*TaskQueueQueryAndOwnTasksResponse_Task) ProtoMessage()    {}

const Default_TaskQueueQueryAndOwnTasksResponse_Task_RetryCount int32 = 0

func (m *TaskQueueQueryAndOwnTasksResponse_Task) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

func (m *TaskQueueQueryAndOwnTasksResponse_Task) GetEtaUsec() int64 {
	if m != nil && m.EtaUsec != nil {
		return *m.EtaUsec
	}
	return 0
}

func (m *TaskQueueQueryAndOwnTasksResponse_Task) GetRetryCount() int32 {
	if m != nil && m.RetryCount != nil {
		return *m.RetryCount
	}
	return Default_TaskQueueQueryAndOwnTasksResponse_Task_RetryCount
}

func (m *TaskQueueQueryAndOwnTasksResponse_Task) GetBody() []byte {
	if m != nil {
		return m.Body
	}
	return nil
}

func (m *TaskQueueQueryAndOwnTasksResponse_Task) GetTag() []byte {
	if m != nil {
		return m.Tag
	}
	return nil
}

type TaskQueueModifyTaskLeaseRequest struct {
	QueueName        []byte   `protobuf:"bytes,1,req,name=queue_name" json:"queue_name,omitempty"`
	TaskName         []byte   `protobuf:"bytes,2,req,name=task_name" json:"task_name,omitempty"`
	EtaUsec          *int64   `protobuf:"varint,3,req,name=eta_usec" json:"eta_usec,omitempty"`
	LeaseSeconds     *float64 `protobuf:"fixed64,4,req,name=lease_seconds" json:"lease_seconds,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TaskQueueModifyTaskLeaseRequest) Reset()         { *m = TaskQueueModifyTaskLeaseRequest{} }
func (m *TaskQueueModifyTaskLeaseRequest) String() string { return proto.CompactTextString(m) }
func (*TaskQueueModifyTaskLeaseRequest) ProtoMessage()    {}

func (m *TaskQueueModifyTaskLeaseRequest) GetQueueName() []byte {
	if m != nil {
		return m.QueueName
	}
	return nil
}

func (m *TaskQueueModifyTaskLeaseRequest) GetTaskName() []byte {
	if m != nil {
		return m.TaskName
	}
	return nil
}

func (m *TaskQueueModifyTaskLeaseRequest) GetEtaUsec() int64 {
	if m != nil && m.EtaUsec != nil {
		return *m.EtaUsec
	}
	return 0
}

func (m *TaskQueueModifyTaskLeaseRequest) GetLeaseSeconds() float64 {
	if m != nil && m.LeaseSeconds != nil {
		return *m.LeaseSeconds
	}
	return 0
}

type TaskQueueModifyTaskLeaseResponse struct {
	UpdatedEtaUsec   *int64 `protobuf:"varint,1,req,name=updated_eta_usec" json:"updated_eta_usec,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *TaskQueueModifyTaskLeaseResponse) Reset()         { *m = TaskQueueModifyTaskLeaseResponse{} }
func (m *TaskQueueModifyTaskLeaseResponse) String() string { return proto.CompactTextString(m) }
func (*TaskQueueModifyTaskLeaseResponse) ProtoMessage()    {}

func (m *TaskQueueModifyTaskLeaseResponse) GetUpdatedEtaUsec() int64 {
	if m != nil && m.UpdatedEtaUsec != nil {
		return *m.UpdatedEtaUsec
	}
	return 0
}

func init() {
}
