// Code generated by smithy-go-codegen DO NOT EDIT.

package appconfig

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/appconfig/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the configuration profiles for an application.
func (c *Client) ListConfigurationProfiles(ctx context.Context, params *ListConfigurationProfilesInput, optFns ...func(*Options)) (*ListConfigurationProfilesOutput, error) {
	if params == nil {
		params = &ListConfigurationProfilesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListConfigurationProfiles", params, optFns, c.addOperationListConfigurationProfilesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListConfigurationProfilesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListConfigurationProfilesInput struct {

	// The application ID.
	//
	// This member is required.
	ApplicationId *string

	// The maximum number of items to return for this call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	MaxResults *int32

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string

	// A filter based on the type of configurations that the configuration profile
	// contains. A configuration can be a feature flag or a freeform configuration.
	Type *string

	noSmithyDocumentSerde
}

type ListConfigurationProfilesOutput struct {

	// The elements from this collection.
	Items []types.ConfigurationProfileSummary

	// The token for the next set of items to return. Use this token to get the next
	// set of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListConfigurationProfilesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListConfigurationProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListConfigurationProfiles{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListConfigurationProfiles"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListConfigurationProfilesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListConfigurationProfiles(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListConfigurationProfilesAPIClient is a client that implements the
// ListConfigurationProfiles operation.
type ListConfigurationProfilesAPIClient interface {
	ListConfigurationProfiles(context.Context, *ListConfigurationProfilesInput, ...func(*Options)) (*ListConfigurationProfilesOutput, error)
}

var _ ListConfigurationProfilesAPIClient = (*Client)(nil)

// ListConfigurationProfilesPaginatorOptions is the paginator options for
// ListConfigurationProfiles
type ListConfigurationProfilesPaginatorOptions struct {
	// The maximum number of items to return for this call. The call also returns a
	// token that you can specify in a subsequent call to get the next set of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListConfigurationProfilesPaginator is a paginator for ListConfigurationProfiles
type ListConfigurationProfilesPaginator struct {
	options   ListConfigurationProfilesPaginatorOptions
	client    ListConfigurationProfilesAPIClient
	params    *ListConfigurationProfilesInput
	nextToken *string
	firstPage bool
}

// NewListConfigurationProfilesPaginator returns a new
// ListConfigurationProfilesPaginator
func NewListConfigurationProfilesPaginator(client ListConfigurationProfilesAPIClient, params *ListConfigurationProfilesInput, optFns ...func(*ListConfigurationProfilesPaginatorOptions)) *ListConfigurationProfilesPaginator {
	if params == nil {
		params = &ListConfigurationProfilesInput{}
	}

	options := ListConfigurationProfilesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListConfigurationProfilesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListConfigurationProfilesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListConfigurationProfiles page.
func (p *ListConfigurationProfilesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListConfigurationProfilesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListConfigurationProfiles(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListConfigurationProfiles(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListConfigurationProfiles",
	}
}
