/*=========================================================================
 Authors: The GoFigure Dev. Team.
 at Megason Lab, Systems biology, Harvard Medical school, 2009-11

 Copyright (c) 2009-11, President and Fellows of Harvard College.
 All rights reserved.

 Redistribution and use in source and binary forms, with or without
 modification, are permitted provided that the following conditions are met:

 Redistributions of source code must retain the above copyright notice,
 this list of conditions and the following disclaimer.
 Redistributions in binary form must reproduce the above copyright notice,
 this list of conditions and the following disclaimer in the documentation
 and/or other materials provided with the distribution.
 Neither the name of the  President and Fellows of Harvard College
 nor the names of its contributors may be used to endorse or promote
 products derived from this software without specific prior written
 permission.

 THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
 OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/
#ifndef __QGoWizardDB_h
#define __QGoWizardDB_h

#include <QWizard>
#include <QLineEdit>
#include <QLabel>
#include <QRadioButton>
#include <QFormLayout>
#include <QGridLayout>
#include <QComboBox>
#include <QStringList>
#include <QString>
#include <QCheckBox>

#include <iostream>
#include <list>

#include "GoFigureFileInfoMultiIndexContainerHelper.h"
#include "QGoConnectServerPage.h"
#include "vtkMySQLDatabase.h"

#include "QGoGUILibConfigure.h"

/**
 * \class QGoWizardDB
 * \brief This class leads the user to chose its imagingsession and enables
 * to get the corresponding filenames from the database.
 * \sa QGoConnectServerPage
 * \sa QGoOpenCreateProjectPage
 * \sa QGoOpenCreateImgSessionPage
 * */
class QGOGUILIB_EXPORT QGoWizardDB:public QWizard
{
  Q_OBJECT
public:
  enum {
    ConnectServerPageID = 0,
    OpenOrCreateProjectPageID,
    OpenOrCreateImgSessionPageID,
    CreateImgSessionPageID
    };

  explicit QGoWizardDB(QWidget *parent = 0);
  ~QGoWizardDB(){}

  QString GetNameDB();

  QString GetServer();

  QString GetLogin();

  QString GetPassword();

  QString GetImagingSessionName();

  int GetImagingSessionID();

  bool GetIsAnOpenRecentFile();

  QPushButton *nextButton;

  /**
   * \brief return a list for each channel of the filenames for the images
   * in the database as a vector of vector
   */
  std::vector< std::vector< std::string > > GetFilenamesFromDB();

  GoFigureFileInfoHelperMultiIndexContainer GetMultiIndexFileContainer();

  std::string GetMegaCaptureHeaderFilename();

  void setImgSessionName(std::string iImgSessionName);

  std::string GetFirstFileName();

  void SetIsAnOpenRecentFile(bool iIsAnOpenRecentFile);

signals:
  void GofigureDatabaseExists();
  void NoGofigureDatabase();

protected:
  void closeEvent(QCloseEvent *iEvent);

  void SetFirstFileName();

  QGoConnectServerPage *m_ConnectServerPage;
  std::string           m_ImgSessionName;
  std::string           m_FirstFileName;
  int                   m_ImgSessionID;
  bool                  m_IsAnOpenRecentFile;
private:
  Q_DISABLE_COPY(QGoWizardDB);
};
#endif
