# Help FastAPI - Get Help { #help-fastapi-get-help }

Do you like **FastAPI**?

Would you like to help FastAPI, other users, and the author?

Or would you like to get help with **FastAPI**?

There are very simple ways to help (several involve just one or two clicks).

And there are several ways to get help too.

## Subscribe to the newsletter { #subscribe-to-the-newsletter }

You can subscribe to the (infrequent) [**FastAPI and friends** newsletter](newsletter.md){.internal-link target=_blank} to stay updated about:

* News about FastAPI and friends 🚀
* Guides 📝
* Features ✨
* Breaking changes 🚨
* Tips and tricks ✅

## Follow FastAPI on X (Twitter) { #follow-fastapi-on-x-twitter }

<a href="https://x.com/fastapi" class="external-link" target="_blank">Follow @fastapi on **X (Twitter)**</a> to get the latest news about **FastAPI**. 🐦

## Star **FastAPI** in GitHub { #star-fastapi-in-github }

You can "star" FastAPI in GitHub (clicking the star button at the top right): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

By adding a star, other users will be able to find it more easily and see that it has been already useful for others.

## Watch the GitHub repository for releases { #watch-the-github-repository-for-releases }

You can "watch" FastAPI in GitHub (clicking the "watch" button at the top right): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

There you can select "Releases only".

By doing it, you will receive notifications (in your email) whenever there's a new release (a new version) of **FastAPI** with bug fixes and new features.

## Connect with the author { #connect-with-the-author }

You can connect with <a href="https://tiangolo.com" class="external-link" target="_blank">me (Sebastián Ramírez / `tiangolo`)</a>, the author.

You can:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Follow me on **GitHub**</a>.
    * See other Open Source projects I have created that could help you.
    * Follow me to see when I create a new Open Source project.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Follow me on **X (Twitter)**</a> or <a href="https://fosstodon.org/@tiangolo" class="external-link" target="_blank">Mastodon</a>.
    * Tell me how you use FastAPI (I love to hear that).
    * Hear when I make announcements or release new tools.
    * You can also <a href="https://x.com/fastapi" class="external-link" target="_blank">follow @fastapi on X (Twitter)</a> (a separate account).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Follow me on **LinkedIn**</a>.
    * Hear when I make announcements or release new tools (although I use X (Twitter) more often 🤷‍♂).
* Read what I write (or follow me) on <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> or <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Read other ideas, articles, and read about tools I have created.
    * Follow me to read when I publish something new.

## Tweet about **FastAPI** { #tweet-about-fastapi }

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweet about **FastAPI**</a> and let me and others know why you like it. 🎉

I love to hear about how **FastAPI** is being used, what you have liked in it, in which project/company are you using it, etc.

## Vote for FastAPI { #vote-for-fastapi }

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Vote for **FastAPI** in Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/about/" class="external-link" target="_blank">Vote for **FastAPI** in AlternativeTo</a>.
* <a href="https://stackshare.io/pypi-fastapi" class="external-link" target="_blank">Say you use **FastAPI** on StackShare</a>.

## Help others with questions in GitHub { #help-others-with-questions-in-github }

You can try and help others with their questions in:

* <a href="https://github.com/fastapi/fastapi/discussions/categories/questions?discussions_q=category%3AQuestions+is%3Aunanswered" class="external-link" target="_blank">GitHub Discussions</a>
* <a href="https://github.com/fastapi/fastapi/issues?q=is%3Aissue+is%3Aopen+sort%3Aupdated-desc+label%3Aquestion+-label%3Aanswered+" class="external-link" target="_blank">GitHub Issues</a>

In many cases you might already know the answer for those questions. 🤓

If you are helping a lot of people with their questions, you will become an official [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}. 🎉

Just remember, the most important point is: try to be kind. People come with their frustrations and in many cases don't ask in the best way, but try as best as you can to be kind. 🤗

The idea is for the **FastAPI** community to be kind and welcoming. At the same time, don't accept bullying or disrespectful behavior towards others. We have to take care of each other.

---

Here's how to help others with questions (in discussions or issues):

### Understand the question { #understand-the-question }

* Check if you can understand what is the **purpose** and use case of the person asking.

* Then check if the question (the vast majority are questions) is **clear**.

* In many cases the question asked is about an imaginary solution from the user, but there might be a **better** one. If you can understand the problem and use case better, you might be able to suggest a better **alternative solution**.

* If you can't understand the question, ask for more **details**.

### Reproduce the problem { #reproduce-the-problem }

For most of the cases and most of the questions there's something related to the person's **original code**.

In many cases they will only copy a fragment of the code, but that's not enough to **reproduce the problem**.

* You can ask them to provide a <a href="https://stackoverflow.com/help/minimal-reproducible-example" class="external-link" target="_blank">minimal, reproducible, example</a>, that you can **copy-paste** and run locally to see the same error or behavior they are seeing, or to understand their use case better.

* If you are feeling too generous, you can try to **create an example** like that yourself, just based on the description of the problem. Just keep in mind that this might take a lot of time and it might be better to ask them to clarify the problem first.

### Suggest solutions { #suggest-solutions }

* After being able to understand the question, you can give them a possible **answer**.

* In many cases, it's better to understand their **underlying problem or use case**, because there might be a better way to solve it than what they are trying to do.

### Ask to close { #ask-to-close }

If they reply, there's a high chance you would have solved their problem, congrats, **you're a hero**! 🦸

* Now, if that solved their problem, you can ask them to:

    * In GitHub Discussions: mark the comment as the **answer**.
    * In GitHub Issues: **close** the issue.

## Watch the GitHub repository { #watch-the-github-repository }

You can "watch" FastAPI in GitHub (clicking the "watch" button at the top right): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

If you select "Watching" instead of "Releases only" you will receive notifications when someone creates a new issue or question. You can also specify that you only want to be notified about new issues, or discussions, or PRs, etc.

Then you can try and help them solve those questions.

## Ask Questions { #ask-questions }

You can <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">create a new question</a> in the GitHub repository, for example to:

* Ask a **question** or ask about a **problem**.
* Suggest a new **feature**.

**Note**: if you do it, then I'm going to ask you to also help others. 😉

## Review Pull Requests { #review-pull-requests }

You can help me review pull requests from others.

Again, please try your best to be kind. 🤗

---

Here's what to keep in mind and how to review a pull request:

### Understand the problem { #understand-the-problem }

* First, make sure you **understand the problem** that the pull request is trying to solve. It might have a longer discussion in a GitHub Discussion or issue.

* There's also a good chance that the pull request is not actually needed because the problem can be solved in a **different way**. Then you can suggest or ask about that.

### Don't worry about style { #dont-worry-about-style }

* Don't worry too much about things like commit message styles, I will squash and merge customizing the commit manually.

* Also don't worry about style rules, there are already automatized tools checking that.

And if there's any other style or consistency need, I'll ask directly for that, or I'll add commits on top with the needed changes.

### Check the code { #check-the-code }

* Check and read the code, see if it makes sense, **run it locally** and see if it actually solves the problem.

* Then **comment** saying that you did that, that's how I will know you really checked it.

/// info

Unfortunately, I can't simply trust PRs that just have several approvals.

Several times it has happened that there are PRs with 3, 5 or more approvals, probably because the description is appealing, but when I check the PRs, they are actually broken, have a bug, or don't solve the problem they claim to solve. 😅

So, it's really important that you actually read and run the code, and let me know in the comments that you did. 🤓

///

* If the PR can be simplified in a way, you can ask for that, but there's no need to be too picky, there might be a lot of subjective points of view (and I will have my own as well 🙈), so it's better if you can focus on the fundamental things.

### Tests { #tests }

* Help me check that the PR has **tests**.

* Check that the tests **fail** before the PR. 🚨

* Then check that the tests **pass** after the PR. ✅

* Many PRs don't have tests, you can **remind** them to add tests, or you can even **suggest** some tests yourself. That's one of the things that consume most time and you can help a lot with that.

* Then also comment what you tried, that way I'll know that you checked it. 🤓

## Create a Pull Request { #create-a-pull-request }

You can [contribute](contributing.md){.internal-link target=_blank} to the source code with Pull Requests, for example:

* To fix a typo you found on the documentation.
* To share an article, video, or podcast you created or found about FastAPI by <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">editing this file</a>.
    * Make sure you add your link to the start of the corresponding section.
* To help [translate the documentation](contributing.md#translations){.internal-link target=_blank} to your language.
    * You can also help to review the translations created by others.
* To propose new documentation sections.
* To fix an existing issue/bug.
    * Make sure to add tests.
* To add a new feature.
    * Make sure to add tests.
    * Make sure to add documentation if it's relevant.

## Help Maintain FastAPI { #help-maintain-fastapi }

Help me maintain **FastAPI**! 🤓

There's a lot of work to do, and for most of it, **YOU** can do it.

The main tasks that you can do right now are:

* [Help others with questions in GitHub](#help-others-with-questions-in-github){.internal-link target=_blank} (see the section above).
* [Review Pull Requests](#review-pull-requests){.internal-link target=_blank} (see the section above).

Those two tasks are what **consume time the most**. That's the main work of maintaining FastAPI.

If you can help me with that, **you are helping me maintain FastAPI** and making sure it keeps **advancing faster and better**. 🚀

## Join the chat { #join-the-chat }

Join the 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">Discord chat server</a> 👥 and hang out with others in the FastAPI community.

/// tip

For questions, ask them in <a href="https://github.com/fastapi/fastapi/discussions/new?category=questions" class="external-link" target="_blank">GitHub Discussions</a>, there's a much better chance you will receive help by the [FastAPI Experts](fastapi-people.md#fastapi-experts){.internal-link target=_blank}.

Use the chat only for other general conversations.

///

### Don't use the chat for questions { #dont-use-the-chat-for-questions }

Keep in mind that as chats allow more "free conversation", it's easy to ask questions that are too general and more difficult to answer, so, you might not receive answers.

In GitHub, the template will guide you to write the right question so that you can more easily get a good answer, or even solve the problem yourself even before asking. And in GitHub I can make sure I always answer everything, even if it takes some time. I can't personally do that with the chat systems. 😅

Conversations in the chat systems are also not as easily searchable as in GitHub, so questions and answers might get lost in the conversation. And only the ones in GitHub count to become a [FastAPI Expert](fastapi-people.md#fastapi-experts){.internal-link target=_blank}, so you will most probably receive more attention in GitHub.

On the other side, there are thousands of users in the chat systems, so there's a high chance you'll find someone to talk to there, almost all the time. 😄

## Sponsor the author { #sponsor-the-author }

If your **product/company** depends on or is related to **FastAPI** and you want to reach its users, you can sponsor the author (me) through <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>. Depending on the tier, you could get some extra benefits, like a badge in the docs. 🎁

---

Thanks! 🚀
