#ifndef LDAP_RBAC_H
#define LDAP_RBAC_H

/* extended operations for RBAC */
#define LDAP_RBAC_EXOP_CREATE_SESSION   "1.3.6.1.4.1.4203.555.1" /* RFC xxxx */
#define LDAP_RBAC_EXOP_CHECK_ACCESS     "1.3.6.1.4.1.4203.555.2"
#define LDAP_RBAC_EXOP_ADD_ACTIVE_ROLE  "1.3.6.1.4.1.4203.555.3"
#define LDAP_RBAC_EXOP_DROP_ACTIVE_ROLE "1.3.6.1.4.1.4203.555.4"
#define LDAP_RBAC_EXOP_DELETE_SESSION   "1.3.6.1.4.1.4203.555.5"
#define LDAP_RBAC_EXOP_SESSION_ROLES    "1.3.6.1.4.1.4203.555.6"
#define LDAP_RBAC_EXOP_SESSION_PERMISSIONS "1.3.6.1.4.1.4203.555.7"

#define LDAP_TAG_EXOP_RBAC_SESSION_ID ((ber_tag_t)0x80U)
#define LDAP_TAG_EXOP_RBAC_TENANT_ID ((ber_tag_t)0x81U)
#define LDAP_TAG_EXOP_RBAC_USER_ID ((ber_tag_t)0x82U)
#define LDAP_TAG_EXOP_RBAC_USER ((ber_tag_t)0x80U)
#define LDAP_TAG_EXOP_RBAC_AUTHTOK ((ber_tag_t)0x83U)
#define LDAP_TAG_EXOP_RBAC_ACTIVE_ROLE ((ber_tag_t)0xA4U)
#define LDAP_TAG_EXOP_RBAC_OPNAME ((ber_tag_t)0x81U)
#define LDAP_TAG_EXOP_RBAC_OBJNAME ((ber_tag_t)0x82U)
#define LDAP_TAG_EXOP_RBAC_OBJID ((ber_tag_t)0x83U)
#define LDAP_TAG_EXOP_RBAC_PWPOLICY_STATE ((ber_tag_t)0x85U)
#define LDAP_TAG_EXOP_RBAC_PWPOLICY_VALUE ((ber_tag_t)0x86U)
#define LDAP_TAG_EXOP_RBAC_ROLES ((ber_tag_t)0x04U)

#define LDAP_TAG_EXOP_RBAC_USER_ID_SESS	((ber_tag_t)0x80U)
#define LDAP_TAG_EXOP_RBAC_SESSION_ID_SESS	((ber_tag_t)0x81U)
#define LDAP_TAG_EXOP_RBAC_ROLE_NM_SESS	((ber_tag_t)0x82U)

#define RBAC_REQ_CREATE_SESSION      0
#define RBAC_REQ_CHECK_ACCESS        1
#define RBAC_REQ_ADD_ACTIVE_ROLE     2
#define RBAC_REQ_DROP_ACTIVE_ROLE    3
#define RBAC_REQ_DELETE_SESSION      4
#define RBAC_REQ_SESSION_PERMISSIONS 5
#define RBAC_REQ_SESSION_ROLES       6

/* defines for password policy */
#define RBAC_BIND_NEW_AUTHTOK_REQD 1

#define RBAC_PASSWORD_GOOD 0
#define RBAC_PASSWORD_EXPIRATION_WARNING 11
#define RBAC_PASSWORD_GRACE_WARNING 12
#define RBAC_PASSWORD_HAS_EXPIRED 100
#define RBAC_ACCOUNT_LOCKED 101
#define RBAC_CHANGE_AFTER_RESET 102
#define RBAC_NO_MODIFICATIONS 103
#define RBAC_MUST_SUPPLY_OLD 104
#define RBAC_INSUFFICIENT_QUALITY 105
#define RBAC_PASSWORD_TOO_SHORT 106
#define RBAC_PASSWORD_TOO_YOUNG 107
#define RBAC_HISTORY_VIOLATION 108
#define RBAC_ACCOUNT_LOCKED_CONSTRAINTS 109

#endif /* LDAP_RBAC_H */
